/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.DeniedAccessOnSharedMailboxException;
import org.apache.james.imap.message.response.ExistsResponse;
import org.apache.james.imap.message.response.ExpungeResponse;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.message.response.FlagsResponse;
import org.apache.james.imap.message.response.RecentResponse;
import org.apache.james.imap.message.response.VanishedResponse;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.base.AbstractChainedProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.FetchGroupImpl;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailboxProcessor<M extends ImapRequest>
extends AbstractChainedProcessor<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMailboxProcessor.class);
    public static final String IMAP_PREFIX = "IMAP-";
    private final MailboxManager mailboxManager;
    private final StatusResponseFactory factory;
    private final MetricFactory metricFactory;

    public AbstractMailboxProcessor(Class<M> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(acceptableClass, next);
        this.mailboxManager = mailboxManager;
        this.factory = factory;
        this.metricFactory = metricFactory;
    }

    @Override
    protected final void doProcess(M acceptableMessage, ImapProcessor.Responder responder, ImapSession session) {
        this.process(acceptableMessage, responder, session);
    }

    protected final void process(M message, ImapProcessor.Responder responder, ImapSession session) {
        ImapCommand command = message.getCommand();
        String tag = message.getTag();
        TimeMetric timeMetric = this.metricFactory.timer(IMAP_PREFIX + command.getName());
        this.doProcess(message, command, tag, responder, session);
        timeMetric.stopAndPublish();
    }

    final void doProcess(M message, ImapCommand command, String tag, ImapProcessor.Responder responder, ImapSession session) {
        try {
            if (!command.validForState(session.getState())) {
                StatusResponse response = this.factory.taggedNo(tag, command, HumanReadableText.INVALID_COMMAND);
                responder.respond(response);
            } else {
                this.getMailboxManager().startProcessingRequest(ImapSessionUtils.getMailboxSession(session));
                this.doProcess(message, session, tag, command, responder);
                this.getMailboxManager().endProcessingRequest(ImapSessionUtils.getMailboxSession(session));
            }
        }
        catch (DeniedAccessOnSharedMailboxException e) {
            this.no(command, tag, responder, HumanReadableText.DENIED_SHARED_MAILBOX);
        }
    }

    protected void flags(ImapProcessor.Responder responder, SelectedMailbox selected) {
        responder.respond(new FlagsResponse(selected.getApplicableFlags()));
    }

    protected void permanentFlags(ImapProcessor.Responder responder, MessageManager.MetaData metaData, SelectedMailbox selected) {
        Flags permanentFlags = metaData.getPermanentFlags();
        if (permanentFlags.contains(Flags.Flag.USER)) {
            permanentFlags.add(selected.getApplicableFlags());
        }
        StatusResponse untaggedOk = this.factory.untaggedOk(HumanReadableText.permanentFlags(permanentFlags), StatusResponse.ResponseCode.permanentFlags(permanentFlags));
        responder.respond(untaggedOk);
    }

    protected void unsolicitedResponses(ImapSession session, ImapProcessor.Responder responder, boolean useUids) {
        this.unsolicitedResponses(session, responder, false, useUids);
    }

    protected void unsolicitedResponses(ImapSession session, ImapProcessor.Responder responder, boolean omitExpunged, boolean useUid) {
        SelectedMailbox selected = session.getSelected();
        if (selected == null) {
            LOGGER.debug("No mailbox selected");
        } else {
            this.unsolicitedResponses(session, responder, selected, omitExpunged, useUid);
        }
    }

    private void unsolicitedResponses(ImapSession session, ImapProcessor.Responder responder, SelectedMailbox selected, boolean omitExpunged, boolean useUid) {
        Collection<MessageUid> expungedUids;
        boolean sizeChanged = selected.isSizeChanged();
        if (sizeChanged) {
            this.addExistsResponses(session, selected, responder);
        }
        if (!omitExpunged && !(expungedUids = selected.expungedUids()).isEmpty()) {
            if (EnableProcessor.getEnabledCapabilities(session).contains("QRESYNC")) {
                this.addVanishedResponse(selected, expungedUids, responder);
            } else {
                this.addExpungedResponses(selected, expungedUids, responder);
            }
            selected.resetExpungedUids();
        }
        if (sizeChanged || selected.isRecentUidRemoved() && !omitExpunged) {
            this.addRecentResponses(selected, responder);
            selected.resetRecentUidRemoved();
        }
        this.addFlagsResponses(session, selected, responder, useUid);
        selected.resetEvents();
    }

    private void addExpungedResponses(SelectedMailbox selected, Collection<MessageUid> expungedUids, ImapProcessor.Responder responder) {
        for (MessageUid uid : expungedUids) {
            int msn = selected.remove(uid);
            ExpungeResponse response = new ExpungeResponse(msn);
            responder.respond(response);
        }
    }

    private void addVanishedResponse(SelectedMailbox selected, Collection<MessageUid> expungedUids, ImapProcessor.Responder responder) {
        for (MessageUid uid : expungedUids) {
            selected.remove(uid);
        }
        UidRange[] uidRange = this.uidRanges(MessageRange.toRanges(expungedUids));
        responder.respond(new VanishedResponse(uidRange, false));
    }

    private void addFlagsResponses(ImapSession session, SelectedMailbox selected, ImapProcessor.Responder responder, boolean useUid) {
        try {
            Collection<MessageUid> flagUpdateUids;
            MessageManager messageManager = null;
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            if (selected.hasNewApplicableFlags()) {
                messageManager = this.getMailbox(session, selected);
                this.flags(responder, selected);
                this.permanentFlags(responder, messageManager.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT), selected);
                selected.resetNewApplicableFlags();
            }
            if (!(flagUpdateUids = selected.flagUpdateUids()).isEmpty()) {
                Iterator ranges = MessageRange.toRanges(flagUpdateUids).iterator();
                while (ranges.hasNext()) {
                    if (messageManager == null) {
                        messageManager = this.getMailbox(session, selected);
                    }
                    this.addFlagsResponses(session, selected, responder, useUid, (MessageRange)ranges.next(), messageManager, mailboxSession);
                }
            }
        }
        catch (MailboxException e) {
            this.handleResponseException(responder, e, HumanReadableText.FAILURE_TO_LOAD_FLAGS, session);
        }
    }

    protected void addFlagsResponses(ImapSession session, SelectedMailbox selected, ImapProcessor.Responder responder, boolean useUid, MessageRange messageSet, MessageManager mailbox, MailboxSession mailboxSession) throws MailboxException {
        MessageResultIterator it = mailbox.getMessages(messageSet, FetchGroupImpl.MINIMAL, mailboxSession);
        while (it.hasNext()) {
            MessageResult mr = (MessageResult)it.next();
            MessageUid uid = mr.getUid();
            int msn = selected.msn(uid);
            if (msn == -1) {
                LOGGER.debug("No message found with uid {} in the uid<->msn mapping for mailbox {}. This may be because it was deleted by a concurrent session. So skip it..", (Object)uid, (Object)selected.getPath().getFullName(mailboxSession.getPathDelimiter()));
                continue;
            }
            boolean qresyncEnabled = EnableProcessor.getEnabledCapabilities(session).contains("QRESYNC");
            boolean condstoreEnabled = EnableProcessor.getEnabledCapabilities(session).contains("CONDSTORE");
            Flags flags = mr.getFlags();
            Object uidOut = useUid || qresyncEnabled ? uid : null;
            if (selected.isRecent(uid)) {
                flags.add(Flags.Flag.RECENT);
            } else {
                flags.remove(Flags.Flag.RECENT);
            }
            FetchResponse response = (condstoreEnabled || qresyncEnabled) && mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT).isModSeqPermanent() ? new FetchResponse(msn, flags, (MessageUid)uidOut, mr.getModSeq(), null, null, null, null, null, null) : new FetchResponse(msn, flags, (MessageUid)uidOut, null, null, null, null, null, null, null);
            responder.respond(response);
        }
    }

    protected void condstoreEnablingCommand(ImapSession session, ImapProcessor.Responder responder, MessageManager.MetaData metaData, boolean sendHighestModSeq) {
        Set<String> enabled = EnableProcessor.getEnabledCapabilities(session);
        if (!enabled.contains("CONDSTORE")) {
            if (sendHighestModSeq && metaData.isModSeqPermanent()) {
                long highestModSeq = metaData.getHighestModSeq();
                StatusResponse untaggedOk = this.getStatusResponseFactory().untaggedOk(HumanReadableText.HIGHEST_MOD_SEQ, StatusResponse.ResponseCode.highestModSeq(highestModSeq));
                responder.respond(untaggedOk);
            }
            enabled.add("CONDSTORE");
        }
    }

    private MessageManager getMailbox(ImapSession session, SelectedMailbox selected) throws MailboxException {
        MailboxManager mailboxManager = this.getMailboxManager();
        return mailboxManager.getMailbox(selected.getPath(), ImapSessionUtils.getMailboxSession(session));
    }

    private void addRecentResponses(SelectedMailbox selected, ImapProcessor.Responder responder) {
        int recentCount = selected.recentCount();
        RecentResponse response = new RecentResponse(recentCount);
        responder.respond(response);
    }

    private void addExistsResponses(ImapSession session, SelectedMailbox selected, ImapProcessor.Responder responder) {
        long existsCount = selected.existsCount();
        ExistsResponse response = new ExistsResponse(existsCount);
        responder.respond(response);
    }

    private void handleResponseException(ImapProcessor.Responder responder, MailboxException e, HumanReadableText message, ImapSession session) {
        LOGGER.error("{}", (Object)message, (Object)e);
        StatusResponse response = this.factory.untaggedNo(message);
        responder.respond(response);
    }

    protected void okComplete(ImapCommand command, String tag, ImapProcessor.Responder responder) {
        StatusResponse response = this.factory.taggedOk(tag, command, HumanReadableText.COMPLETED);
        responder.respond(response);
    }

    protected void okComplete(ImapCommand command, String tag, StatusResponse.ResponseCode code, ImapProcessor.Responder responder) {
        StatusResponse response = this.factory.taggedOk(tag, command, HumanReadableText.COMPLETED, code);
        responder.respond(response);
    }

    protected void no(ImapCommand command, String tag, ImapProcessor.Responder responder, HumanReadableText displayTextKey) {
        StatusResponse response = this.factory.taggedNo(tag, command, displayTextKey);
        responder.respond(response);
    }

    protected void no(ImapCommand command, String tag, ImapProcessor.Responder responder, HumanReadableText displayTextKey, StatusResponse.ResponseCode responseCode) {
        StatusResponse response = this.factory.taggedNo(tag, command, displayTextKey, responseCode);
        responder.respond(response);
    }

    protected void taggedBad(ImapCommand command, String tag, ImapProcessor.Responder responder, HumanReadableText e) {
        StatusResponse response = this.factory.taggedBad(tag, command, e);
        responder.respond(response);
    }

    protected void bye(ImapProcessor.Responder responder) {
        StatusResponse response = this.factory.bye(HumanReadableText.BYE);
        responder.respond(response);
    }

    protected void bye(ImapProcessor.Responder responder, HumanReadableText key) {
        StatusResponse response = this.factory.bye(key);
        responder.respond(response);
    }

    protected abstract void doProcess(M var1, ImapSession var2, String var3, ImapCommand var4, ImapProcessor.Responder var5);

    private String joinMailboxPath(MailboxPath mailboxPath, char delimiter) {
        StringBuffer sb = new StringBuffer("");
        if (mailboxPath.getNamespace() != null && !mailboxPath.getNamespace().equals("")) {
            sb.append(mailboxPath.getNamespace());
        }
        if (mailboxPath.getUser() != null && !mailboxPath.getUser().equals("")) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(mailboxPath.getUser());
        }
        if (mailboxPath.getName() != null && !mailboxPath.getName().equals("")) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(mailboxPath.getName());
        }
        return sb.toString();
    }

    protected String mailboxName(boolean relative, MailboxPath path, char delimiter) {
        if (relative) {
            return path.getName();
        }
        return this.joinMailboxPath(path, delimiter);
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    protected StatusResponseFactory getStatusResponseFactory() {
        return this.factory;
    }

    protected MessageManager getSelectedMailbox(ImapSession session) throws MailboxException {
        MessageManager result;
        SelectedMailbox selectedMailbox = session.getSelected();
        if (selectedMailbox == null) {
            result = null;
        } else {
            MailboxManager mailboxManager = this.getMailboxManager();
            result = mailboxManager.getMailbox(selectedMailbox.getPath(), ImapSessionUtils.getMailboxSession(session));
        }
        return result;
    }

    protected MessageRange messageRange(SelectedMailbox selected, IdRange range, boolean useUids) throws MessageRangeException {
        long lowVal = range.getLowVal();
        long highVal = range.getHighVal();
        if (!useUids) {
            return this.msnRangeToMessageRange(selected, lowVal, highVal);
        }
        if (selected.existsCount() <= 0L) {
            return null;
        }
        MessageUid lastUid = selected.getLastUid().orElse(MessageUid.MIN_VALUE);
        if (lowVal == Long.MAX_VALUE && highVal == Long.MAX_VALUE) {
            return MessageRange.one((MessageUid)lastUid);
        }
        if (highVal == Long.MAX_VALUE && lastUid.compareTo(MessageUid.of((long)lowVal)) < 0) {
            return MessageRange.one((MessageUid)lastUid);
        }
        return MessageRange.range((MessageUid)MessageUid.of((long)lowVal), (MessageUid)MessageUid.of((long)highVal));
    }

    private MessageRange msnRangeToMessageRange(SelectedMailbox selected, long lowVal, long highVal) throws MessageRangeException {
        if (lowVal == Long.MAX_VALUE && highVal == Long.MAX_VALUE) {
            Optional<MessageUid> last = selected.getLastUid();
            if (!last.isPresent()) {
                throw new MessageRangeException("Mailbox is empty");
            }
            return last.get().toRange();
        }
        MessageUid lowUid = this.msnlowValToUid(selected, lowVal);
        MessageUid highUid = this.msnHighValToUid(selected, highVal);
        return MessageRange.range((MessageUid)lowUid, (MessageUid)highUid);
    }

    private MessageUid msnlowValToUid(SelectedMailbox selected, long lowVal) throws MessageRangeException {
        Optional<MessageUid> uid;
        if (lowVal != Long.MIN_VALUE) {
            uid = selected.uid((int)lowVal);
            if (!uid.isPresent()) {
                throw new MessageRangeException("No message found with msn " + lowVal);
            }
        } else {
            uid = selected.getFirstUid();
            if (!uid.isPresent()) {
                throw new MessageRangeException("Mailbox is empty");
            }
        }
        return uid.get();
    }

    private MessageUid msnHighValToUid(SelectedMailbox selected, long highVal) throws MessageRangeException {
        Optional<MessageUid> uid;
        if (highVal != Long.MAX_VALUE) {
            uid = selected.uid((int)highVal);
            if (!uid.isPresent()) {
                throw new MessageRangeException("No message found with msn " + highVal);
            }
        } else {
            uid = selected.getLastUid();
            if (!uid.isPresent()) {
                throw new MessageRangeException("Mailbox is empty");
            }
        }
        return uid.get();
    }

    protected MessageRange normalizeMessageRange(SelectedMailbox selected, MessageRange range) throws MessageRangeException {
        MessageRange.Type rangeType = range.getType();
        switch (rangeType) {
            case ONE: {
                return range;
            }
            case ALL: {
                MessageUid start = selected.getFirstUid().orElse(MessageUid.MIN_VALUE);
                MessageUid end = selected.getLastUid().orElse(MessageUid.MAX_VALUE);
                return MessageRange.range((MessageUid)start, (MessageUid)end);
            }
            case RANGE: {
                MessageUid end;
                MessageUid start = range.getUidFrom();
                if (start.equals((Object)MessageUid.MAX_VALUE) || start.compareTo(selected.getFirstUid().orElse(MessageUid.MIN_VALUE)) < 0) {
                    start = selected.getFirstUid().orElse(MessageUid.MIN_VALUE);
                }
                if ((end = range.getUidTo()).equals((Object)MessageUid.MAX_VALUE) || end.compareTo(selected.getLastUid().orElse(MessageUid.MAX_VALUE)) > 0) {
                    end = selected.getLastUid().orElse(MessageUid.MAX_VALUE);
                }
                return MessageRange.range((MessageUid)start, (MessageUid)end);
            }
            case FROM: {
                MessageUid start = range.getUidFrom();
                if (start.equals((Object)MessageUid.MAX_VALUE) || start.compareTo(selected.getFirstUid().orElse(MessageUid.MIN_VALUE)) < 0) {
                    start = selected.getFirstUid().orElse(MessageUid.MIN_VALUE);
                }
                MessageUid end = selected.getLastUid().orElse(MessageUid.MAX_VALUE);
                return MessageRange.range((MessageUid)start, (MessageUid)end);
            }
        }
        throw new MessageRangeException("Unknown message range type: " + rangeType);
    }

    protected void respondVanished(MailboxSession session, MessageManager mailbox, List<MessageRange> ranges, long changedSince, MessageManager.MetaData metaData, ImapProcessor.Responder responder) throws MailboxException {
        if (metaData.getHighestModSeq() > changedSince) {
            SearchQuery searchQuery = new SearchQuery();
            SearchQuery.UidRange[] nRanges = new SearchQuery.UidRange[ranges.size()];
            HashSet<MessageUid> vanishedUids = new HashSet<MessageUid>();
            for (int i = 0; i < ranges.size(); ++i) {
                MessageRange r = ranges.get(i);
                SearchQuery.UidRange nr = r.getType() == MessageRange.Type.ONE ? new SearchQuery.UidRange(r.getUidFrom()) : new SearchQuery.UidRange(r.getUidFrom(), r.getUidTo());
                MessageUid from = nr.getLowValue();
                MessageUid to = nr.getHighValue();
                while (from.compareTo(to) <= 0) {
                    vanishedUids.add(from);
                    from = from.next();
                }
                nRanges[i] = nr;
            }
            searchQuery.andCriteria(SearchQuery.uid((SearchQuery.UidRange[])nRanges));
            searchQuery.andCriteria(SearchQuery.modSeqGreaterThan((long)changedSince));
            Iterator uids = mailbox.search(searchQuery, session);
            while (uids.hasNext()) {
                vanishedUids.remove(uids.next());
            }
            UidRange[] vanishedIdRanges = this.uidRanges(MessageRange.toRanges(vanishedUids));
            responder.respond(new VanishedResponse(vanishedIdRanges, true));
        }
    }

    protected UidRange[] uidRanges(Collection<MessageRange> mRanges) {
        UidRange[] idRanges = new UidRange[mRanges.size()];
        Iterator<MessageRange> mIt = mRanges.iterator();
        int i = 0;
        while (mIt.hasNext()) {
            MessageRange mr = mIt.next();
            UidRange ir = mr.getType() == MessageRange.Type.ONE ? new UidRange(mr.getUidFrom()) : new UidRange(mr.getUidFrom(), mr.getUidTo());
            idRanges[i++] = ir;
        }
        return idRanges;
    }
}

