/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import java.util.Map;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.mailbox.model.MailboxACL;

public final class ACLResponse
implements ImapResponseMessage {
    private final MailboxACL acl;
    private final String mailboxName;

    public ACLResponse(String mailboxName, MailboxACL acl) {
        this.mailboxName = mailboxName;
        this.acl = acl;
    }

    public boolean equals(Object o) {
        if (o instanceof ACLResponse) {
            ACLResponse other = (ACLResponse)o;
            return (this.acl == other.acl || this.acl != null && this.acl.equals((Object)other.acl)) && (this.mailboxName == other.mailboxName || this.mailboxName != null && this.mailboxName.equals(other.mailboxName));
        }
        return false;
    }

    public MailboxACL getAcl() {
        return this.acl;
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public int hashCode() {
        int PRIME = 31;
        return 31 * this.acl.hashCode() + this.mailboxName.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("ACL").append(' ').append(this.mailboxName);
        for (Map.Entry en : this.acl.getEntries().entrySet()) {
            result.append(' ').append(((MailboxACL.EntryKey)en.getKey()).toString()).append(' ').append(((MailboxACL.Rfc4314Rights)en.getValue()).toString());
        }
        return result.toString();
    }
}

