/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode.base;

import java.io.IOException;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;

public abstract class AbstractChainedImapEncoder
implements ImapEncoder {
    private final ImapEncoder next;

    public AbstractChainedImapEncoder(ImapEncoder next) {
        this.next = next;
    }

    @Override
    public void encode(ImapMessage message, ImapResponseComposer composer, ImapSession session) throws IOException {
        boolean isAcceptable = this.isAcceptable(message);
        if (isAcceptable) {
            this.doEncode(message, composer, session);
        } else {
            this.chainEncode(message, composer, session);
        }
    }

    protected void chainEncode(ImapMessage message, ImapResponseComposer composer, ImapSession session) throws IOException {
        this.next.encode(message, composer, session);
    }

    protected abstract boolean isAcceptable(ImapMessage var1);

    protected abstract void doEncode(ImapMessage var1, ImapResponseComposer var2, ImapSession var3) throws IOException;
}

