/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.QuotaRootResponse;

public class QuotaRootResponseEncoder
extends AbstractChainedImapEncoder {
    public QuotaRootResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        QuotaRootResponse quotaRootResponse = (QuotaRootResponse)acceptableMessage;
        String quotaRoot = quotaRootResponse.getQuotaRoot();
        String mailbox = quotaRootResponse.getMailboxName();
        composer.untagged();
        composer.commandName("QUOTAROOT");
        composer.mailbox(mailbox == null ? "" : mailbox);
        composer.message(quotaRoot == null ? "" : quotaRoot);
        composer.end();
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof QuotaRootResponse;
    }
}

