/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.ExpungeResponse;

public class ExpungeResponseEncoder
extends AbstractChainedImapEncoder {
    public static final String EXPUNGE = "EXPUNGE";

    public ExpungeResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof ExpungeResponse;
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        ExpungeResponse expungeResponse = (ExpungeResponse)acceptableMessage;
        int messageSequenceNumber = expungeResponse.getMessageSequenceNumber();
        composer.untagged().message(messageSequenceNumber).message(EXPUNGE).end();
    }
}

