/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.AuthenticateRequest;
import org.apache.james.imap.message.request.IRAuthenticateRequest;
import org.apache.james.protocols.imap.DecodingException;

public class AuthenticateCommandParser
extends AbstractImapCommandParser {
    public AuthenticateCommandParser() {
        super(ImapCommand.nonAuthenticatedStateCommand("AUTHENTICATE"));
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, ImapSession session) throws DecodingException {
        AuthenticateRequest result;
        String authType = request.astring();
        try {
            result = new AuthenticateRequest(command, authType, tag);
            request.eol();
        }
        catch (DecodingException e) {
            String initialClientResponse = request.astring();
            result = new IRAuthenticateRequest(command, authType, tag, initialClientResponse);
            request.eol();
        }
        return result;
    }
}

