/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.imap;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.james.protocols.api.Request;

public class IMAPRequest
implements Request {
    private static final String US_ASCII = "US_ASCII";
    private static final String CRLF = "\r\n";
    private final Collection<ByteBuffer> lines;
    private final String tag;
    private final String command;

    public IMAPRequest(Collection<ByteBuffer> lines) {
        this.lines = lines;
        ByteBuffer buf = lines.iterator().next();
        buf.rewind();
        this.tag = this.read(buf);
        this.command = this.read(buf).toUpperCase(Locale.US);
    }

    public IMAPRequest(ByteBuffer line) {
        this(Arrays.asList(line));
    }

    private String read(ByteBuffer buf) {
        byte i;
        StringBuilder sb = new StringBuilder();
        while ((i = buf.get()) != 32) {
            sb.append(i);
        }
        return sb.toString();
    }

    public String getTag() {
        return this.tag;
    }

    public String getArgument() {
        int tagOffeset = this.tag.length() + this.command.length() + 2;
        StringBuilder sb = new StringBuilder();
        Iterator<ByteBuffer> linesIt = this.lines.iterator();
        while (linesIt.hasNext()) {
            byte[] buf;
            ByteBuffer line = linesIt.next();
            if (line.hasArray()) {
                buf = line.array();
            } else {
                line.rewind();
                buf = new byte[line.remaining() - tagOffeset];
                line.get(buf, tagOffeset, line.remaining());
            }
            try {
                sb.append(new String(buf, US_ASCII));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (!linesIt.hasNext()) continue;
            sb.append(CRLF);
        }
        return sb.toString();
    }

    public String getCommand() {
        return this.command;
    }

    public Iterator<ByteBuffer> getArguments() {
        return new Iterator<ByteBuffer>(){
            boolean first = true;
            Iterator<ByteBuffer> buffIt = IMAPRequest.access$000(IMAPRequest.this).iterator();

            @Override
            public boolean hasNext() {
                return this.buffIt.hasNext();
            }

            @Override
            public ByteBuffer next() {
                ByteBuffer buf = this.buffIt.next();
                buf.rewind();
                if (this.first) {
                    this.first = false;
                    buf.position(IMAPRequest.this.getTag().length() + IMAPRequest.this.getCommand().length() + 2);
                    buf = buf.slice();
                }
                return buf;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static /* synthetic */ Collection access$000(IMAPRequest x0) {
        return x0.lines;
    }
}

