/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.slf4j.Logger;

public class UnknownRequestProcessor
implements ImapProcessor {
    private final StatusResponseFactory factory;

    public UnknownRequestProcessor(StatusResponseFactory factory) {
        this.factory = factory;
    }

    public ImapResponseMessage process(ImapMessage message, ImapSession session) {
        StatusResponse result;
        Logger logger = session.getLog();
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug("Unknown message: " + message);
        }
        if (message instanceof ImapRequest) {
            ImapRequest request = (ImapRequest)message;
            String tag = request.getTag();
            ImapCommand command = request.getCommand();
            result = this.factory.taggedBad(tag, command, HumanReadableText.UNKNOWN_COMMAND);
        } else {
            result = this.factory.untaggedBad(HumanReadableText.UNKNOWN_COMMAND);
        }
        return result;
    }

    @Override
    public void process(ImapMessage message, ImapProcessor.Responder responder, ImapSession session) {
        ImapResponseMessage response = this.process(message, session);
        responder.respond(response);
    }
}

