/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.FetchGroupImpl;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.UpdatedFlags;

public class SelectedMailboxImpl
implements SelectedMailbox,
MailboxListener {
    private final Set<Long> recentUids = new TreeSet<Long>();
    private boolean recentUidRemoved = false;
    private MailboxManager mailboxManager;
    private MailboxPath path;
    private final ImapSession session;
    private static final Flags FLAGS = new Flags();
    private final long sessionId;
    private final Set<Long> flagUpdateUids = new TreeSet<Long>();
    private final Flags.Flag uninterestingFlag = Flags.Flag.RECENT;
    private final Set<Long> expungedUids = new TreeSet<Long>();
    private boolean isDeletedByOtherSession = false;
    private boolean sizeChanged = false;
    private boolean silentFlagChanges = false;
    private final Flags applicableFlags = new Flags(FLAGS);
    private boolean applicableFlagsChanged;
    private final SortedMap<Integer, Long> msnToUid = new TreeMap<Integer, Long>();
    private final SortedMap<Long, Integer> uidToMsn = new TreeMap<Long, Integer>();
    private long highestUid = 0L;
    private int highestMsn = 0;

    public SelectedMailboxImpl(MailboxManager mailboxManager, ImapSession session, MailboxPath path) throws MailboxException {
        this.session = session;
        this.sessionId = ImapSessionUtils.getMailboxSession(session).getSessionId();
        this.mailboxManager = mailboxManager;
        this.setSilentFlagChanges(true);
        this.path = path;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws MailboxException {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(this.session);
        this.mailboxManager.addListener(this.path, (MailboxListener)this, mailboxSession);
        MessageResultIterator messages = this.mailboxManager.getMailbox(this.path, mailboxSession).getMessages(MessageRange.all(), FetchGroupImpl.MINIMAL, mailboxSession);
        SelectedMailboxImpl selectedMailboxImpl = this;
        synchronized (selectedMailboxImpl) {
            while (messages.hasNext()) {
                MessageResult mr = (MessageResult)messages.next();
                this.applicableFlags.add(mr.getFlags());
                this.add(mr.getUid());
            }
            this.applicableFlags.remove(Flags.Flag.RECENT);
        }
    }

    private void add(int msn, long uid) {
        if (uid > this.highestUid) {
            this.highestUid = uid;
        }
        this.msnToUid.put(msn, uid);
        this.uidToMsn.put(uid, msn);
    }

    private void expunge(long uid) {
        int msn = this.msn(uid);
        this.remove(msn, uid);
        ArrayList<Integer> renumberMsns = new ArrayList<Integer>(this.msnToUid.tailMap(msn + 1).keySet());
        for (Integer msnInteger : renumberMsns) {
            int aMsn = msnInteger;
            long aUid = this.uid(aMsn);
            this.remove(aMsn, aUid);
            this.add(aMsn - 1, aUid);
        }
        --this.highestMsn;
    }

    private void remove(int msn, long uid) {
        this.uidToMsn.remove(uid);
        this.msnToUid.remove(msn);
    }

    private void add(long uid) {
        if (!this.uidToMsn.containsKey(uid)) {
            ++this.highestMsn;
            this.add(this.highestMsn, uid);
        }
    }

    @Override
    public synchronized long getFirstUid() {
        if (this.uidToMsn.isEmpty()) {
            return -1L;
        }
        return this.uidToMsn.firstKey();
    }

    @Override
    public synchronized long getLastUid() {
        if (this.uidToMsn.isEmpty()) {
            return -1L;
        }
        return this.uidToMsn.lastKey();
    }

    @Override
    public synchronized void deselect() {
        block2: {
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(this.session);
            try {
                this.mailboxManager.removeListener(this.path, (MailboxListener)this, mailboxSession);
            }
            catch (MailboxException e) {
                if (!this.session.getLog().isInfoEnabled()) break block2;
                this.session.getLog().info("Unable to remove listener " + this + " from mailbox while closing it", (Throwable)e);
            }
        }
        this.uidToMsn.clear();
        this.msnToUid.clear();
        this.flagUpdateUids.clear();
        this.expungedUids.clear();
        this.recentUids.clear();
    }

    @Override
    public synchronized boolean removeRecent(long uid) {
        boolean result = this.recentUids.remove(uid);
        if (result) {
            this.recentUidRemoved = true;
        }
        return result;
    }

    @Override
    public synchronized boolean addRecent(long uid) {
        return this.recentUids.add(uid);
    }

    @Override
    public synchronized Collection<Long> getRecent() {
        this.checkExpungedRecents();
        return new ArrayList<Long>(this.recentUids);
    }

    @Override
    public synchronized int recentCount() {
        this.checkExpungedRecents();
        return this.recentUids.size();
    }

    @Override
    public synchronized MailboxPath getPath() {
        return this.path;
    }

    private void checkExpungedRecents() {
        for (long uid : this.expungedUids()) {
            this.removeRecent(uid);
        }
    }

    @Override
    public synchronized boolean isRecent(long uid) {
        return this.recentUids.contains(uid);
    }

    @Override
    public synchronized boolean isRecentUidRemoved() {
        return this.recentUidRemoved;
    }

    @Override
    public synchronized void resetRecentUidRemoved() {
        this.recentUidRemoved = false;
    }

    @Override
    public synchronized void resetEvents() {
        this.sizeChanged = false;
        this.flagUpdateUids.clear();
        this.isDeletedByOtherSession = false;
        this.applicableFlagsChanged = false;
    }

    @Override
    public synchronized int remove(Long uid) {
        int result = this.msn(uid);
        this.expunge(uid);
        return result;
    }

    private boolean interestingFlags(UpdatedFlags updated) {
        Flags.Flag flag;
        Iterator it = updated.systemFlagIterator();
        boolean result = it.hasNext() ? !(flag = (Flags.Flag)it.next()).equals(this.uninterestingFlag) : false;
        if (!result) {
            Iterator userIt = updated.userFlagIterator();
            result = userIt.hasNext();
        }
        return result;
    }

    @Override
    public synchronized void resetExpungedUids() {
        this.expungedUids.clear();
    }

    public final synchronized boolean isSilentFlagChanges() {
        return this.silentFlagChanges;
    }

    public final synchronized void setSilentFlagChanges(boolean silentFlagChanges) {
        this.silentFlagChanges = silentFlagChanges;
    }

    @Override
    public final synchronized boolean isSizeChanged() {
        return this.sizeChanged;
    }

    @Override
    public final synchronized boolean isDeletedByOtherSession() {
        return this.isDeletedByOtherSession;
    }

    @Override
    public synchronized Collection<Long> flagUpdateUids() {
        return Collections.unmodifiableSet(new TreeSet<Long>(this.flagUpdateUids));
    }

    @Override
    public synchronized Collection<Long> expungedUids() {
        return Collections.unmodifiableSet(new TreeSet<Long>(this.expungedUids));
    }

    @Override
    public synchronized Flags getApplicableFlags() {
        return this.applicableFlags;
    }

    @Override
    public synchronized boolean hasNewApplicableFlags() {
        return this.applicableFlagsChanged;
    }

    @Override
    public synchronized void resetNewApplicableFlags() {
        this.applicableFlagsChanged = false;
    }

    public synchronized void event(MailboxListener.Event event) {
        if (event.getMailboxPath().equals((Object)this.getPath())) {
            long eventSessionId = event.getSession().getSessionId();
            if (event instanceof MailboxListener.MessageEvent) {
                MailboxListener.MessageEvent messageEvent = (MailboxListener.MessageEvent)event;
                if (messageEvent instanceof MailboxListener.Added) {
                    this.sizeChanged = true;
                    List uids = ((MailboxListener.Added)event).getUids();
                    for (int i = 0; i < uids.size(); ++i) {
                        this.add((Long)uids.get(i));
                    }
                } else if (messageEvent instanceof MailboxListener.FlagsUpdated) {
                    SelectedMailbox sm;
                    MailboxListener.FlagsUpdated updated = (MailboxListener.FlagsUpdated)messageEvent;
                    List uFlags = updated.getUpdatedFlags();
                    if (this.sessionId != eventSessionId || !this.silentFlagChanges) {
                        for (int i = 0; i < uFlags.size(); ++i) {
                            UpdatedFlags u = (UpdatedFlags)uFlags.get(i);
                            if (!this.interestingFlags(u)) continue;
                            this.flagUpdateUids.add(u.getUid());
                        }
                    }
                    if ((sm = this.session.getSelected()) != null) {
                        List uflags = updated.getUpdatedFlags();
                        for (int i = 0; i < uflags.size(); ++i) {
                            UpdatedFlags u = (UpdatedFlags)uflags.get(i);
                            Iterator flags = u.systemFlagIterator();
                            while (flags.hasNext()) {
                                MailboxPath path;
                                if (!Flags.Flag.RECENT.equals(flags.next()) || (path = sm.getPath()) == null || !path.equals((Object)event.getMailboxPath())) continue;
                                sm.addRecent(u.getUid());
                            }
                        }
                    }
                    int size = this.applicableFlags.getUserFlags().length;
                    MailboxListener.FlagsUpdated updatedF = (MailboxListener.FlagsUpdated)messageEvent;
                    List flags = updatedF.getUpdatedFlags();
                    for (int i = 0; i < flags.size(); ++i) {
                        this.applicableFlags.add(((UpdatedFlags)flags.get(i)).getNewFlags());
                    }
                    this.applicableFlags.remove(Flags.Flag.RECENT);
                    if (size < this.applicableFlags.getUserFlags().length) {
                        this.applicableFlagsChanged = true;
                    }
                } else if (messageEvent instanceof MailboxListener.Expunged) {
                    this.expungedUids.addAll(messageEvent.getUids());
                }
            } else if (event instanceof MailboxListener.MailboxDeletion) {
                if (eventSessionId != this.sessionId) {
                    this.isDeletedByOtherSession = true;
                }
            } else if (event instanceof MailboxListener.MailboxRenamed) {
                MailboxListener.MailboxRenamed mailboxRenamed = (MailboxListener.MailboxRenamed)event;
                this.path = mailboxRenamed.getNewPath();
            }
        }
    }

    @Override
    public synchronized int msn(long uid) {
        Integer msn = (Integer)this.uidToMsn.get(uid);
        if (msn != null) {
            return msn;
        }
        return -1;
    }

    @Override
    public synchronized long uid(int msn) {
        if (msn == -1) {
            return -1L;
        }
        Long uid = (Long)this.msnToUid.get(msn);
        if (uid != null) {
            return uid;
        }
        return -1L;
    }

    @Override
    public synchronized long existsCount() {
        return this.uidToMsn.size();
    }

    static {
        FLAGS.add(Flags.Flag.ANSWERED);
        FLAGS.add(Flags.Flag.DELETED);
        FLAGS.add(Flags.Flag.DRAFT);
        FLAGS.add(Flags.Flag.FLAGGED);
        FLAGS.add(Flags.Flag.SEEN);
    }
}

