/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;

public abstract class AbstractChainedProcessor<M extends ImapMessage>
implements ImapProcessor {
    private final ImapProcessor next;
    private Class<M> acceptableClass;

    public AbstractChainedProcessor(Class<M> acceptableClass, ImapProcessor next) {
        this.next = next;
        this.acceptableClass = acceptableClass;
    }

    @Override
    public void process(ImapMessage message, ImapProcessor.Responder responder, ImapSession session) {
        boolean isAcceptable = this.isAcceptable(message);
        if (isAcceptable) {
            this.doProcess(message, responder, session);
        } else {
            this.next.process(message, responder, session);
        }
    }

    protected boolean isAcceptable(ImapMessage message) {
        return this.acceptableClass.isInstance(message);
    }

    protected abstract void doProcess(M var1, ImapProcessor.Responder var2, ImapSession var3);
}

