/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.StoreRequest;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.FetchGroupImpl;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;

public class StoreProcessor
extends AbstractMailboxProcessor<StoreRequest> {
    private static final ImapCommand CONDSTORE_COMMAND = ImapCommand.selectedStateCommand("Conditional STORE");

    public StoreProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(StoreRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(StoreRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        IdRange[] idSet = request.getIdSet();
        boolean useUids = request.isUseUids();
        long unchangedSince = request.getUnchangedSince();
        ImapCommand imapCommand = command;
        try {
            MessageManager mailbox = this.getSelectedMailbox(session);
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            Flags flags = request.getFlags();
            if (unchangedSince != -1L) {
                Flags.Flag[] systemFlags;
                MessageManager.MetaData metaData = mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT);
                if (!metaData.isModSeqPermanent()) {
                    this.taggedBad(command, tag, responder, HumanReadableText.NO_MOD_SEQ);
                    return;
                }
                if (unchangedSince == 0L && (systemFlags = flags.getSystemFlags()) != null && systemFlags.length != 0) {
                    StatusResponse response = this.getStatusResponseFactory().taggedOk(tag, command, HumanReadableText.FAILED, StatusResponse.ResponseCode.condStore(idSet));
                    responder.respond(response);
                    return;
                }
            }
            ArrayList<Long> failed = new ArrayList<Long>();
            List<String> userFlags = Arrays.asList(flags.getUserFlags());
            for (int i = 0; i < idSet.length; ++i) {
                SelectedMailbox selected = session.getSelected();
                MessageRange messageSet = this.messageRange(selected, idSet[i], useUids);
                if (messageSet == null) continue;
                if (unchangedSince != -1L) {
                    imapCommand = CONDSTORE_COMMAND;
                    ArrayList<Long> uids = new ArrayList<Long>();
                    MessageResultIterator results = mailbox.getMessages(messageSet, FetchGroupImpl.MINIMAL, mailboxSession);
                    while (results.hasNext()) {
                        MessageResult r = (MessageResult)results.next();
                        long uid = r.getUid();
                        boolean fail = false;
                        if (unchangedSince == 0L) {
                            String[] uFlags = r.getFlags().getUserFlags();
                            for (int a = 0; a < uFlags.length; ++a) {
                                if (!userFlags.contains(uFlags[a])) continue;
                                fail = true;
                                break;
                            }
                        }
                        if (!fail && r.getModSeq() <= unchangedSince) {
                            uids.add(uid);
                            continue;
                        }
                        if (useUids) {
                            failed.add(uid);
                            continue;
                        }
                        failed.add(Long.valueOf(selected.msn(uid)));
                    }
                    List mRanges = MessageRange.toRanges(uids);
                    for (int a = 0; a < mRanges.size(); ++a) {
                        this.setFlags(request, mailboxSession, mailbox, (MessageRange)mRanges.get(a), session, tag, imapCommand, responder);
                    }
                    continue;
                }
                this.setFlags(request, mailboxSession, mailbox, messageSet, session, tag, imapCommand, responder);
            }
            boolean omitExpunged = !useUids;
            this.unsolicitedResponses(session, responder, omitExpunged, useUids);
            if (failed.isEmpty()) {
                this.okComplete(imapCommand, tag, responder);
            } else {
                List ranges = MessageRange.toRanges(failed);
                IdRange[] idRanges = new IdRange[ranges.size()];
                for (int i = 0; i < ranges.size(); ++i) {
                    MessageRange r = (MessageRange)ranges.get(i);
                    idRanges[i] = r.getType() == MessageRange.Type.ONE ? new IdRange(r.getUidFrom()) : new IdRange(r.getUidFrom(), r.getUidTo());
                }
                StatusResponse response = this.getStatusResponseFactory().taggedOk(tag, command, HumanReadableText.FAILED, StatusResponse.ResponseCode.condStore(idRanges));
                responder.respond(response);
            }
        }
        catch (MessageRangeException e) {
            if (session.getLog().isDebugEnabled()) {
                session.getLog().debug("Store failed for mailbox " + session.getSelected().getPath() + " because of an invalid sequence-set " + idSet.toString(), (Throwable)e);
            }
            this.taggedBad(imapCommand, tag, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Store failed for mailbox " + session.getSelected().getPath(), (Throwable)e);
            }
            this.no(imapCommand, tag, responder, HumanReadableText.SAVE_FAILED);
        }
    }

    private void setFlags(StoreRequest request, MailboxSession mailboxSession, MessageManager mailbox, MessageRange messageSet, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) throws MailboxException {
        boolean replace;
        boolean value;
        Flags flags = request.getFlags();
        boolean useUids = request.isUseUids();
        boolean silent = request.isSilent();
        boolean isSignedPlus = request.isSignedPlus();
        boolean isSignedMinus = request.isSignedMinus();
        long unchangedSince = request.getUnchangedSince();
        if (isSignedMinus) {
            value = false;
            replace = false;
        } else if (isSignedPlus) {
            value = true;
            replace = false;
        } else {
            replace = true;
            value = true;
        }
        SelectedMailbox selected = session.getSelected();
        Map flagsByUid = mailbox.setFlags(flags, value, replace, messageSet, mailboxSession);
        if (selected.hasNewApplicableFlags()) {
            this.flags(responder, selected);
            this.permanentFlags(responder, mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT), selected);
            selected.resetNewApplicableFlags();
        }
        Set<String> enabled = EnableProcessor.getEnabledCapabilities(session);
        boolean qresyncEnabled = enabled.contains("QRESYNC");
        boolean condstoreEnabled = enabled.contains("CONDSTORE");
        if (!silent || unchangedSince != -1L || qresyncEnabled || condstoreEnabled) {
            HashMap<Long, Long> modSeqs = new HashMap<Long, Long>();
            if (unchangedSince != -1L || qresyncEnabled || condstoreEnabled) {
                MessageResultIterator results = mailbox.getMessages(messageSet, FetchGroupImpl.MINIMAL, mailboxSession);
                while (results.hasNext()) {
                    MessageResult r = (MessageResult)results.next();
                    modSeqs.put(r.getUid(), r.getModSeq());
                }
            }
            for (Map.Entry entry : flagsByUid.entrySet()) {
                long uid = (Long)entry.getKey();
                int msn = selected.msn(uid);
                if (msn == -1) {
                    if (!session.getLog().isDebugEnabled()) continue;
                    session.getLog().debug("No message found with uid " + uid + " in the uid<->msn mapping for mailbox " + selected.getPath().getFullName(mailboxSession.getPathDelimiter()) + " , this may be because it was deleted by a concurrent session. So skip it..");
                    continue;
                }
                Flags resultFlags = (Flags)entry.getValue();
                Long resultUid = useUids || qresyncEnabled ? Long.valueOf(uid) : null;
                if (selected.isRecent(uid)) {
                    resultFlags.add(Flags.Flag.RECENT);
                }
                FetchResponse response = silent && (unchangedSince != -1L || qresyncEnabled || condstoreEnabled) ? new FetchResponse(msn, null, resultUid, (Long)modSeqs.get(uid), null, null, null, null, null, null) : (!silent && (unchangedSince != -1L || qresyncEnabled || condstoreEnabled) ? new FetchResponse(msn, resultFlags, resultUid, (Long)modSeqs.get(uid), null, null, null, null, null, null) : new FetchResponse(msn, resultFlags, resultUid, null, null, null, null, null, null, null));
                responder.respond(response);
            }
            if (unchangedSince != -1L) {
                this.condstoreEnablingCommand(session, responder, mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT), true);
            }
        }
    }
}

