/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.CopyRequest;
import org.apache.james.imap.message.request.MoveRequest;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.CopyProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;

public class MoveProcessor
extends CopyProcessor
implements CapabilityImplementingProcessor {
    private static final List<String> CAPS = Collections.unmodifiableList(Arrays.asList("MOVE"));

    public MoveProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super((Class<? extends CopyRequest>)MoveRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected List<MessageRange> process(MailboxPath targetMailbox, SelectedMailbox currentMailbox, MailboxSession mailboxSession, MailboxManager mailboxManager, MessageRange messageSet) throws MailboxException {
        List processedUids = mailboxManager.moveMessages(messageSet, currentMailbox.getPath(), targetMailbox, mailboxSession);
        return processedUids;
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }
}

