/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.LoginRequest;
import org.apache.james.imap.processor.AbstractAuthProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;

public class LoginProcessor
extends AbstractAuthProcessor<LoginRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> LOGINDISABLED_CAPS = Collections.unmodifiableList(Arrays.asList("LOGINDISABLED"));

    public LoginProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(LoginRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(LoginRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String userid = request.getUserid();
        String passwd = request.getPassword();
        if (session.isPlainAuthDisallowed() && !session.isTLSActive()) {
            this.no(command, tag, responder, HumanReadableText.DISABLED_LOGIN);
        } else {
            this.doAuth(userid, passwd, session, tag, command, responder, HumanReadableText.INVALID_LOGIN);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        if (session.isPlainAuthDisallowed() && !session.isTLSActive()) {
            return LOGINDISABLED_CAPS;
        }
        return Collections.emptyList();
    }
}

