/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.CharsetUtil;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.LsubRequest;
import org.apache.james.imap.message.response.LSubResponse;
import org.apache.james.imap.processor.AbstractSubscriptionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MailboxQuery;

public class LSubProcessor
extends AbstractSubscriptionProcessor<LsubRequest> {
    public LSubProcessor(ImapProcessor next, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory) {
        super(LsubRequest.class, next, mailboxManager, subscriptionManager, factory);
    }

    private void listSubscriptions(ImapSession session, ImapProcessor.Responder responder, String referenceName, String mailboxName) throws SubscriptionException, MailboxException {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        Collection mailboxes = this.getSubscriptionManager().subscriptions(mailboxSession);
        String finalReferencename = referenceName;
        if (mailboxName.charAt(0) == '#') {
            finalReferencename = "";
        }
        boolean isRelative = (finalReferencename + mailboxName).charAt(0) != '#';
        MailboxPath basePath = null;
        basePath = isRelative ? new MailboxPath("#private", mailboxSession.getUser().getUserName(), CharsetUtil.decodeModifiedUTF7(finalReferencename)) : this.buildFullPath(session, CharsetUtil.decodeModifiedUTF7(finalReferencename));
        MailboxQuery expression = new MailboxQuery(basePath, CharsetUtil.decodeModifiedUTF7(mailboxName), mailboxSession.getPathDelimiter());
        ArrayList<String> mailboxResponses = new ArrayList<String>();
        for (String mailbox : mailboxes) {
            this.respond(responder, expression, mailbox, true, mailboxes, mailboxResponses, mailboxSession.getPathDelimiter());
        }
    }

    private void respond(ImapProcessor.Responder responder, MailboxQuery expression, String mailboxName, boolean originalSubscription, Collection<String> mailboxes, Collection<String> mailboxResponses, char delimiter) {
        if (expression.isExpressionMatch(mailboxName)) {
            if (!mailboxResponses.contains(mailboxName)) {
                LSubResponse response = new LSubResponse(mailboxName, !originalSubscription, delimiter);
                responder.respond(response);
                mailboxResponses.add(mailboxName);
            }
        } else {
            String parentMailbox;
            int lastDelimiter = mailboxName.lastIndexOf(delimiter);
            if (lastDelimiter > 0 && !mailboxes.contains(parentMailbox = mailboxName.substring(0, lastDelimiter))) {
                this.respond(responder, expression, parentMailbox, false, mailboxes, mailboxResponses, delimiter);
            }
        }
    }

    private void respondWithHierarchyDelimiter(ImapProcessor.Responder responder, char delimiter) {
        LSubResponse response = new LSubResponse("", true, delimiter);
        responder.respond(response);
    }

    @Override
    protected void doProcessRequest(LsubRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String referenceName = request.getBaseReferenceName();
        String mailboxPattern = request.getMailboxPattern();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        try {
            if (mailboxPattern.length() == 0) {
                this.respondWithHierarchyDelimiter(responder, mailboxSession.getPathDelimiter());
            } else {
                this.listSubscriptions(session, responder, referenceName, mailboxPattern);
            }
            this.okComplete(command, tag, responder);
        }
        catch (MailboxException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("LSub failed for reference " + referenceName + " and pattern " + mailboxPattern, (Throwable)e);
            }
            HumanReadableText displayTextKey = HumanReadableText.GENERIC_LSUB_FAILURE;
            this.no(command, tag, responder, displayTextKey);
        }
    }
}

