/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.GetACLRequest;
import org.apache.james.imap.message.response.ACLResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.slf4j.Logger;

public class GetACLProcessor
extends AbstractMailboxProcessor<GetACLRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPABILITIES = Collections.singletonList("ACL");

    public GetACLProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(GetACLRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(GetACLRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        String mailboxName = message.getMailboxName();
        try {
            MessageManager messageManager = mailboxManager.getMailbox(this.buildFullPath(session, mailboxName), mailboxSession);
            if (!messageManager.hasRight(SimpleMailboxACL.Rfc4314Rights.l_Lookup_RIGHT, mailboxSession)) {
                this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            } else if (!messageManager.hasRight(SimpleMailboxACL.Rfc4314Rights.a_Administer_RIGHT, mailboxSession)) {
                Object[] params = new Object[]{SimpleMailboxACL.Rfc4314Rights.a_Administer_RIGHT.toString(), command.getName(), mailboxName};
                HumanReadableText text = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
                this.no(command, tag, responder, text);
            } else {
                MessageManager.MetaData metaData = messageManager.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT);
                ACLResponse aclResponse = new ACLResponse(mailboxName, metaData.getACL());
                responder.respond(aclResponse);
                this.okComplete(command, tag, responder);
            }
        }
        catch (MailboxNotFoundException e) {
            this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
        }
        catch (MailboxException e) {
            Logger log = session.getLog();
            if (log.isInfoEnabled()) {
                log.info(command.getName() + " failed for mailbox " + mailboxName, (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }
}

