/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.EnableRequest;
import org.apache.james.imap.message.response.EnableResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.CapabilityProcessor;
import org.apache.james.imap.processor.PermitEnableCapabilityProcessor;
import org.apache.james.mailbox.MailboxManager;

public class EnableProcessor
extends AbstractMailboxProcessor<EnableRequest>
implements CapabilityImplementingProcessor {
    private static final List<PermitEnableCapabilityProcessor> capabilities = new ArrayList<PermitEnableCapabilityProcessor>();
    public static final String ENABLED_CAPABILITIES = "ENABLED_CAPABILITIES";
    private static final List<String> CAPS = Collections.unmodifiableList(Arrays.asList("ENABLE"));

    public EnableProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, List<PermitEnableCapabilityProcessor> capabilities) {
        this(next, mailboxManager, factory);
        EnableProcessor.capabilities.addAll(capabilities);
    }

    public EnableProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(EnableRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(EnableRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        try {
            List<String> caps = request.getCapabilities();
            Set<String> enabledCaps = EnableProcessor.enable(request, responder, session, caps.iterator());
            responder.respond(new EnableResponse(enabledCaps));
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(command, tag, responder);
        }
        catch (PermitEnableCapabilityProcessor.EnableException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Unable to enable extension", (Throwable)e);
            }
            this.taggedBad(command, tag, responder, HumanReadableText.FAILED);
        }
    }

    public static Set<String> enable(ImapRequest request, ImapProcessor.Responder responder, ImapSession session, Iterator<String> caps) throws PermitEnableCapabilityProcessor.EnableException {
        HashSet<String> enabledCaps = new HashSet<String>();
        while (caps.hasNext()) {
            String cap = caps.next();
            if (!CapabilityProcessor.getSupportedCapabilities(session).contains(cap)) continue;
            for (int a = 0; a < capabilities.size(); ++a) {
                PermitEnableCapabilityProcessor enableProcessor = capabilities.get(a);
                if (!enableProcessor.getPermitEnableCapabilities(session).contains(cap)) continue;
                enableProcessor.enable(request, responder, session, cap);
                enabledCaps.add(cap);
            }
        }
        EnableProcessor.getEnabledCapabilities(session).addAll(enabledCaps);
        return enabledCaps;
    }

    public void addProcessor(PermitEnableCapabilityProcessor implementor) {
        capabilities.add(implementor);
    }

    public static Set<String> getEnabledCapabilities(ImapSession session) {
        HashSet caps = (HashSet)session.getAttribute(ENABLED_CAPABILITIES);
        if (caps == null) {
            caps = new HashSet();
            session.setAttribute(ENABLED_CAPABILITIES, caps);
        }
        return caps;
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }
}

