/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.CopyRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;

public class CopyProcessor
extends AbstractMailboxProcessor<CopyRequest> {
    public CopyProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        this((Class<? extends CopyRequest>)CopyRequest.class, next, mailboxManager, factory);
    }

    protected CopyProcessor(Class<? extends CopyRequest> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(CopyRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(CopyRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxPath targetMailbox = this.buildFullPath(session, request.getMailboxName());
        IdRange[] idSet = request.getIdSet();
        boolean useUids = request.isUseUids();
        SelectedMailbox currentMailbox = session.getSelected();
        try {
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            MailboxManager mailboxManager = this.getMailboxManager();
            boolean mailboxExists = mailboxManager.mailboxExists(targetMailbox, mailboxSession);
            if (!mailboxExists) {
                this.no(command, tag, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
            } else {
                MessageManager mailbox = mailboxManager.getMailbox(targetMailbox, mailboxSession);
                ArrayList<IdRange> resultRanges = new ArrayList<IdRange>();
                for (int i = 0; i < idSet.length; ++i) {
                    MessageRange messageSet = this.messageRange(currentMailbox, idSet[i], useUids);
                    if (messageSet == null) continue;
                    List<MessageRange> processedUids = this.process(targetMailbox, currentMailbox, mailboxSession, mailboxManager, messageSet);
                    for (MessageRange mr : processedUids) {
                        resultRanges.add(new IdRange(mr.getUidFrom(), mr.getUidTo()));
                    }
                }
                IdRange[] resultUids = IdRange.mergeRanges(resultRanges).toArray(new IdRange[0]);
                Long uidValidity = mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_UNSEEN).getUidValidity();
                this.unsolicitedResponses(session, responder, useUids);
                this.okComplete(command, tag, StatusResponse.ResponseCode.copyUid(uidValidity, idSet, resultUids), responder);
            }
        }
        catch (MessageRangeException e) {
            if (session.getLog().isDebugEnabled()) {
                session.getLog().debug("Copy failed from mailbox " + currentMailbox.getPath() + " to " + targetMailbox + " for invalid sequence-set " + idSet.toString(), (Throwable)e);
            }
            this.taggedBad(command, tag, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Copy failed from mailbox " + currentMailbox.getPath() + " to " + targetMailbox + " for sequence-set " + idSet.toString(), (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    protected List<MessageRange> process(MailboxPath targetMailbox, SelectedMailbox currentMailbox, MailboxSession mailboxSession, MailboxManager mailboxManager, MessageRange messageSet) throws MailboxException {
        List processedUids = mailboxManager.copyMessages(messageSet, currentMailbox.getPath(), targetMailbox, mailboxSession);
        return processedUids;
    }
}

