/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.CloseRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageRange;

public class CloseProcessor
extends AbstractMailboxProcessor<CloseRequest> {
    public CloseProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(CloseRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(CloseRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        try {
            MessageManager mailbox = this.getSelectedMailbox(session);
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            if (mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT).isWriteable()) {
                mailbox.expunge(MessageRange.all(), mailboxSession);
                session.deselect();
                this.okComplete(command, tag, responder);
            }
        }
        catch (MailboxException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Close failed for mailbox " + session.getSelected().getPath(), (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }
}

