/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.CharsetUtil;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.CapabilityRequest;
import org.apache.james.imap.message.response.CapabilityResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;

public class CapabilityProcessor
extends AbstractMailboxProcessor<CapabilityRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPS;
    private static final List<CapabilityImplementingProcessor> capabilities;
    private static final Set<String> disabledCaps;

    public CapabilityProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, List<CapabilityImplementingProcessor> capabilities, Set<String> disabledCaps) {
        this(next, mailboxManager, factory, disabledCaps);
        CapabilityProcessor.capabilities.addAll(capabilities);
    }

    public CapabilityProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, Set<String> disabledCaps) {
        super(CapabilityRequest.class, next, mailboxManager, factory);
        CapabilityProcessor.disabledCaps.addAll(disabledCaps);
        capabilities.add(this);
    }

    @Override
    protected void doProcess(CapabilityRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        CapabilityResponse result = new CapabilityResponse(CapabilityProcessor.getSupportedCapabilities(session));
        responder.respond(result);
        this.unsolicitedResponses(session, responder, false);
        this.okComplete(command, tag, responder);
    }

    public void addProcessor(CapabilityImplementingProcessor implementor) {
        capabilities.add(implementor);
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    public static Set<String> getSupportedCapabilities(ImapSession session) {
        HashSet<String> caps = new HashSet<String>();
        for (int i = 0; i < capabilities.size(); ++i) {
            caps.addAll(capabilities.get(i).getImplementedCapabilities(session));
        }
        caps.removeAll(disabledCaps);
        return caps;
    }

    static {
        ArrayList<String> caps = new ArrayList<String>();
        caps.add("IMAP4rev1");
        caps.add("LITERAL+");
        caps.add("CHILDREN");
        if (CharsetUtil.getAvailableCharsetNames().contains("UTF-8")) {
            caps.add("I18NLEVEL=1");
        }
        caps.add("CONDSTORE");
        CAPS = Collections.unmodifiableList(caps);
        capabilities = new ArrayList<CapabilityImplementingProcessor>();
        disabledCaps = new HashSet<String>();
    }
}

