/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.AuthenticateRequest;
import org.apache.james.imap.message.request.IRAuthenticateRequest;
import org.apache.james.imap.message.response.AuthenticateResponse;
import org.apache.james.imap.processor.AbstractAuthProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;

public class AuthenticateProcessor
extends AbstractAuthProcessor<AuthenticateRequest>
implements CapabilityImplementingProcessor {
    private static final String PLAIN = "PLAIN";

    public AuthenticateProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(AuthenticateRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(AuthenticateRequest request, ImapSession session, final String tag, final ImapCommand command, final ImapProcessor.Responder responder) {
        String authType = request.getAuthType();
        if (authType.equalsIgnoreCase(PLAIN)) {
            if (session.isPlainAuthDisallowed() && !session.isTLSActive()) {
                this.no(command, tag, responder, HumanReadableText.DISABLED_LOGIN);
            } else if (request instanceof IRAuthenticateRequest) {
                IRAuthenticateRequest irRequest = (IRAuthenticateRequest)request;
                this.doPlainAuth(irRequest.getInitialClientResponse(), session, tag, command, responder);
            } else {
                responder.respond(new AuthenticateResponse());
                session.pushLineHandler(new ImapLineHandler(){

                    @Override
                    public void onLine(ImapSession session, byte[] data) {
                        String initialClientResponse = new String(data, 0, data.length - 2, Charset.forName("US-ASCII"));
                        AuthenticateProcessor.this.doPlainAuth(initialClientResponse, session, tag, command, responder);
                        session.popLineHandler();
                    }
                });
            }
        } else {
            if (session.getLog().isDebugEnabled()) {
                session.getLog().debug("Unsupported authentication mechanism '" + authType + "'");
            }
            this.no(command, tag, responder, HumanReadableText.UNSUPPORTED_AUTHENTICATION_MECHANISM);
        }
    }

    protected void doPlainAuth(String initialClientResponse, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String pass = null;
        String user = null;
        try {
            String userpass = new String(Base64.decodeBase64((String)initialClientResponse));
            StringTokenizer authTokenizer = new StringTokenizer(userpass, "\u0000");
            String authorize_id = authTokenizer.nextToken();
            user = authTokenizer.nextToken();
            try {
                pass = authTokenizer.nextToken();
            }
            catch (NoSuchElementException _) {
                pass = user;
                user = authorize_id;
            }
            authTokenizer = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.doAuth(user, pass, session, tag, command, responder, HumanReadableText.AUTHENTICATION_FAILED);
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        ArrayList<String> caps = new ArrayList<String>();
        if (!session.isPlainAuthDisallowed() || session.isTLSActive()) {
            caps.add("AUTH=PLAIN");
        }
        caps.add("SASL-IR");
        return Collections.unmodifiableList(caps);
    }
}

