/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SearchResUtil;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.AbstractMailboxSelectionRequest;
import org.apache.james.imap.message.response.ExistsResponse;
import org.apache.james.imap.message.response.RecentResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.PermitEnableCapabilityProcessor;
import org.apache.james.imap.processor.base.SelectedMailboxImpl;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;

abstract class AbstractSelectionProcessor<M extends AbstractMailboxSelectionRequest>
extends AbstractMailboxProcessor<M>
implements PermitEnableCapabilityProcessor {
    final StatusResponseFactory statusResponseFactory;
    private final boolean openReadOnly;
    private static final List<String> CAPS = Collections.unmodifiableList(Arrays.asList("QRESYNC", "CONDSTORE"));

    public AbstractSelectionProcessor(Class<M> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory, boolean openReadOnly) {
        super(acceptableClass, next, mailboxManager, statusResponseFactory);
        this.statusResponseFactory = statusResponseFactory;
        this.openReadOnly = openReadOnly;
    }

    @Override
    protected void doProcess(AbstractMailboxSelectionRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        try {
            MailboxPath fullMailboxPath = this.buildFullPath(session, mailboxName);
            this.respond(tag, command, session, fullMailboxPath, request, responder);
        }
        catch (MailboxNotFoundException e) {
            session.getLog().debug("Select failed as mailbox does not exist " + mailboxName, (Throwable)e);
            responder.respond(this.statusResponseFactory.taggedNo(tag, command, HumanReadableText.FAILURE_NO_SUCH_MAILBOX));
        }
        catch (MailboxException e) {
            session.getLog().info("Select failed for mailbox " + mailboxName, (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.SELECT);
        }
    }

    private void respond(String tag, ImapCommand command, ImapSession session, MailboxPath fullMailboxPath, AbstractMailboxSelectionRequest request, ImapProcessor.Responder responder) throws MailboxException, MessageRangeException {
        Long lastKnownUidValidity = request.getLastKnownUidValidity();
        Long modSeq = request.getKnownModSeq();
        IdRange[] knownSequences = request.getKnownSequenceSet();
        IdRange[] knownUids = request.getKnownUidSet();
        if (lastKnownUidValidity != null && !EnableProcessor.getEnabledCapabilities(session).contains("QRESYNC")) {
            this.taggedBad(command, tag, responder, HumanReadableText.QRESYNC_NOT_ENABLED);
            return;
        }
        MessageManager.MetaData metaData = this.selectMailbox(fullMailboxPath, session);
        SelectedMailbox selected = session.getSelected();
        Long firstUnseen = metaData.getFirstUnseen();
        this.flags(responder, selected);
        this.exists(responder, metaData);
        this.recent(responder, selected);
        this.uidValidity(responder, metaData);
        int retryCount = 0;
        while (!this.unseen(responder, firstUnseen, selected, ImapSessionUtils.getMailboxSession(session))) {
            if (retryCount == 5) {
                if (!session.getLog().isInfoEnabled()) break;
                session.getLog().info("Unable to uid for unseen message " + firstUnseen + " in mailbox " + selected.getPath());
                break;
            }
            firstUnseen = this.selectMailbox(fullMailboxPath, session).getFirstUnseen();
            ++retryCount;
        }
        this.permanentFlags(responder, metaData, selected);
        this.highestModSeq(responder, metaData, selected);
        this.uidNext(responder, metaData);
        if (request.getCondstore()) {
            this.condstoreEnablingCommand(session, responder, metaData, false);
        }
        if (metaData.isModSeqPermanent() && lastKnownUidValidity != null) {
            if (lastKnownUidValidity.longValue() == metaData.getUidValidity()) {
                long uidNext;
                MailboxManager mailboxManager = this.getMailboxManager();
                MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
                MessageManager mailbox = mailboxManager.getMailbox(fullMailboxPath, mailboxSession);
                SearchQuery sq = new SearchQuery();
                sq.andCriteria(SearchQuery.modSeqGreaterThan((long)request.getKnownModSeq()));
                IdRange[] uidSet = request.getUidSet();
                if (uidSet == null && (uidNext = metaData.getUidNext()) != 1L) {
                    uidSet = new IdRange[]{new IdRange(1L, uidNext - 1L)};
                }
                if (uidSet != null) {
                    if (knownSequences != null && knownUids != null) {
                        ArrayList<Long> knownUidsList = new ArrayList<Long>();
                        for (int a = 0; a < knownUids.length; ++a) {
                            Iterator<Long> it = knownUids[a].iterator();
                            while (it.hasNext()) {
                                knownUidsList.add(it.next());
                            }
                        }
                        long firstUid = 1L;
                        int index = 0;
                        for (int a = 0; a < knownSequences.length; ++a) {
                            boolean done = false;
                            Iterator<Long> it = knownSequences[a].iterator();
                            while (it.hasNext()) {
                                if (knownUidsList.size() > index++) {
                                    int msn = it.next().intValue();
                                    long knownUid = (Long)knownUidsList.get(index);
                                    if (selected.uid(msn) != knownUid) {
                                        done = true;
                                        break;
                                    }
                                    firstUid = knownUid;
                                    continue;
                                }
                                done = true;
                                break;
                            }
                            if (!done) continue;
                            ++firstUid;
                            ArrayList<IdRange> filteredUidSet = new ArrayList<IdRange>();
                            for (int i = 0; i < uidSet.length; ++i) {
                                IdRange r = uidSet[i];
                                if (r.getLowVal() < firstUid) {
                                    if (r.getHighVal() <= firstUid) continue;
                                    r.setLowVal(firstUid);
                                    filteredUidSet.add(r);
                                    continue;
                                }
                                filteredUidSet.add(r);
                            }
                            uidSet = filteredUidSet.toArray(new IdRange[0]);
                            break;
                        }
                    }
                    ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
                    for (int i = 0; i < uidSet.length; ++i) {
                        MessageRange messageSet = this.messageRange(session.getSelected(), uidSet[i], true);
                        if (messageSet == null) continue;
                        MessageRange normalizedMessageSet = this.normalizeMessageRange(session.getSelected(), messageSet);
                        ranges.add(normalizedMessageSet);
                    }
                    this.respondVanished(mailboxSession, mailbox, ranges, modSeq, metaData, responder);
                }
                this.taggedOk(responder, tag, command, metaData, HumanReadableText.SELECT);
            } else {
                this.taggedOk(responder, tag, command, metaData, HumanReadableText.QRESYNC_UIDVALIDITY_MISMATCH);
            }
        } else {
            this.taggedOk(responder, tag, command, metaData, HumanReadableText.SELECT);
        }
        SearchResUtil.resetSavedSequenceSet(session);
    }

    private void highestModSeq(ImapProcessor.Responder responder, MessageManager.MetaData metaData, SelectedMailbox selected) {
        StatusResponse untaggedOk;
        if (metaData.isModSeqPermanent()) {
            long highestModSeq = metaData.getHighestModSeq();
            untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.HIGHEST_MOD_SEQ, StatusResponse.ResponseCode.highestModSeq(highestModSeq));
        } else {
            untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.NO_MOD_SEQ, StatusResponse.ResponseCode.noModSeq());
        }
        responder.respond(untaggedOk);
    }

    private void uidNext(ImapProcessor.Responder responder, MessageManager.MetaData metaData) throws MailboxException {
        long uid = metaData.getUidNext();
        StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.UIDNEXT, StatusResponse.ResponseCode.uidNext(uid));
        responder.respond(untaggedOk);
    }

    private void taggedOk(ImapProcessor.Responder responder, String tag, ImapCommand command, MessageManager.MetaData metaData, HumanReadableText text) {
        boolean writeable = metaData.isWriteable() && !this.openReadOnly;
        StatusResponse.ResponseCode code = writeable ? StatusResponse.ResponseCode.readWrite() : StatusResponse.ResponseCode.readOnly();
        StatusResponse taggedOk = this.statusResponseFactory.taggedOk(tag, command, text, code);
        responder.respond(taggedOk);
    }

    private boolean unseen(ImapProcessor.Responder responder, Long firstUnseen, SelectedMailbox selected, MailboxSession session) throws MailboxException {
        if (firstUnseen != null) {
            long unseenUid = firstUnseen;
            int msn = selected.msn(unseenUid);
            if (msn == -1) {
                if (session.getLog().isDebugEnabled()) {
                    session.getLog().debug("No message found with uid " + unseenUid + " in mailbox " + selected.getPath().getFullName(session.getPathDelimiter()));
                }
                return false;
            }
            StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.unseen(msn), StatusResponse.ResponseCode.unseen(msn));
            responder.respond(untaggedOk);
        }
        return true;
    }

    private void uidValidity(ImapProcessor.Responder responder, MessageManager.MetaData metaData) throws MailboxException {
        long uidValidity = metaData.getUidValidity();
        StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.UID_VALIDITY, StatusResponse.ResponseCode.uidValidity(uidValidity));
        responder.respond(untaggedOk);
    }

    private void recent(ImapProcessor.Responder responder, SelectedMailbox selected) {
        int recentCount = selected.recentCount();
        RecentResponse recentResponse = new RecentResponse(recentCount);
        responder.respond(recentResponse);
    }

    private void exists(ImapProcessor.Responder responder, MessageManager.MetaData metaData) throws MailboxException {
        long messageCount = metaData.getMessageCount();
        ExistsResponse existsResponse = new ExistsResponse(messageCount);
        responder.respond(existsResponse);
    }

    private MessageManager.MetaData selectMailbox(MailboxPath mailboxPath, ImapSession session) throws MailboxException {
        SelectedMailbox sessionMailbox;
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        MessageManager mailbox = mailboxManager.getMailbox(mailboxPath, mailboxSession);
        SelectedMailbox currentMailbox = session.getSelected();
        if (currentMailbox == null || !currentMailbox.getPath().equals((Object)mailboxPath)) {
            if (currentMailbox != null) {
                this.getStatusResponseFactory().untaggedOk(HumanReadableText.QRESYNC_CLOSED, StatusResponse.ResponseCode.closed());
            }
            session.selected(new SelectedMailboxImpl(this.getMailboxManager(), session, mailboxPath));
            sessionMailbox = session.getSelected();
        } else {
            sessionMailbox = currentMailbox;
        }
        MessageManager.MetaData metaData = mailbox.getMetaData(!this.openReadOnly, mailboxSession, MessageManager.MetaData.FetchGroup.FIRST_UNSEEN);
        this.addRecent(metaData, sessionMailbox);
        return metaData;
    }

    private void addRecent(MessageManager.MetaData metaData, SelectedMailbox sessionMailbox) throws MailboxException {
        List recentUids = metaData.getRecent();
        for (int i = 0; i < recentUids.size(); ++i) {
            long uid = (Long)recentUids.get(i);
            sessionMailbox.addRecent(uid);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    public List<String> getPermitEnableCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    public void enable(ImapMessage message, ImapProcessor.Responder responder, ImapSession session, String capability) throws PermitEnableCapabilityProcessor.EnableException {
        if (!EnableProcessor.getEnabledCapabilities(session).contains(capability)) {
            SelectedMailbox sm = session.getSelected();
            if (capability.equalsIgnoreCase("CONDSTORE") || capability.equalsIgnoreCase("QRESYNC")) {
                try {
                    MessageManager.MetaData metaData = null;
                    boolean send = false;
                    if (sm != null) {
                        MessageManager mailbox = this.getSelectedMailbox(session);
                        metaData = mailbox.getMetaData(false, ImapSessionUtils.getMailboxSession(session), MessageManager.MetaData.FetchGroup.NO_COUNT);
                        send = true;
                    }
                    this.condstoreEnablingCommand(session, responder, metaData, send);
                }
                catch (MailboxException e) {
                    throw new PermitEnableCapabilityProcessor.EnableException("Unable to enable " + capability, e);
                }
            }
        }
    }
}

