/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.response.ExistsResponse;
import org.apache.james.imap.message.response.ExpungeResponse;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.message.response.FlagsResponse;
import org.apache.james.imap.message.response.RecentResponse;
import org.apache.james.imap.message.response.VanishedResponse;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.base.AbstractChainedProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.FetchGroupImpl;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.SearchQuery;

public abstract class AbstractMailboxProcessor<M extends ImapRequest>
extends AbstractChainedProcessor<M> {
    private final MailboxManager mailboxManager;
    private final StatusResponseFactory factory;

    public AbstractMailboxProcessor(Class<M> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(acceptableClass, next);
        this.mailboxManager = mailboxManager;
        this.factory = factory;
    }

    @Override
    protected final void doProcess(M acceptableMessage, ImapProcessor.Responder responder, ImapSession session) {
        M request = acceptableMessage;
        this.process(request, responder, session);
    }

    protected final void process(M message, ImapProcessor.Responder responder, ImapSession session) {
        ImapCommand command = message.getCommand();
        String tag = message.getTag();
        this.doProcess(message, command, tag, responder, session);
    }

    final void doProcess(M message, ImapCommand command, String tag, ImapProcessor.Responder responder, ImapSession session) {
        if (!command.validForState(session.getState())) {
            StatusResponse response = this.factory.taggedNo(tag, command, HumanReadableText.INVALID_COMMAND);
            responder.respond(response);
        } else {
            this.getMailboxManager().startProcessingRequest(ImapSessionUtils.getMailboxSession(session));
            this.doProcess(message, session, tag, command, responder);
            this.getMailboxManager().endProcessingRequest(ImapSessionUtils.getMailboxSession(session));
        }
    }

    protected void flags(ImapProcessor.Responder responder, SelectedMailbox selected) {
        responder.respond(new FlagsResponse(selected.getApplicableFlags()));
    }

    protected void permanentFlags(ImapProcessor.Responder responder, MessageManager.MetaData metaData, SelectedMailbox selected) {
        Flags permanentFlags = metaData.getPermanentFlags();
        if (permanentFlags.contains(Flags.Flag.USER)) {
            permanentFlags.add(selected.getApplicableFlags());
        }
        StatusResponse untaggedOk = this.factory.untaggedOk(HumanReadableText.permanentFlags(permanentFlags), StatusResponse.ResponseCode.permanentFlags(permanentFlags));
        responder.respond(untaggedOk);
    }

    protected void unsolicitedResponses(ImapSession session, ImapProcessor.Responder responder, boolean useUids) {
        this.unsolicitedResponses(session, responder, false, useUids);
    }

    protected void unsolicitedResponses(ImapSession session, ImapProcessor.Responder responder, boolean omitExpunged, boolean useUid) {
        SelectedMailbox selected = session.getSelected();
        if (selected == null) {
            if (session.getLog().isDebugEnabled()) {
                session.getLog().debug("No mailbox selected");
            }
        } else {
            this.unsolicitedResponses(session, responder, selected, omitExpunged, useUid);
        }
    }

    private void unsolicitedResponses(ImapSession session, ImapProcessor.Responder responder, SelectedMailbox selected, boolean omitExpunged, boolean useUid) {
        Collection<Long> expungedUids;
        boolean sizeChanged = selected.isSizeChanged();
        if (sizeChanged) {
            this.addExistsResponses(session, selected, responder);
        }
        if (!omitExpunged && !(expungedUids = selected.expungedUids()).isEmpty()) {
            if (EnableProcessor.getEnabledCapabilities(session).contains("QRESYNC")) {
                this.addVanishedResponse(selected, expungedUids, responder);
            } else {
                this.addExpungedResponses(selected, expungedUids, responder);
            }
            selected.resetExpungedUids();
        }
        if (sizeChanged || selected.isRecentUidRemoved() && !omitExpunged) {
            this.addRecentResponses(selected, responder);
            selected.resetRecentUidRemoved();
        }
        this.addFlagsResponses(session, selected, responder, useUid);
        selected.resetEvents();
    }

    private void addExpungedResponses(SelectedMailbox selected, Collection<Long> expungedUids, ImapProcessor.Responder responder) {
        for (Long uid : expungedUids) {
            long uidValue = uid;
            int msn = selected.remove(uidValue);
            ExpungeResponse response = new ExpungeResponse(msn);
            responder.respond(response);
        }
    }

    private void addVanishedResponse(SelectedMailbox selected, Collection<Long> expungedUids, ImapProcessor.Responder responder) {
        for (Long uid : expungedUids) {
            long uidValue = uid;
            selected.remove(uidValue);
        }
        IdRange[] uidRange = this.idRanges(MessageRange.toRanges(expungedUids));
        responder.respond(new VanishedResponse(uidRange, false));
    }

    private void addFlagsResponses(ImapSession session, SelectedMailbox selected, ImapProcessor.Responder responder, boolean useUid) {
        try {
            Collection<Long> flagUpdateUids;
            MessageManager mailbox = this.getMailbox(session, selected);
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            if (selected.hasNewApplicableFlags()) {
                this.flags(responder, selected);
                this.permanentFlags(responder, mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT), selected);
                selected.resetNewApplicableFlags();
            }
            if (!(flagUpdateUids = selected.flagUpdateUids()).isEmpty()) {
                Iterator ranges = MessageRange.toRanges(flagUpdateUids).iterator();
                while (ranges.hasNext()) {
                    this.addFlagsResponses(session, selected, responder, useUid, (MessageRange)ranges.next(), mailbox, mailboxSession);
                }
            }
        }
        catch (MailboxException e) {
            this.handleResponseException(responder, e, HumanReadableText.FAILURE_TO_LOAD_FLAGS, session);
        }
    }

    protected void addFlagsResponses(ImapSession session, SelectedMailbox selected, ImapProcessor.Responder responder, boolean useUid, MessageRange messageSet, MessageManager mailbox, MailboxSession mailboxSession) throws MailboxException {
        MessageResultIterator it = mailbox.getMessages(messageSet, FetchGroupImpl.MINIMAL, mailboxSession);
        while (it.hasNext()) {
            MessageResult mr = (MessageResult)it.next();
            long uid = mr.getUid();
            int msn = selected.msn(uid);
            if (msn == -1) {
                if (!session.getLog().isDebugEnabled()) continue;
                session.getLog().debug("No message found with uid " + uid + " in the uid<->msn mapping for mailbox " + selected.getPath().getFullName(mailboxSession.getPathDelimiter()) + " , this may be because it was deleted by a concurrent session. So skip it..");
                continue;
            }
            boolean qresyncEnabled = EnableProcessor.getEnabledCapabilities(session).contains("QRESYNC");
            boolean condstoreEnabled = EnableProcessor.getEnabledCapabilities(session).contains("CONDSTORE");
            Flags flags = mr.getFlags();
            Long uidOut = useUid || qresyncEnabled ? Long.valueOf(uid) : null;
            if (selected.isRecent(uid)) {
                flags.add(Flags.Flag.RECENT);
            } else {
                flags.remove(Flags.Flag.RECENT);
            }
            FetchResponse response = (condstoreEnabled || qresyncEnabled) && mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT).isModSeqPermanent() ? new FetchResponse(msn, flags, uidOut, mr.getModSeq(), null, null, null, null, null, null) : new FetchResponse(msn, flags, uidOut, null, null, null, null, null, null, null);
            responder.respond(response);
        }
    }

    protected void condstoreEnablingCommand(ImapSession session, ImapProcessor.Responder responder, MessageManager.MetaData metaData, boolean sendHighestModSeq) {
        Set<String> enabled = EnableProcessor.getEnabledCapabilities(session);
        if (!enabled.contains("CONDSTORE")) {
            if (sendHighestModSeq && metaData.isModSeqPermanent()) {
                long highestModSeq = metaData.getHighestModSeq();
                StatusResponse untaggedOk = this.getStatusResponseFactory().untaggedOk(HumanReadableText.HIGHEST_MOD_SEQ, StatusResponse.ResponseCode.highestModSeq(highestModSeq));
                responder.respond(untaggedOk);
            }
            enabled.add("CONDSTORE");
        }
    }

    private MessageManager getMailbox(ImapSession session, SelectedMailbox selected) throws MailboxException {
        MailboxManager mailboxManager = this.getMailboxManager();
        MessageManager mailbox = mailboxManager.getMailbox(selected.getPath(), ImapSessionUtils.getMailboxSession(session));
        return mailbox;
    }

    private void addRecentResponses(SelectedMailbox selected, ImapProcessor.Responder responder) {
        int recentCount = selected.recentCount();
        RecentResponse response = new RecentResponse(recentCount);
        responder.respond(response);
    }

    private void addExistsResponses(ImapSession session, SelectedMailbox selected, ImapProcessor.Responder responder) {
        long existsCount = selected.existsCount();
        ExistsResponse response = new ExistsResponse(existsCount);
        responder.respond(response);
    }

    private void handleResponseException(ImapProcessor.Responder responder, MailboxException e, HumanReadableText message, ImapSession session) {
        session.getLog().info(message.toString());
        session.getLog().debug(message.toString(), (Throwable)e);
        StatusResponse response = this.factory.untaggedNo(message);
        responder.respond(response);
    }

    protected void okComplete(ImapCommand command, String tag, ImapProcessor.Responder responder) {
        StatusResponse response = this.factory.taggedOk(tag, command, HumanReadableText.COMPLETED);
        responder.respond(response);
    }

    protected void okComplete(ImapCommand command, String tag, StatusResponse.ResponseCode code, ImapProcessor.Responder responder) {
        StatusResponse response = this.factory.taggedOk(tag, command, HumanReadableText.COMPLETED, code);
        responder.respond(response);
    }

    protected void no(ImapCommand command, String tag, ImapProcessor.Responder responder, HumanReadableText displayTextKey) {
        StatusResponse response = this.factory.taggedNo(tag, command, displayTextKey);
        responder.respond(response);
    }

    protected void no(ImapCommand command, String tag, ImapProcessor.Responder responder, HumanReadableText displayTextKey, StatusResponse.ResponseCode responseCode) {
        StatusResponse response = this.factory.taggedNo(tag, command, displayTextKey, responseCode);
        responder.respond(response);
    }

    protected void taggedBad(ImapCommand command, String tag, ImapProcessor.Responder responder, HumanReadableText e) {
        StatusResponse response = this.factory.taggedBad(tag, command, e);
        responder.respond(response);
    }

    protected void bye(ImapProcessor.Responder responder) {
        StatusResponse response = this.factory.bye(HumanReadableText.BYE);
        responder.respond(response);
    }

    protected void bye(ImapProcessor.Responder responder, HumanReadableText key) {
        StatusResponse response = this.factory.bye(key);
        responder.respond(response);
    }

    protected abstract void doProcess(M var1, ImapSession var2, String var3, ImapCommand var4, ImapProcessor.Responder var5);

    public MailboxPath buildFullPath(ImapSession session, String mailboxName) {
        String namespace = null;
        String name = null;
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        if (mailboxName == null || mailboxName.length() == 0) {
            return new MailboxPath("", "", "");
        }
        if (mailboxName.charAt(0) == '#') {
            int namespaceLength = mailboxName.indexOf(mailboxSession.getPathDelimiter());
            if (namespaceLength > -1) {
                namespace = mailboxName.substring(0, namespaceLength);
                if (mailboxName.length() > namespaceLength) {
                    name = mailboxName.substring(++namespaceLength);
                }
            } else {
                namespace = mailboxName;
            }
        } else {
            namespace = "#private";
            name = mailboxName;
        }
        String user = null;
        if (namespace.equals("#private")) {
            user = ImapSessionUtils.getUserName(session);
        }
        if (name.equalsIgnoreCase("INBOX")) {
            name = "INBOX";
        }
        return new MailboxPath(namespace, user, name);
    }

    private String joinMailboxPath(MailboxPath mailboxPath, char delimiter) {
        StringBuffer sb = new StringBuffer("");
        if (mailboxPath.getNamespace() != null && !mailboxPath.getNamespace().equals("")) {
            sb.append(mailboxPath.getNamespace());
        }
        if (mailboxPath.getUser() != null && !mailboxPath.getUser().equals("")) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(mailboxPath.getUser());
        }
        if (mailboxPath.getName() != null && !mailboxPath.getName().equals("")) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(mailboxPath.getName());
        }
        return sb.toString();
    }

    protected String mailboxName(boolean relative, MailboxPath path, char delimiter) {
        if (relative) {
            return path.getName();
        }
        return this.joinMailboxPath(path, delimiter);
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    protected StatusResponseFactory getStatusResponseFactory() {
        return this.factory;
    }

    protected MessageManager getSelectedMailbox(ImapSession session) throws MailboxException {
        MessageManager result;
        SelectedMailbox selectedMailbox = session.getSelected();
        if (selectedMailbox == null) {
            result = null;
        } else {
            MailboxManager mailboxManager = this.getMailboxManager();
            result = mailboxManager.getMailbox(selectedMailbox.getPath(), ImapSessionUtils.getMailboxSession(session));
        }
        return result;
    }

    protected MessageRange messageRange(SelectedMailbox selected, IdRange range, boolean useUids) throws MessageRangeException {
        long lowVal = range.getLowVal();
        long highVal = range.getHighVal();
        if (!useUids) {
            if (lowVal == Long.MAX_VALUE && highVal == Long.MAX_VALUE) {
                highVal = selected.getLastUid();
                if (highVal == -1L) {
                    throw new MessageRangeException("Mailbox is empty");
                }
                return MessageRange.one((long)highVal);
            }
            if (lowVal != Long.MIN_VALUE) {
                if ((lowVal = selected.uid((int)lowVal)) == -1L) {
                    throw new MessageRangeException("No message found with msn " + lowVal);
                }
            } else {
                lowVal = selected.getFirstUid();
                if (lowVal == -1L) {
                    throw new MessageRangeException("Mailbox is empty");
                }
            }
            if (highVal != Long.MAX_VALUE) {
                if ((highVal = selected.uid((int)highVal)) == -1L) {
                    throw new MessageRangeException("No message found with msn " + highVal);
                }
            } else {
                highVal = selected.getLastUid();
                if (highVal == -1L) {
                    throw new MessageRangeException("Mailbox is empty");
                }
            }
        } else {
            if (selected.existsCount() <= 0L) {
                return null;
            }
            if (lowVal == Long.MAX_VALUE && highVal == Long.MAX_VALUE) {
                return MessageRange.one((long)selected.getLastUid());
            }
            if (highVal == Long.MAX_VALUE && selected.getLastUid() < lowVal) {
                return MessageRange.one((long)selected.getLastUid());
            }
        }
        MessageRange mRange = MessageRange.range((long)lowVal, (long)highVal);
        return mRange;
    }

    protected MessageRange normalizeMessageRange(SelectedMailbox selected, MessageRange range) throws MessageRangeException {
        MessageRange.Type rangeType = range.getType();
        switch (rangeType) {
            case ONE: {
                return range;
            }
            case ALL: {
                long start = selected.getFirstUid();
                long end = selected.getLastUid();
                return MessageRange.range((long)start, (long)end);
            }
            case RANGE: {
                long end;
                long start = range.getUidFrom();
                if (start < 1L || start == Long.MAX_VALUE || start < selected.getFirstUid()) {
                    start = selected.getFirstUid();
                }
                if ((end = range.getUidTo()) < 1L || end == Long.MAX_VALUE || end > selected.getLastUid()) {
                    end = selected.getLastUid();
                }
                return MessageRange.range((long)start, (long)end);
            }
            case FROM: {
                long start = range.getUidFrom();
                if (start < 1L || start == Long.MAX_VALUE || start < selected.getFirstUid()) {
                    start = selected.getFirstUid();
                }
                long end = selected.getLastUid();
                return MessageRange.range((long)start, (long)end);
            }
        }
        throw new MessageRangeException("Unknown message range type: " + rangeType);
    }

    protected void respondVanished(MailboxSession session, MessageManager mailbox, List<MessageRange> ranges, long changedSince, MessageManager.MetaData metaData, ImapProcessor.Responder responder) throws MailboxException {
        if (metaData.getHighestModSeq() > changedSince) {
            SearchQuery searchQuery = new SearchQuery();
            SearchQuery.NumericRange[] nRanges = new SearchQuery.NumericRange[ranges.size()];
            HashSet<Long> vanishedUids = new HashSet<Long>();
            for (int i = 0; i < ranges.size(); ++i) {
                MessageRange r = ranges.get(i);
                SearchQuery.NumericRange nr = r.getType() == MessageRange.Type.ONE ? new SearchQuery.NumericRange(r.getUidFrom()) : new SearchQuery.NumericRange(r.getUidFrom(), r.getUidTo());
                long from = nr.getLowValue();
                long to = nr.getHighValue();
                while (from <= to) {
                    vanishedUids.add(from++);
                }
                nRanges[i] = nr;
            }
            searchQuery.andCriteria(SearchQuery.uid((SearchQuery.NumericRange[])nRanges));
            searchQuery.andCriteria(SearchQuery.modSeqGreaterThan((long)changedSince));
            Iterator uids = mailbox.search(searchQuery, session);
            while (uids.hasNext()) {
                vanishedUids.remove(uids.next());
            }
            IdRange[] vanishedIdRanges = this.idRanges(MessageRange.toRanges(vanishedUids));
            responder.respond(new VanishedResponse(vanishedIdRanges, true));
        }
    }

    protected IdRange[] idRanges(Collection<MessageRange> mRanges) {
        IdRange[] idRanges = new IdRange[mRanges.size()];
        Iterator<MessageRange> mIt = mRanges.iterator();
        int i = 0;
        while (mIt.hasNext()) {
            MessageRange mr = mIt.next();
            IdRange ir = mr.getType() == MessageRange.Type.ONE ? new IdRange(mr.getUidFrom()) : new IdRange(mr.getUidFrom(), mr.getUidTo());
            idRanges[i++] = ir;
        }
        return idRanges;
    }
}

