/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.MailboxStatusResponse;

public class MailboxStatusResponseEncoder
extends AbstractChainedImapEncoder
implements ImapConstants {
    public MailboxStatusResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        MailboxStatusResponse response = (MailboxStatusResponse)acceptableMessage;
        Long messages = response.getMessages();
        Long recent = response.getRecent();
        Long uidNext = response.getUidNext();
        Long highestModSeq = response.getHighestModSeq();
        Long uidValidity = response.getUidValidity();
        Long unseen = response.getUnseen();
        String mailboxName = response.getMailbox();
        composer.untagged();
        composer.message("STATUS");
        composer.quote(mailboxName);
        composer.openParen();
        if (messages != null) {
            composer.message("MESSAGES");
            long messagesValue = messages;
            composer.message(messagesValue);
        }
        if (recent != null) {
            composer.message("RECENT");
            long recentValue = recent;
            composer.message(recentValue);
        }
        if (uidNext != null) {
            composer.message("UIDNEXT");
            long uidNextValue = uidNext;
            composer.message(uidNextValue);
        }
        if (highestModSeq != null) {
            composer.message("HIGHESTMODSEQ");
            composer.message(highestModSeq);
        }
        if (uidValidity != null) {
            composer.message("UIDVALIDITY");
            long uidValidityValue = uidValidity;
            composer.message(uidValidityValue);
        }
        if (unseen != null) {
            composer.message("UNSEEN");
            long unseenValue = unseen;
            composer.message(unseenValue);
        }
        composer.closeParen();
        composer.end();
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return message != null && message instanceof MailboxStatusResponse;
    }
}

