/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DelegatingImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParserFactory;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.protocols.imap.DecodingException;

public class UidCommandParser
extends AbstractImapCommandParser
implements DelegatingImapCommandParser {
    private ImapCommandParserFactory parserFactory;

    public UidCommandParser() {
        super(ImapCommand.selectedStateCommand("UID"));
    }

    @Override
    public ImapCommandParserFactory getParserFactory() {
        return this.parserFactory;
    }

    @Override
    public void setParserFactory(ImapCommandParserFactory imapCommandFactory) {
        this.parserFactory = imapCommandFactory;
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, ImapSession session) throws DecodingException {
        String commandName = request.atom();
        ImapCommandParser helperCommand = this.parserFactory.getParser(commandName);
        if (helperCommand == null || !(helperCommand instanceof AbstractUidCommandParser)) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid UID command: '" + commandName + "'");
        }
        AbstractUidCommandParser uidEnabled = (AbstractUidCommandParser)helperCommand;
        ImapMessage result = uidEnabled.decode(request, tag, true, session);
        return result;
    }
}

