/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.FetchPartPathDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.FetchRequest;
import org.apache.james.protocols.imap.DecodingException;

public class FetchCommandParser
extends AbstractUidCommandParser {
    private static final byte[] CHANGEDSINCE = "CHANGEDSINCE".getBytes();
    private static final byte[] VANISHED = "VANISHED".getBytes();

    public FetchCommandParser() {
        super(ImapCommand.selectedStateCommand("FETCH"));
    }

    protected FetchData fetchRequest(ImapRequestLineReader request) throws DecodingException {
        FetchData fetch = new FetchData();
        char next = this.nextNonSpaceChar(request);
        if (request.nextChar() == '(') {
            request.consumeChar('(');
            next = this.nextNonSpaceChar(request);
            while (next != ')') {
                this.addNextElement(request, fetch);
                next = this.nextNonSpaceChar(request);
            }
            request.consumeChar(')');
            next = this.nextNonSpaceChar(request);
            if (next == '(') {
                request.consumeChar('(');
                next = request.nextChar();
                switch (next) {
                    case 'C': {
                        request.consumeWord(new ImapRequestLineReader.CharacterValidator(){
                            int pos = 0;

                            @Override
                            public boolean isValid(char chr) {
                                if (this.pos > CHANGEDSINCE.length) {
                                    return false;
                                }
                                return CHANGEDSINCE[this.pos++] == ImapRequestLineReader.cap(chr);
                            }
                        });
                        fetch.setChangedSince(request.number(true));
                        break;
                    }
                    case 'V': {
                        request.consumeWord(new ImapRequestLineReader.CharacterValidator(){
                            int pos = 0;

                            @Override
                            public boolean isValid(char chr) {
                                if (this.pos > VANISHED.length) {
                                    return false;
                                }
                                return VANISHED[this.pos++] == ImapRequestLineReader.cap(chr);
                            }
                        });
                        fetch.setVanished(true);
                    }
                }
                request.consumeChar(')');
            }
        } else {
            this.addNextElement(request, fetch);
        }
        return fetch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addNextElement(ImapRequestLineReader reader, FetchData fetch) throws DecodingException {
        String name = this.readWord(reader, " [)\r\n");
        char next = reader.nextChar();
        if (next != '[') {
            if ("FAST".equalsIgnoreCase(name)) {
                fetch.setFlags(true);
                fetch.setInternalDate(true);
                fetch.setSize(true);
                return;
            } else if ("FULL".equalsIgnoreCase(name)) {
                fetch.setFlags(true);
                fetch.setInternalDate(true);
                fetch.setSize(true);
                fetch.setEnvelope(true);
                fetch.setBody(true);
                return;
            } else if ("ALL".equalsIgnoreCase(name)) {
                fetch.setFlags(true);
                fetch.setInternalDate(true);
                fetch.setSize(true);
                fetch.setEnvelope(true);
                return;
            } else if ("FLAGS".equalsIgnoreCase(name)) {
                fetch.setFlags(true);
                return;
            } else if ("RFC822.SIZE".equalsIgnoreCase(name)) {
                fetch.setSize(true);
                return;
            } else if ("ENVELOPE".equalsIgnoreCase(name)) {
                fetch.setEnvelope(true);
                return;
            } else if ("INTERNALDATE".equalsIgnoreCase(name)) {
                fetch.setInternalDate(true);
                return;
            } else if ("BODY".equalsIgnoreCase(name)) {
                fetch.setBody(true);
                return;
            } else if ("BODYSTRUCTURE".equalsIgnoreCase(name)) {
                fetch.setBodyStructure(true);
                return;
            } else if ("UID".equalsIgnoreCase(name)) {
                fetch.setUid(true);
                return;
            } else if ("RFC822".equalsIgnoreCase(name)) {
                fetch.add(BodyFetchElement.createRFC822(), false);
                return;
            } else if ("RFC822.HEADER".equalsIgnoreCase(name)) {
                fetch.add(BodyFetchElement.createRFC822Header(), true);
                return;
            } else if ("RFC822.TEXT".equalsIgnoreCase(name)) {
                fetch.add(BodyFetchElement.createRFC822Text(), false);
                return;
            } else {
                if (!"MODSEQ".equalsIgnoreCase(name)) throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid fetch attribute: " + name);
                fetch.setModSeq(true);
            }
            return;
        } else {
            Long numberOfOctets;
            Long firstOctet;
            reader.consumeChar('[');
            String parameter = this.readWord(reader, "]");
            reader.consumeChar(']');
            if (reader.nextChar() == '<') {
                reader.consumeChar('<');
                firstOctet = reader.number();
                if (reader.nextChar() == '.') {
                    reader.consumeChar('.');
                    numberOfOctets = new Long(reader.nzNumber());
                } else {
                    numberOfOctets = null;
                }
                reader.consumeChar('>');
            } else {
                firstOctet = null;
                numberOfOctets = null;
            }
            BodyFetchElement bodyFetchElement = this.createBodyElement(parameter, firstOctet, numberOfOctets);
            boolean isPeek = this.isPeek(name);
            fetch.add(bodyFetchElement, isPeek);
        }
    }

    private boolean isPeek(String name) throws DecodingException {
        boolean isPeek;
        if ("BODY".equalsIgnoreCase(name)) {
            isPeek = false;
        } else if ("BODY.PEEK".equalsIgnoreCase(name)) {
            isPeek = true;
        } else {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid fetch attibute: " + name + "[]");
        }
        return isPeek;
    }

    private BodyFetchElement createBodyElement(String parameter, Long firstOctet, Long numberOfOctets) throws DecodingException {
        String responseName = "BODY[" + parameter + "]";
        FetchPartPathDecoder decoder = new FetchPartPathDecoder();
        decoder.decode(parameter);
        int sectionType = this.getSectionType(decoder);
        List<String> names = decoder.getNames();
        int[] path = decoder.getPath();
        BodyFetchElement bodyFetchElement = new BodyFetchElement(responseName, sectionType, path, names, firstOctet, numberOfOctets);
        return bodyFetchElement;
    }

    private int getSectionType(FetchPartPathDecoder decoder) throws DecodingException {
        int sectionType;
        int specifier = decoder.getSpecifier();
        switch (specifier) {
            case 5: {
                sectionType = 5;
                break;
            }
            case 2: {
                sectionType = 2;
                break;
            }
            case 3: {
                sectionType = 3;
                break;
            }
            case 4: {
                sectionType = 4;
                break;
            }
            case 1: {
                sectionType = 1;
                break;
            }
            case 0: {
                sectionType = 0;
                break;
            }
            default: {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Section type is unsupported.");
            }
        }
        return sectionType;
    }

    private String readWord(ImapRequestLineReader request, String terminator) throws DecodingException {
        StringBuffer buf = new StringBuffer();
        char next = request.nextChar();
        while (terminator.indexOf(next) == -1) {
            buf.append(next);
            request.consume();
            next = request.nextChar();
        }
        return buf.toString();
    }

    private char nextNonSpaceChar(ImapRequestLineReader request) throws DecodingException {
        char next = request.nextChar();
        while (next == ' ') {
            request.consume();
            next = request.nextChar();
        }
        return next;
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, boolean useUids, ImapSession session) throws DecodingException {
        IdRange[] idSet = request.parseIdRange(session);
        FetchData fetch = this.fetchRequest(request);
        if (fetch.getVanished() && !useUids) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "VANISHED only allowed in UID FETCH");
        }
        request.eol();
        FetchRequest result = new FetchRequest(command, useUids, idSet, fetch, tag);
        return result;
    }
}

