/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.CopyRequest;
import org.apache.james.protocols.imap.DecodingException;

public class CopyCommandParser
extends AbstractUidCommandParser {
    public CopyCommandParser() {
        this(ImapCommand.selectedStateCommand("COPY"));
    }

    protected CopyCommandParser(ImapCommand command) {
        super(command);
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, boolean useUids, ImapSession session) throws DecodingException {
        IdRange[] idSet = request.parseIdRange(session);
        String mailboxName = request.mailbox();
        request.eol();
        CopyRequest result = this.createRequest(command, tag, useUids, idSet, mailboxName);
        return result;
    }

    protected CopyRequest createRequest(ImapCommand command, String tag, boolean useUids, IdRange[] idSet, String mailboxName) {
        return new CopyRequest(command, idSet, mailboxName, useUids, tag);
    }
}

