/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.util.Date;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.AppendRequest;
import org.apache.james.protocols.imap.DecodingException;

public class AppendCommandParser
extends AbstractImapCommandParser {
    public AppendCommandParser() {
        super(ImapCommand.authenticatedStateCommand("APPEND"));
    }

    public Flags optionalAppendFlags(ImapRequestLineReader request) throws DecodingException {
        char next = request.nextWordChar();
        if (next == '(') {
            return request.flagList();
        }
        return null;
    }

    public Date optionalDateTime(ImapRequestLineReader request) throws DecodingException {
        char next = request.nextWordChar();
        if (next == '\"') {
            return request.dateTime();
        }
        return null;
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, ImapSession session) throws DecodingException {
        Date datetime;
        String mailboxName = request.mailbox();
        Flags flags = this.optionalAppendFlags(request);
        if (flags == null) {
            flags = new Flags();
        }
        if ((datetime = this.optionalDateTime(request)) == null) {
            datetime = new Date();
        }
        request.nextWordChar();
        AppendRequest result = new AppendRequest(command, mailboxName, flags, datetime, request.consumeLiteral(true), tag);
        return result;
    }
}

