/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.AbstractMailboxSelectionRequest;
import org.apache.james.protocols.imap.DecodingException;

public abstract class AbstractSelectionCommandParser
extends AbstractImapCommandParser {
    private static final byte[] CONDSTORE = "CONDSTORE".getBytes();
    private static final byte[] QRESYNC = "QRESYNC".getBytes();

    public AbstractSelectionCommandParser(ImapCommand command) {
        super(command);
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, ImapSession session) throws DecodingException {
        String mailboxName = request.mailbox();
        boolean condstore = false;
        Long lastKnownUidValidity = null;
        Long knownModSeq = null;
        IdRange[] uidSet = null;
        IdRange[] knownUidSet = null;
        IdRange[] knownSequenceSet = null;
        char c = '\u0000';
        try {
            c = request.nextWordChar();
        }
        catch (DecodingException e) {
            // empty catch block
        }
        if (c == '(') {
            request.consume();
            int n = ImapRequestLineReader.cap(request.nextChar());
            switch (n) {
                case 67: {
                    int pos = 0;
                    while (pos < CONDSTORE.length) {
                        if (CONDSTORE[pos++] == ImapRequestLineReader.cap(request.consume())) continue;
                        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown option");
                    }
                    condstore = true;
                    break;
                }
                case 81: {
                    request.consumeWord(new ImapRequestLineReader.CharacterValidator(){
                        int pos = 0;

                        @Override
                        public boolean isValid(char chr) {
                            if (this.pos >= QRESYNC.length) {
                                return false;
                            }
                            return ImapRequestLineReader.cap(chr) == QRESYNC[this.pos++];
                        }
                    });
                    request.consumeChar(' ');
                    request.consumeChar('(');
                    lastKnownUidValidity = request.number();
                    request.consumeChar(' ');
                    knownModSeq = request.number(true);
                    char nc = request.nextChar();
                    if (nc == ' ') {
                        request.consumeChar(' ');
                        uidSet = request.parseIdRange();
                        this.checkIdRanges(uidSet, false);
                        nc = request.nextChar();
                        if (nc == ' ') {
                            request.consumeChar(' ');
                            request.consumeChar('(');
                            knownSequenceSet = request.parseIdRange();
                            request.consumeChar(' ');
                            knownUidSet = request.parseIdRange();
                            this.checkIdRanges(knownSequenceSet, true);
                            this.checkIdRanges(knownUidSet, true);
                            request.consumeChar(')');
                        }
                    }
                    request.consumeChar(')');
                    break;
                }
                default: {
                    throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown option");
                }
            }
            request.consumeChar(')');
        }
        request.eol();
        AbstractMailboxSelectionRequest result = this.createRequest(command, mailboxName, condstore, lastKnownUidValidity, knownModSeq, uidSet, knownUidSet, knownSequenceSet, tag);
        return result;
    }

    private void checkIdRanges(IdRange[] ranges, boolean checkOrder) throws DecodingException {
        long last = 0L;
        for (int i = 0; i < ranges.length; ++i) {
            IdRange r = ranges[i];
            long low = r.getLowVal();
            long high = r.getHighVal();
            if (low == Long.MAX_VALUE || high == Long.MAX_VALUE) {
                throw new DecodingException(HumanReadableText.INVALID_MESSAGESET, "* is not allowed in the sequence-set");
            }
            if (!checkOrder) continue;
            if (low < last) {
                throw new DecodingException(HumanReadableText.INVALID_MESSAGESET, "Sequence-set must be in ascending order");
            }
            last = high;
        }
    }

    protected abstract AbstractMailboxSelectionRequest createRequest(ImapCommand var1, String var2, boolean var3, Long var4, Long var5, IdRange[] var6, IdRange[] var7, IdRange[] var8, String var9);
}

