/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.main;

import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParserFactory;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.protocols.imap.DecodingException;
import org.slf4j.Logger;

public class DefaultImapDecoder
implements ImapDecoder {
    private final StatusResponseFactory responseFactory;
    private final ImapCommandParserFactory imapCommands;
    private int maxInvalidCommands;
    private static final String INVALID_COMMAND_COUNT = "INVALID_COMMAND_COUNT";
    public static final int DEFAULT_MAX_INVALID_COMMANDS = 9;

    public DefaultImapDecoder(StatusResponseFactory responseFactory, ImapCommandParserFactory imapCommands) {
        this(responseFactory, imapCommands, 9);
    }

    public DefaultImapDecoder(StatusResponseFactory responseFactory, ImapCommandParserFactory imapCommands, int maxInvalidCommands) {
        this.responseFactory = responseFactory;
        this.imapCommands = imapCommands;
        this.maxInvalidCommands = maxInvalidCommands;
    }

    @Override
    public ImapMessage decode(ImapRequestLineReader request, ImapSession session) {
        ImapMessage message;
        Logger logger = session.getLog();
        try {
            String tag = request.tag();
            message = this.decodeCommandTagged(request, tag, session);
        }
        catch (DecodingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot parse tag", (Throwable)e);
            }
            message = this.unknownCommand(null, session);
        }
        return message;
    }

    private ImapMessage decodeCommandTagged(ImapRequestLineReader request, String tag, ImapSession session) {
        ImapMessage message;
        if (session.getLog().isDebugEnabled()) {
            session.getLog().debug("Got <tag>: " + tag);
        }
        try {
            String commandName = request.atom();
            message = this.decodeCommandNamed(request, tag, commandName, session);
        }
        catch (DecodingException e) {
            if (session.getLog().isDebugEnabled()) {
                session.getLog().debug("Error during initial request parsing", (Throwable)e);
            }
            message = this.unknownCommand(tag, session);
        }
        return message;
    }

    private ImapMessage unknownCommand(String tag, ImapSession session) {
        StatusResponse message;
        Object c = session.getAttribute(INVALID_COMMAND_COUNT);
        int count = 0;
        if (c != null) {
            count = (Integer)c;
        }
        if (++count > this.maxInvalidCommands || session.getState() == ImapSessionState.NON_AUTHENTICATED) {
            message = this.responseFactory.bye(HumanReadableText.BYE_UNKNOWN_COMMAND);
            session.logout();
        } else {
            session.setAttribute(INVALID_COMMAND_COUNT, count);
            message = tag == null ? this.responseFactory.untaggedBad(HumanReadableText.UNKNOWN_COMMAND) : this.responseFactory.taggedBad(tag, null, HumanReadableText.UNKNOWN_COMMAND);
        }
        return message;
    }

    private ImapMessage decodeCommandNamed(ImapRequestLineReader request, String tag, String commandName, ImapSession session) {
        ImapMessage message;
        ImapCommandParser command;
        if (session.getLog().isDebugEnabled()) {
            session.getLog().debug("Got <command>: " + commandName);
        }
        if ((command = this.imapCommands.getParser(commandName)) == null) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Missing command implementation for commmand " + commandName);
            }
            message = this.unknownCommand(tag, session);
        } else {
            message = command.parse(request, tag, session);
            session.setAttribute(INVALID_COMMAND_COUNT, 0);
        }
        return message;
    }
}

