/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.memory;

import com.google.inject.Module;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.MemoryJamesConfiguration;
import org.apache.james.MemoryJamesServerMain;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.util.Port;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.PortSupplier;
import org.apache.james.webadmin.RandomPortSupplier;
import org.apache.james.webadmin.WebAdminConfiguration;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.integration.UnauthorizedModule;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class DisabledMetricsTest {
    @RegisterExtension
    static JamesServerExtension jamesServerExtension = new JamesServerBuilder(tmpDir -> MemoryJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().usersRepository(UsersRepositoryModuleChooser.Implementation.DEFAULT).build()).server(configuration -> MemoryJamesServerMain.createServer((MemoryJamesConfiguration)configuration).overrideWith(new Module[]{new UnauthorizedModule()}).overrideWith(new Module[]{binder -> binder.bind(WebAdminConfiguration.class).toInstance((Object)WebAdminConfiguration.builder().enabled().host("127.0.0.1").port((PortSupplier)new RandomPortSupplier()).build())})).lifeCycle(JamesServerExtension.Lifecycle.PER_CLASS).build();

    DisabledMetricsTest() {
    }

    @BeforeEach
    void setUp(GuiceJamesServer guiceJamesServer) {
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
    }

    @Test
    void getMetricsShouldReturnNotFoundWhenAdditionalRouteNotConfigured() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/metrics", new Object[0])).then()).statusCode(404);
    }
}

