/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import com.google.crypto.tink.apps.webpush.WebPushHybridDecrypt;
import com.google.crypto.tink.subtle.EllipticCurves;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.PushSubscriptionProbe;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.SMTPMessageSender;
import org.apache.james.utils.SpoolerProbe;
import org.apache.james.utils.UpdatableTickingClock;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.mock.action.ExpectationResponseCallback;
import org.mockserver.model.Body;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.Not;
import org.mockserver.model.RequestDefinition;
import org.mockserver.verify.VerificationTimes;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsString;
import play.api.libs.json.Json$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-caB\b\u0011!\u0003\r\t!\b\u0005\u0006I\u0001!\t!\n\u0005\tS\u0001A)\u0019!C\u0005U!A1\u0007\u0001EC\u0002\u0013%A\u0007C\u0003A\u0001\u0011\u0005\u0011\tC\u0003T\u0001\u0011%A\u000bC\u0003`\u0001\u0011%\u0001\rC\u0003c\u0001\u0011%1\rC\u0003i\u0001\u0011%\u0011\u000eC\u0003l\u0001\u0011%A\u000eC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA!\u0001\u0011\u0005\u00111\t\u0002\u0010/\u0016\u0014\u0007+^:i\u0007>tGO]1di*\u0011\u0011CE\u0001\tG>tGO]1di*\u00111\u0003F\u0001\be\u001a\u001c\u0007H\u000e\u001a2\u0015\t)b#\u0001\u0003k[\u0006\u0004(BA\f\u0019\u0003\u0015Q\u0017-\\3t\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u00051\u0003CA\u0010(\u0013\tA\u0003E\u0001\u0003V]&$\u0018!F1xC&$\u0018\t^'pgR$VM\\*fG>tGm]\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005G>\u0014XM\u0003\u000215\u0005Q\u0011m^1ji&d\u0017\u000e^=\n\u0005Ij#\u0001E\"p]\u0012LG/[8o\r\u0006\u001cGo\u001c:z\u00035\u0001Vk\u0015%`+Jcu\fU!U\u0011V\tQ\u0007\u0005\u00027{9\u0011qg\u000f\t\u0003q\u0001j\u0011!\u000f\u0006\u0003uq\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f!\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q\u0002\u0013!B:fiV\u0003HC\u0001\u0014C\u0011\u0015\u0019E\u00011\u0001E\u0003\u0019\u0019XM\u001d<feB\u0011QIR\u0007\u0002-%\u0011qI\u0006\u0002\u0011\u000fVL7-\u001a&b[\u0016\u001c8+\u001a:wKJD#\u0001B%\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015aA1qS*\u0011ajT\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0001&$A\u0003kk:LG/\u0003\u0002S\u0017\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002!\u001d,G\u000fU;tQN+'O^3s+JdGCA\u001bV\u0011\u00151V\u00011\u0001X\u0003)\u0001Xo\u001d5TKJ4XM\u001d\t\u00031vk\u0011!\u0017\u0006\u00035n\u000b1\"\u001b8uK\u001e\u0014\u0018\r^5p]*\u0011ALG\u0001\u000b[>\u001c7n]3sm\u0016\u0014\u0018B\u00010Z\u0005=\u0019E.[3oi\u0006sGmU3sm\u0016\u0014\u0018AF2sK\u0006$X\rU;tQN+(m]2sSB$\u0018n\u001c8\u0015\u0005U\n\u0007\"\u0002,\u0007\u0001\u00049\u0016AH;qI\u0006$XMV1mS\u0012\fG/\u001a,fe&4\u0017nY1uS>t7i\u001c3f)\r)DM\u001a\u0005\u0006K\u001e\u0001\r!N\u0001\u0013aV\u001c\bnU;cg\u000e\u0014\u0018\u000e\u001d;j_:LE\rC\u0003h\u000f\u0001\u0007Q'\u0001\twKJLg-[2bi&|gnQ8eK\u0006q1/\u001a8e\u000b6\f\u0017\u000e\u001c+p\u0005>\u0014GC\u0001\u0014k\u0011\u0015\u0019\u0005\u00021\u0001E\u0003]\u0019X\r^;q!V\u001c\bnU3sm\u0016\u00148)\u00197mE\u0006\u001c7\u000e\u0006\u0002nsB\u0019an^\u001b\u000e\u0003=T!\u0001]9\u0002\r\u0005$x.\\5d\u0015\t\u00118/\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001^;\u0002\tU$\u0018\u000e\u001c\u0006\u0002m\u0006!!.\u0019<b\u0013\tAxNA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f\u0011\u00151\u0016\u00021\u0001X\u0003u\u0019wN\u001d:fGR\u0014U\r[1wS>,(o\u00155pk2$7+^2dKN\u001cHc\u0001\u0014}{\")1I\u0003a\u0001\t\")aK\u0003a\u0001/\"2!b`A\u0003\u0003\u000f\u00012ASA\u0001\u0013\r\t\u0019a\u0013\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017EAA\u0005\u00031\u0011\u0015m]5d\r\u0016\fG/\u001e:fQ\rQ\u0011Q\u0002\t\u0004\u0015\u0006=\u0011bAA\t\u0017\n!A+Z:u\u0003]:XM\u0019)vg\"\u001c\u0006n\\;mI:{G\u000fU;tQR{\u0007+^:i'\u0016\u0014h/\u001a:XQ\u0016tW\t\u001f9je\u0016$7+\u001e2tGJL\u0007\u000f^5p]R9a%a\u0006\u0002\u001a\u0005m\u0001\"B\"\f\u0001\u0004!\u0005\"\u0002,\f\u0001\u00049\u0006bBA\u000f\u0017\u0001\u0007\u0011qD\u0001\u0006G2|7m\u001b\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\f\u0002\u000bU$\u0018\u000e\\:\n\t\u0005%\u00121\u0005\u0002\u0016+B$\u0017\r^1cY\u0016$\u0016nY6j]\u001e\u001cEn\\2lQ\rY\u0011QB\u00018o\u0016\u0014\u0007+^:i'\"|W\u000f\u001c3O_R\u0004Vo\u001d5U_B+8\u000f[*feZ,'o\u00165f]\u0012+G.\u001a;fIN+(m]2sSB$\u0018n\u001c8\u0015\u000b\u0019\n\t$a\r\t\u000b\rc\u0001\u0019\u0001#\t\u000bYc\u0001\u0019A,)\u00071\ti!\u0001\u001bxK\n\u0004Vo\u001d5TQ>,H\u000e\u001a(piB+8\u000f\u001b+p!V\u001c\bnU3sm\u0016\u0014x\u000b[3o\u001d>$h+\u00197jI\u0006$X\rZ\"pI\u0016$RAJA\u001e\u0003{AQaQ\u0007A\u0002\u0011CQAV\u0007A\u0002]C3!DA\u0007\u0003=\u001awN\u001d:fGR\u0014U\r[1wS>,(o\u00155pk2$7+^2dKN\u001cx\u000b[3o\u000b:\u001c'/\u001f9uS>t7*Z=t)\u00151\u0013QIA$\u0011\u0015\u0019e\u00021\u0001E\u0011\u00151f\u00021\u0001XQ\rq\u0011Q\u0002")
public interface WebPushContract {
    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds$(WebPushContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds() {
        return Awaitility.with().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).and().with().pollDelay(Durations.ONE_HUNDRED_MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ String org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH$(WebPushContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH();
    }

    default public String org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH() {
        return "/push2";
    }

    public static /* synthetic */ void setUp$(WebPushContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
    }

    private String getPushServerUrl(ClientAndServer pushServer) {
        return new StringBuilder(17).append("http://127.0.0.1:").append(pushServer.getLocalPort()).append(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).toString();
    }

    private String createPushSubscription(ClientAndServer pushServer) {
        return (String)((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(567).append("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"a889-ffea-910\",\n           |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n           |                  \"types\": [\"Mailbox\"]\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }").toString()))).when().post()).then().statusCode(200).extract().jsonPath().get("methodResponses[0][1].created.4f29.id");
    }

    private String updateValidateVerificationCode(String pushSubscriptionId, String verificationCode) {
        return ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(459).append("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"update\": {\n           |                \"").append(pushSubscriptionId).append("\": {\n           |                  \"verificationCode\": \"").append(verificationCode).append("\"\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
    }

    private void sendEmailToBob(GuiceJamesServer server) {
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender(Fixture$.MODULE$.DOMAIN().asString());
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).authenticate(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD()).sendMessage(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.BOB().asString());
        smtpMessageSender.close();
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().until(() -> Predef$.MODULE$.boolean2Boolean(((SpoolerProbe)server.getProbe(SpoolerProbe.class)).processingFinished()));
    }

    private AtomicReference<String> setupPushServerCallback(ClientAndServer pushServer) {
        AtomicReference<String> bodyRequestOnPushServer = new AtomicReference<String>("");
        pushServer.when((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withMethod("POST")).respond(new ExpectationResponseCallback(null, bodyRequestOnPushServer){
            private final AtomicReference bodyRequestOnPushServer$1;

            public HttpResponse handle(HttpRequest httpRequest) {
                this.bodyRequestOnPushServer$1.set(httpRequest.getBodyAsString());
                return HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(201));
            }
            {
                this.bodyRequestOnPushServer$1 = bodyRequestOnPushServer$1;
            }
        });
        return bodyRequestOnPushServer;
    }

    public static /* synthetic */ void correctBehaviourShouldSuccess$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.correctBehaviourShouldSuccess(server, pushServer);
    }

    @Test
    @Tag(value="BasicFeature")
    default public void correctBehaviourShouldSuccess(GuiceJamesServer server, ClientAndServer pushServer) {
        AtomicReference<String> bodyRequestOnPushServer = this.setupPushServerCallback(pushServer);
        String pushSubscriptionId = this.createPushSubscription(pushServer);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> pushServer.verify((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withBody((Body)JsonBody.json((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(172).append("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"").append(pushSubscriptionId).append("\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}").toString())))), VerificationTimes.atLeast((int)1)));
        String verificationCode = ((JsString)((JsObject)Json$.MODULE$.parse(bodyRequestOnPushServer.get())).value().apply((Object)"verificationCode")).value();
        String updateVerificationCodeResponse = this.updateValidateVerificationCode(pushSubscriptionId, verificationCode);
        JsonAssertions.assertThatJson((Object)updateVerificationCodeResponse).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(390).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"").append(pushSubscriptionId).append("\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
        this.sendEmailToBob(server);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> pushServer.verify((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withBody((Body)JsonBody.json((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(223).append("{\n             |    \"@type\": \"StateChange\",\n             |    \"changed\": {\n             |        \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\": {\n             |          \"Mailbox\": \"${json-unit.any-string}\"\n             |        }\n             |    }\n             |}").toString())))), VerificationTimes.atLeast((int)1)));
    }

    public static /* synthetic */ void webPushShouldNotPushToPushServerWhenExpiredSubscription$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer, UpdatableTickingClock clock) {
        $this.webPushShouldNotPushToPushServerWhenExpiredSubscription(server, pushServer, clock);
    }

    @Test
    default public void webPushShouldNotPushToPushServerWhenExpiredSubscription(GuiceJamesServer server, ClientAndServer pushServer, UpdatableTickingClock clock) {
        AtomicReference<String> bodyRequestOnPushServer = this.setupPushServerCallback(pushServer);
        String pushSubscriptionId = this.createPushSubscription(pushServer);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> pushServer.verify((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withBody((Body)JsonBody.json((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(172).append("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"").append(pushSubscriptionId).append("\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}").toString())))), VerificationTimes.atLeast((int)1)));
        String verificationCode = ((JsString)((JsObject)Json$.MODULE$.parse(bodyRequestOnPushServer.get())).value().apply((Object)"verificationCode")).value();
        String updateVerificationCodeResponse = this.updateValidateVerificationCode(pushSubscriptionId, verificationCode);
        JsonAssertions.assertThatJson((Object)updateVerificationCodeResponse).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(390).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"").append(pushSubscriptionId).append("\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
        clock.setInstant(clock.instant().plus(8L, ChronoUnit.DAYS));
        this.sendEmailToBob(server);
        TimeUnit.MILLISECONDS.sleep(200L);
        pushServer.verify((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withBody((Body)JsonBody.json((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(209).append("{\n           |    \"@type\": \"StateChange\",\n           |    \"changed\": {\n           |        \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\": {\n           |          \"Mailbox\": \"${json-unit.any-string}\"\n           |        }\n           |    }\n           |}").toString())))), VerificationTimes.exactly((int)0));
    }

    public static /* synthetic */ void webPushShouldNotPushToPushServerWhenDeletedSubscription$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.webPushShouldNotPushToPushServerWhenDeletedSubscription(server, pushServer);
    }

    @Test
    default public void webPushShouldNotPushToPushServerWhenDeletedSubscription(GuiceJamesServer server, ClientAndServer pushServer) {
        AtomicReference<String> bodyRequestOnPushServer = this.setupPushServerCallback(pushServer);
        String pushSubscriptionId = this.createPushSubscription(pushServer);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> pushServer.verify((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withBody((Body)JsonBody.json((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(172).append("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"").append(pushSubscriptionId).append("\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}").toString())))), VerificationTimes.atLeast((int)1)));
        String verificationCode = ((JsString)((JsObject)Json$.MODULE$.parse(bodyRequestOnPushServer.get())).value().apply((Object)"verificationCode")).value();
        String updateVerificationCodeResponse = this.updateValidateVerificationCode(pushSubscriptionId, verificationCode);
        JsonAssertions.assertThatJson((Object)updateVerificationCodeResponse).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(390).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"").append(pushSubscriptionId).append("\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
        PushSubscriptionProbe pushSubscriptionProbe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(318).append("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"destroy\": [\"").append(pushSubscriptionId).append("\"]\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }").toString()))).when().post()).then().statusCode(200);
        this.sendEmailToBob(server);
        TimeUnit.MILLISECONDS.sleep(200L);
        pushServer.verify((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withBody((Body)JsonBody.json((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(209).append("{\n           |    \"@type\": \"StateChange\",\n           |    \"changed\": {\n           |        \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\": {\n           |          \"Mailbox\": \"${json-unit.any-string}\"\n           |        }\n           |    }\n           |}").toString())))), VerificationTimes.exactly((int)0));
    }

    public static /* synthetic */ void webPushShouldNotPushToPushServerWhenNotValidatedCode$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.webPushShouldNotPushToPushServerWhenNotValidatedCode(server, pushServer);
    }

    @Test
    default public void webPushShouldNotPushToPushServerWhenNotValidatedCode(GuiceJamesServer server, ClientAndServer pushServer) {
        this.setupPushServerCallback(pushServer);
        this.createPushSubscription(pushServer);
        this.sendEmailToBob(server);
        TimeUnit.MILLISECONDS.sleep(200L);
        pushServer.verify((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withBody((Body)JsonBody.json((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(209).append("{\n           |    \"@type\": \"StateChange\",\n           |    \"changed\": {\n           |        \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\": {\n           |          \"Mailbox\": \"${json-unit.any-string}\"\n           |        }\n           |    }\n           |}").toString())))), VerificationTimes.exactly((int)0));
    }

    public static /* synthetic */ void correctBehaviourShouldSuccessWhenEncryptionKeys$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.correctBehaviourShouldSuccessWhenEncryptionKeys(server, pushServer);
    }

    @Test
    default public void correctBehaviourShouldSuccessWhenEncryptionKeys(GuiceJamesServer server, ClientAndServer pushServer) {
        AtomicReference bodyRequestOnPushServer = new AtomicReference();
        pushServer.when((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withMethod("POST")).respond(new ExpectationResponseCallback(null, bodyRequestOnPushServer){
            private final AtomicReference bodyRequestOnPushServer$2;

            public HttpResponse handle(HttpRequest httpRequest) {
                this.bodyRequestOnPushServer$2.set(httpRequest.getBodyAsRawBytes());
                return HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(201));
            }
            {
                this.bodyRequestOnPushServer$2 = bodyRequestOnPushServer$2;
            }
        });
        KeyPair uaKeyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256);
        ECPublicKey uaPublicKey = (ECPublicKey)uaKeyPair.getPublic();
        ECPrivateKey uaPrivateKey = (ECPrivateKey)uaKeyPair.getPrivate();
        byte[] authSecret = "secret123secret1".getBytes();
        String p256dh = Base64.getUrlEncoder().encodeToString(uaPublicKey.getEncoded());
        String auth = Base64.getUrlEncoder().encodeToString(authSecret);
        String pushSubscriptionId = (String)((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(729).append("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"a889-ffea-910\",\n           |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n           |                  \"types\": [\"Mailbox\"],\n           |                  \"keys\": {\n           |                    \"p256dh\": \"").append(p256dh).append("\",\n           |                    \"auth\": \"").append(auth).append("\"\n           |                  }\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }").toString()))).when().post()).then().statusCode(200).extract().jsonPath().get("methodResponses[0][1].created.4f29.id");
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> pushServer.verify((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withBody((Body)Not.not((Not)JsonBody.json((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(172).append("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"").append(pushSubscriptionId).append("\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}").toString()))))), VerificationTimes.atLeast((int)1)));
        WebPushHybridDecrypt hybridDecrypt = new WebPushHybridDecrypt.Builder().withAuthSecret(authSecret).withRecipientPublicKey(uaPublicKey).withRecipientPrivateKey(uaPrivateKey).build();
        String decryptBodyRequestOnPushServer = new String(hybridDecrypt.decrypt((byte[])bodyRequestOnPushServer.get(), null), StandardCharsets.UTF_8);
        String verificationCode = ((JsString)((JsObject)Json$.MODULE$.parse(decryptBodyRequestOnPushServer)).value().apply((Object)"verificationCode")).value();
        this.updateValidateVerificationCode(pushSubscriptionId, verificationCode);
        this.sendEmailToBob(server);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> pushServer.verify((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()), VerificationTimes.atLeast((int)1)));
        JsonAssertions.assertThatJson((Object)new String(hybridDecrypt.decrypt((byte[])bodyRequestOnPushServer.get(), null), StandardCharsets.UTF_8)).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(205).append("{\n           |    \"@type\": \"StateChange\",\n           |    \"changed\": {\n           |        \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\": {\n           |          \"Mailbox\": \"${json-unit.ignore}\"\n           |        }\n           |    }\n           |}").toString())));
    }

    public static void $init$(WebPushContract $this) {
    }
}

