/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.UploadContract$;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005};Qa\u0004\t\t\u0002u1Qa\b\t\t\u0002\u0001BQaJ\u0001\u0005\u0002!Bq!K\u0001C\u0002\u0013%!\u0006\u0003\u00042\u0003\u0001\u0006Ia\u000b\u0005\be\u0005\u0011\r\u0011\"\u0003+\u0011\u0019\u0019\u0014\u0001)A\u0005W\u00199q\u0004\u0005I\u0001\u0004\u0003!\u0004\"B\u001b\b\t\u00031\u0004\"\u0002\u001e\b\t\u0003Y\u0004\"B'\b\t\u00031\u0004\"\u0002+\b\t\u00031\u0004\"B-\b\t\u00031\u0004\"B.\b\t\u00031\u0004\"B/\b\t\u00031\u0014AD+qY>\fGmQ8oiJ\f7\r\u001e\u0006\u0003#I\t\u0001bY8oiJ\f7\r\u001e\u0006\u0003'Q\tqA\u001d4dqY\u0012\u0014G\u0003\u0002\u0016-\u0005!!.\\1q\u0015\t9\u0002$A\u0003kC6,7O\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001\u0001\t\u0003=\u0005i\u0011\u0001\u0005\u0002\u000f+Bdw.\u00193D_:$(/Y2u'\t\t\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\t\u0011BQ%H?&s\u0005+\u0016+\u0016\u0003-\u00022A\t\u0017/\u0013\ti3EA\u0003BeJ\f\u0017\u0010\u0005\u0002#_%\u0011\u0001g\t\u0002\u0005\u0005f$X-\u0001\u0006C\u0013\u001e{\u0016J\u0014)V)\u0002\n1BV!M\u0013\u0012{\u0016J\u0014)V)\u0006aa+\u0011'J\t~Ke\nU+UAM\u0011q!I\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003]\u0002\"A\t\u001d\n\u0005e\u001a#\u0001B+oSR\fQa]3u+B$\"a\u000e\u001f\t\u000buJ\u0001\u0019\u0001 \u0002\rM,'O^3s!\ty\u0004)D\u0001\u0017\u0013\t\teC\u0001\tHk&\u001cWMS1nKN\u001cVM\u001d<fe\"\u0012\u0011b\u0011\t\u0003\t.k\u0011!\u0012\u0006\u0003\r\u001e\u000b1!\u00199j\u0015\tA\u0015*A\u0004kkBLG/\u001a:\u000b\u0005)S\u0012!\u00026v]&$\u0018B\u0001'F\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001%g\"|W\u000f\u001c3Va2|\u0017\r\u001a$jY\u0016\fe\u000eZ!mY><Hk\u001c#po:dw.\u00193Ji\"\"!b\u0014*T!\t!\u0005+\u0003\u0002R\u000b\na!+\u001a9fCR,G\rV3ti\u0006)a/\u00197vKv\t!'A\u0016c_\n\u001c\u0006n\\;mI:{GOQ3BY2|w/\u001a3U_V\u0003Hn\\1e\u0013:\fE.[2f\u0003\u000e\u001cw.\u001e8uQ\tYa\u000b\u0005\u0002E/&\u0011\u0001,\u0012\u0002\u0005)\u0016\u001cH/A\u0018bY&\u001cWm\u00155pk2$gj\u001c;BG\u000e,7o](s\t><h\u000e\\8bI\u001aKG.Z+qY>\fG-\u001a3Cs\n{'\r\u000b\u0002\r-\u0006\u00013\u000f[8vY\u0012\u0014VM[3di^CWM\\+qY>\fGMR5mKR{wNQ5hQ\tia+A\u0013va2|\u0017\rZ*i_VdGMU3kK\u000e$x\u000b[3o+:\fW\u000f\u001e5f]RL7-\u0019;fI\"\u0012aB\u0016")
public interface UploadContract {
    public static /* synthetic */ void setUp$(UploadContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addDomain(Fixture$.MODULE$._2_DOT_DOMAIN().asString()).addUser(Fixture$.MODULE$.ALICE().asString(), Fixture$.MODULE$.ALICE_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void shouldUploadFileAndAllowToDownloadIt$(UploadContract $this) {
        $this.shouldUploadFileAndAllowToDownloadIt();
    }

    @RepeatedTest(value=50)
    default public void shouldUploadFileAndAllowToDownloadIt() {
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT()).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        byte[] downloadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(11).append("/download/").append(Fixture$.MODULE$.ACCOUNT_ID()).append("/").append(blobId).toString(), new Object[0])).then().statusCode(200).contentType("application/json").extract().body().asByteArray();
        Assertions.assertThat((InputStream)new ByteArrayInputStream(downloadResponse)).hasBinaryContent(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT());
    }

    public static /* synthetic */ void bobShouldNotBeAllowedToUploadInAliceAccount$(UploadContract $this) {
        $this.bobShouldNotBeAllowedToUploadInAliceAccount();
    }

    @Test
    default public void bobShouldNotBeAllowedToUploadInAliceAccount() {
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT()).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ALICE_ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(403).header("Content-Length", "84").body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)403)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"Upload to other accounts is forbidden"), new Object[0]);
    }

    public static /* synthetic */ void aliceShouldNotAccessOrDownloadFileUploadedByBob$(UploadContract $this) {
        $this.aliceShouldNotAccessOrDownloadFileUploadedByBob();
    }

    @Test
    default public void aliceShouldNotAccessOrDownloadFileUploadedByBob() {
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT()).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        ((Validatable)RestAssured.given().auth().basic(Fixture$.MODULE$.ALICE().asString(), Fixture$.MODULE$.ALICE_PASSWORD()).basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(11).append("/download/").append(Fixture$.MODULE$.ALICE_ACCOUNT_ID()).append("/").append(blobId).toString(), new Object[0])).then().statusCode(403).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)403)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"You cannot download in others accounts"), new Object[0]);
    }

    public static /* synthetic */ void shouldRejectWhenUploadFileTooBig$(UploadContract $this) {
        $this.shouldRejectWhenUploadFileTooBig();
    }

    @Test
    default public void shouldRejectWhenUploadFileTooBig() {
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).contentType(ContentType.BINARY).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$BIG_INPUT()).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(400).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)400)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"Attempt to upload exceed max size"), new Object[0]);
    }

    public static /* synthetic */ void uploadShouldRejectWhenUnauthenticated$(UploadContract $this) {
        $this.uploadShouldRejectWhenUnauthenticated();
    }

    @Test
    default public void uploadShouldRejectWhenUnauthenticated() {
        ((Validatable)RestAssured.given().auth().none().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).contentType(ContentType.BINARY).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT()).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(401).header("WWW-Authenticate", "Basic realm=\"simple\", Bearer realm=\"JWT\"").body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"No valid authentication methods provided"), new Object[0]);
    }

    public static void $init$(UploadContract $this) {
    }
}

