/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.draft.JmapGuiceProbe;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.SessionRoutesContract$;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0001<Q!\u0004\b\t\u0002m1Q!\b\b\t\u0002yAQ!J\u0001\u0005\u0002\u0019BqaJ\u0001C\u0002\u0013%\u0001\u0006\u0003\u00045\u0003\u0001\u0006I!\u000b\u0005\bk\u0005\u0011\r\u0011\"\u0003)\u0011\u00191\u0014\u0001)A\u0005S\u00199QD\u0004I\u0001\u0004\u00039\u0004\"\u0002\u001d\b\t\u0003I\u0004\"B\u001f\b\t\u0003q\u0004\"\u0002)\b\t\u0003I\u0004\"\u0002/\b\t\u0003I\u0004\"\u00020\b\t\u0003I\u0014!F*fgNLwN\u001c*pkR,7oQ8oiJ\f7\r\u001e\u0006\u0003\u001fA\t\u0001bY8oiJ\f7\r\u001e\u0006\u0003#I\tqA\u001d4dqY\u0012\u0014G\u0003\u0002\u0014)\u0005!!.\\1q\u0015\t)b#A\u0003kC6,7O\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001\u0001\t\u00039\u0005i\u0011A\u0004\u0002\u0016'\u0016\u001c8/[8o%>,H/Z:D_:$(/Y2u'\t\tq\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\tq#\u001a=qK\u000e$X\rZ0tKN\u001c\u0018n\u001c8`_\nTWm\u0019;\u0016\u0003%\u0002\"AK\u0019\u000f\u0005-z\u0003C\u0001\u0017\"\u001b\u0005i#B\u0001\u0018\u001b\u0003\u0019a$o\\8u}%\u0011\u0001'I\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021C\u0005AR\r\u001f9fGR,GmX:fgNLwN\\0pE*,7\r\u001e\u0011\u0002%\u0015C\u0006+R\"U\u000b\u0012{&)Q*F?B\u000bE\u000bS\u0001\u0014\u000bb\u0003Vi\u0011+F\t~\u0013\u0015iU#`!\u0006#\u0006\nI\n\u0003\u000f}\ta\u0001J5oSR$C#\u0001\u001e\u0011\u0005\u0001Z\u0014B\u0001\u001f\"\u0005\u0011)f.\u001b;\u0002\u000bM,G/\u00169\u0015\u0005iz\u0004\"\u0002!\n\u0001\u0004\t\u0015AB:feZ,'\u000f\u0005\u0002C\u00076\tA#\u0003\u0002E)\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\u0013\u0019\u0003\"a\u0012(\u000e\u0003!S!!\u0013&\u0002\u0007\u0005\u0004\u0018N\u0003\u0002L\u0019\u00069!.\u001e9ji\u0016\u0014(BA'\u0019\u0003\u0015QWO\\5u\u0013\ty\u0005J\u0001\u0006CK\u001a|'/Z#bG\"\fQdZ3u'\"|W\u000f\u001c3SKR,(O\\\"peJ,7\r^*fgNLwN\u001c\u0015\u0005\u0015I+f\u000b\u0005\u0002H'&\u0011A\u000b\u0013\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017%A,\u0002\u0019\t\u000b7/[2GK\u0006$XO]3)\u0005)I\u0006CA$[\u0013\tY\u0006J\u0001\u0003UKN$\u0018aW4fiJ+7\u000f]8og\u0016\u001c\u0006n\\;mIJ+G/\u001e:o+JdWI\u001c3q_&tGoQ8oi\u0006LgNS7baB\u0013XMZ5y/\",g.Q:tS\u001et\u0007*Z1eKJ\fe\u000eZ\"p]\u001aLw-\u001e:bi&|g\u000e\u0015:pm&$W\r\u001a\u0015\u0003\u0017e\u000bQjZ3u%\u0016\u001c\bo\u001c8tKNCw.\u001e7e%\u0016$XO\u001d8Ve2,e\u000e\u001a9pS:$hj\u0014+D_:$\u0018-\u001b8K[\u0006\u0004\bK]3gSb<\u0006.\u001a8BgNLwM\\%om\u0006d\u0017\u000e\u001a%fC\u0012,'\u000f\u000b\u0002\r3\u0002")
public interface SessionRoutesContract {
    public static /* synthetic */ void setUp$(SessionRoutesContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        JmapGuiceProbe jmapGuiceProbe = (JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class);
        RestAssured.requestSpecification = new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).setPort(jmapGuiceProbe.getJmapPort().getValue()).setBasePath(SessionRoutesContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$SessionRoutesContract$$EXPECTED_BASE_PATH()).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void getShouldReturnCorrectSession$(SessionRoutesContract $this) {
        $this.getShouldReturnCorrectSession();
    }

    @Test
    @Tag(value="BasicFeature")
    default public void getShouldReturnCorrectSession() {
        String sessionJson = ((Validatable)RestAssured.given().when().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).get("/session", new Object[0])).then().statusCode(200).header("Content-Length", "3025").contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)sessionJson).isEqualTo((Object)SessionRoutesContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$SessionRoutesContract$$expected_session_object());
    }

    public static /* synthetic */ void getResponseShouldReturnUrlEndpointContainJmapPrefixWhenAssignHeaderAndConfigurationProvided$(SessionRoutesContract $this) {
        $this.getResponseShouldReturnUrlEndpointContainJmapPrefixWhenAssignHeaderAndConfigurationProvided();
    }

    @Test
    default public void getResponseShouldReturnUrlEndpointContainJmapPrefixWhenAssignHeaderAndConfigurationProvided() {
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).header("X-JMAP-PREFIX", (Object)"http://new-domain.tld/prefix", new Object[0]).header("X-JMAP-WEBSOCKET-PREFIX", (Object)"ws://new-domain.tld/prefix", new Object[0]).when().get("/session", new Object[0])).then().statusCode(200).contentType(ContentType.JSON).body("apiUrl", Matchers.is((Object)"http://new-domain.tld/prefix/jmap"), new Object[0]).body("downloadUrl", Matchers.is((Object)"http://new-domain.tld/prefix/download/{accountId}/{blobId}?type={type}&name={name}"), new Object[0]).body("uploadUrl", Matchers.is((Object)"http://new-domain.tld/prefix/upload/{accountId}"), new Object[0]).body("eventSourceUrl", Matchers.is((Object)"http://new-domain.tld/prefix/eventSource?types={types}&closeAfter={closeafter}&ping={ping}"), new Object[0]).body("capabilities.\"urn:ietf:params:jmap:websocket\".url", Matchers.is((Object)"ws://new-domain.tld/prefix/jmap/ws"), new Object[0]);
    }

    public static /* synthetic */ void getResponseShouldReturnUrlEndpointNOTContainJmapPrefixWhenAssignInvalidHeader$(SessionRoutesContract $this) {
        $this.getResponseShouldReturnUrlEndpointNOTContainJmapPrefixWhenAssignInvalidHeader();
    }

    @Test
    default public void getResponseShouldReturnUrlEndpointNOTContainJmapPrefixWhenAssignInvalidHeader() {
        String sessionJson = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).header("X-JMAP-PREFIX", (Object)"new@domain", new Object[0]).when().get("/session", new Object[0])).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)sessionJson).isEqualTo((Object)SessionRoutesContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$SessionRoutesContract$$expected_session_object());
    }

    public static void $init$(SessionRoutesContract $this) {
    }
}

