/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Random;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.net.URL;
import java.security.KeyPair;
import java.security.interfaces.ECPublicKey;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.UUID;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionServerURL;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.change.EmailDeliveryTypeName$;
import org.apache.james.jmap.change.EmailTypeName$;
import org.apache.james.jmap.change.MailboxTypeName$;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.PushSubscriptionProbe;
import org.apache.james.jmap.rfc8621.contract.PushSubscriptionSetMethodContract$;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.model.Body;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.RequestDefinition;
import org.mockserver.verify.VerificationTimes;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\tUs!B\u001c9\u0011\u0003)e!B$9\u0011\u0003A\u0005\"B(\u0002\t\u0003\u0001\u0006bB)\u0002\u0005\u0004%\tA\u0015\u0005\u0007;\u0006\u0001\u000b\u0011B*\u0007\u000f\u001dC\u0004\u0013aA\u0001=\")q,\u0002C\u0001A\")A-\u0002C\u0001K\"9\u00111A\u0003\u0005\n\u0005\u0015\u0001BBA\u0010\u000b\u0011\u0005\u0001\r\u0003\u0004\u0002*\u0015!\t\u0001\u0019\u0005\b\u0003[)A\u0011AA\u0018\u0011\u001d\t)$\u0002C\u0001\u0003oAq!!\u0010\u0006\t\u0003\ty\u0004C\u0004\u0002F\u0015!\t!a\u0012\t\r\u00055S\u0001\"\u0001a\u0011\u0019\t\t&\u0002C\u0001A\"1\u0011QK\u0003\u0005\u0002\u0001Dq!!\u0017\u0006\t\u0003\tY\u0006C\u0004\u0002b\u0015!\t!a\u0019\t\u000f\u0005%T\u0001\"\u0001\u0002l!9\u0011\u0011O\u0003\u0005\u0002\u0005M\u0004BBA=\u000b\u0011\u0005\u0001\rC\u0004\u0002~\u0015!\t!a \t\r\u0005\u0015U\u0001\"\u0001a\u0011\u0019\tI)\u0002C\u0001A\"1\u0011QR\u0003\u0005\u0002\u0001Da!!%\u0006\t\u0003\u0001\u0007BBAK\u000b\u0011\u0005\u0001\rC\u0004\u0002\u001a\u0016!\t!a'\t\u000f\u0005\u0005V\u0001\"\u0001\u0002$\"9\u0011\u0011V\u0003\u0005\u0002\u0005-\u0006bBAY\u000b\u0011\u0005\u00111\u0017\u0005\b\u0003s+A\u0011AA^\u0011\u001d\t\t-\u0002C\u0001\u0003\u0007Da!!3\u0006\t\u0003\u0001\u0007bBAg\u000b\u0011\u0005\u0011q\u001a\u0005\b\u0003+,A\u0011AAl\u0011\u001d\ti.\u0002C\u0001\u0003?Dq!!:\u0006\t\u0003\t9\u000fC\u0004\u0002n\u0016!\t!a<\t\u000f\u0005UX\u0001\"\u0001\u0002x\"9\u0011Q`\u0003\u0005\u0002\u0005}\bb\u0002B\u0003\u000b\u0011\u0005!q\u0001\u0005\u0007\u0005\u001b)A\u0011\u00011\t\r\tEQ\u0001\"\u0001a\u0011\u001d\u0011)\"\u0002C\u0001\u0005/AqA!\b\u0006\t\u0003\u0011y\u0002C\u0004\u0003&\u0015!\tAa\n\t\u000f\t5R\u0001\"\u0001\u00030!9!QG\u0003\u0005\u0002\t]\u0002b\u0002B\u001f\u000b\u0011\u0005!q\b\u0005\u0007\u0005\u000b*A\u0011\u00011\t\r\t%S\u0001\"\u0001a\u0011\u001d\u0011i%\u0002C\u0001\u0005\u001f\n\u0011\u0005U;tQN+(m]2sSB$\u0018n\u001c8TKRlU\r\u001e5pI\u000e{g\u000e\u001e:bGRT!!\u000f\u001e\u0002\u0011\r|g\u000e\u001e:bGRT!a\u000f\u001f\u0002\u000fI47\r\u000f\u001c3c)\u0011QHP\u0001\u0005U6\f\u0007O\u0003\u0002@\u0001\u0006)!.Y7fg*\u0011\u0011IQ\u0001\u0007CB\f7\r[3\u000b\u0003\r\u000b1a\u001c:h\u0007\u0001\u0001\"AR\u0001\u000e\u0003a\u0012\u0011\u0005U;tQN+(m]2sSB$\u0018n\u001c8TKRlU\r\u001e5pI\u000e{g\u000e\u001e:bGR\u001c\"!A%\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ)\u0001\bU\u00136+uLR(S\u001b\u0006#F+\u0012*\u0016\u0003M\u0003\"\u0001V.\u000e\u0003US!AV,\u0002\r\u0019|'/\\1u\u0015\tA\u0016,\u0001\u0003uS6,'\"\u0001.\u0002\t)\fg/Y\u0005\u00039V\u0013\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0003=!\u0016*T#`\r>\u0013V*\u0011+U\u000bJ\u00033CA\u0003J\u0003\u0019!\u0013N\\5uIQ\t\u0011\r\u0005\u0002KE&\u00111m\u0013\u0002\u0005+:LG/A\u0003tKR,\u0006\u000fF\u0002bM2DQaZ\u0004A\u0002!\faa]3sm\u0016\u0014\bCA5k\u001b\u0005q\u0014BA6?\u0005A9U/[2f\u0015\u0006lWm]*feZ,'\u000fC\u0003n\u000f\u0001\u0007a.\u0001\u0006qkND7+\u001a:wKJ\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\u0017%tG/Z4sCRLwN\u001c\u0006\u0003g\n\u000b!\"\\8dWN,'O^3s\u0013\t)\bOA\bDY&,g\u000e^!oIN+'O^3sQ\t9q\u000f\u0005\u0002y\u007f6\t\u0011P\u0003\u0002{w\u0006\u0019\u0011\r]5\u000b\u0005ql\u0018a\u00026va&$XM\u001d\u0006\u0003}\n\u000bQA[;oSRL1!!\u0001z\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0011O\u0016$\b+^:i'\u0016\u0014h/\u001a:Ve2$B!a\u0002\u0002\u001eA!\u0011\u0011BA\f\u001d\u0011\tY!a\u0005\u0011\u0007\u000551*\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003#\u0002\rq\u0012xn\u001c;?\u0013\r\t)bS\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00111\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U1\nC\u0003n\u0011\u0001\u0007a.\u0001\u0012tKRlU\r\u001e5pINCw.\u001e7e\u001d>$(+Z9vSJ,\u0017iY2pk:$\u0018\n\u001a\u0015\u0004\u0013\u0005\r\u0002c\u0001=\u0002&%\u0019\u0011qE=\u0003\tQ+7\u000f^\u0001)g\u0016$X*\u001a;i_\u0012\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\\,iK:l\u0015n]:j]\u001e\u001c\u0015\r]1cS2LG/\u001f\u0015\u0004\u0015\u0005\r\u0012aF;qI\u0006$Xm\u00155pk2$Wj\u001c3jMf$\u0016\u0010]3t)\r\t\u0017\u0011\u0007\u0005\u0006O.\u0001\r\u0001\u001b\u0015\u0004\u0017\u0005\r\u0012AH;qI\u0006$Xm\u00155pk2$'+\u001a6fGR,fn\u001b8po:$\u0016\u0010]3t)\r\t\u0017\u0011\b\u0005\u0006O2\u0001\r\u0001\u001b\u0015\u0004\u0019\u0005\r\u0012AG;qI\u0006$Xm\u00155pk2$'+\u001a6fGR\u0014\u0015\r\u001a+za\u0016\u001cHcA1\u0002B!)q-\u0004a\u0001Q\"\u001aQ\"a\t\u00023U\u0004H-\u0019;f'\"|W\u000f\u001c3SK*,7\r\u001e\"bIRK\b/\u001a\u000b\u0004C\u0006%\u0003\"B4\u000f\u0001\u0004A\u0007f\u0001\b\u0002$\u0005\u00115/\u001a;NKRDw\u000eZ*i_VdGMT8u\u0007J,\u0017\r^3e/\",g.T5tg&tw\rV=qKN\u0004&o\u001c9feRL\u0018J\\\"sK\u0006$\u0018n\u001c8SKF,Xm\u001d;)\u0007=\t\u0019#A\u0019tKRlU\r\u001e5pINCw.\u001e7e\u001d>$8I]3bi\u0016$w\u000b[3o)f\u0004Xm\u001d)s_B,'\u000f^=Jg\u0016k\u0007\u000f^=)\u0007A\t\u0019#\u0001\u000fhKR\u001c\u0006n\\;mIJ+G/\u001e:o\u000b6\u0004H/_,iK:tuN\\3)\u0007E\t\u0019#A\rhKR\u001c\u0006n\\;mIJ+G/\u001e:o\u00032d'+Z2pe\u0012\u001cHcA1\u0002^!)qM\u0005a\u0001Q\"\u001a!#a\t\u0002Q\u001d,Go\u00155pk2$'+\u001a;ve:4\u0016\r\\5eCR,GMV3sS\u001aL7-\u0019;j_:\u001cu\u000eZ3\u0015\u0007\u0005\f)\u0007C\u0003h'\u0001\u0007\u0001\u000eK\u0002\u0014\u0003G\t!dZ3u\u0005fLEm\u00155pk2$'+\u001a;ve:\u0014VmY8sIN$2!YA7\u0011\u00159G\u00031\u0001iQ\r!\u00121E\u0001\"O\u0016$()_%e'\"|W\u000f\u001c3SKR,(O\\#naRLx\u000b[3o\u000b6\u0004H/\u001f\u000b\u0004C\u0006U\u0004\"B4\u0016\u0001\u0004A\u0007fA\u000b\u0002$\u0005Yr-\u001a;Cs&#7\u000b[8vY\u0012\u0014V\r^;s]:{GOR8v]\u0012D3AFA\u0012\u0003e9W\r^*i_VdGMR5mi\u0016\u0014\bK]8qKJ$\u0018.Z:\u0015\u0007\u0005\f\t\tC\u0003h/\u0001\u0007\u0001\u000eK\u0002\u0018\u0003G\tqf]3u\u001b\u0016$\bn\u001c3TQ>,H\u000e\u001a(pi\u000e\u0013X-\u0019;fI^CWM\\%om\u0006d\u0017\u000eZ+S\u0019B\u0013x\u000e]3sifD3\u0001GA\u0012\u0003\u001d\u001bX\r^'fi\"|Gm\u00155pk2$gj\u001c;De\u0016\fG/\u001a3XQ\u0016t7I]3bi&|gNU3rk\u0016\u001cH\u000fS1t-\u0016\u0014\u0018NZ5dCRLwN\\\"pI\u0016\u0004&o\u001c9feRL\bfA\r\u0002$\u0005I4/\u001a;NKRDw\u000eZ*i_VdGMT8u\u0007J,\u0017\r^3e/\",gn\u0011:fCRLwN\u001c*fcV,7\u000f\u001e%bg&#\u0007K]8qKJ$\u0018\u0010K\u0002\u001b\u0003G\t1g]3u\u001b\u0016$\bn\u001c3TQ>,H\u000e\u001a(pi\u000e\u0013X-\u0019;fI^CWM\\%o-\u0006d\u0017\u000eZ#ya&\u0014Xm\u001d)s_B,'\u000f^=)\u0007m\t\u0019#A\u0019tKRlU\r\u001e5pINCw.\u001e7e\u001d>$8I]3bi\u0016$w\u000b[3o\u0013:4\u0016\r\\5e)f\u0004Xm\u001d)s_B,'\u000f^=)\u0007q\t\u0019#A\u0019tKRlU\r\u001e5pINCw.\u001e7e\u001d>$8I]3bi\u0016$w\u000b[3o\t\u00164\u0018nY3DY&,g\u000e^%e\u000bbL7\u000f^:\u0015\u0007\u0005\fi\nC\u0003n;\u0001\u0007a\u000eK\u0002\u001e\u0003G\t\u0011f]3u\u001b\u0016$\bn\u001c3TQ>,H\u000eZ!dG\u0016\u0004HOV1mS\u0012,\u0005\u0010]5sKN\u0004&o\u001c9feRLHcA1\u0002&\")QN\ba\u0001]\"\u001aa$a\t\u0002MM,G/T3uQ>$7\u000b[8vY\u0012\u001c%/Z1uK\u0012<\u0006.\u001a8WC2LGMU3rk\u0016\u001cH\u000fF\u0002b\u0003[CQ!\\\u0010A\u00029D3aHA\u0012\u0003E\u001aX\r^'fi\"|Gm\u00155pk2$7I]3bi\u0016$7+\u001a<fe\u0006dg+\u00197jI\u000e\u0013X-\u0019;j_:\u0014V-];fgR$2!YA[\u0011\u0015i\u0007\u00051\u0001oQ\r\u0001\u00131E\u0001\"g\u0016$X*\u001a;i_\u0012\u001c\u0006n\\;mIN+8mY3tg^CWM\\'jq\u000e\u000b7/\u001a\u000b\u0004C\u0006u\u0006\"B7\"\u0001\u0004q\u0007fA\u0011\u0002$\u0005!S\u000f\u001d3bi\u0016\u001c\u0006n\\;mIZ\u000bG.\u001b3bi\u00164VM]5gS\u000e\fG/[8o\u0007>$W\rF\u0002b\u0003\u000bDQa\u001a\u0012A\u0002!D3AIA\u0012\u0003}\u0019X\r^'fi\"|Gm\u00155pk2$'+\u001a6fGRLeN^1mS\u0012\\U-\u001f\u0015\u0004G\u0005\r\u0012!H:fi6+G\u000f[8e'\"|W\u000f\u001c3BG\u000e,\u0007\u000f\u001e,bY&$7*Z=\u0015\u0007\u0005\f\t\u000eC\u0003nI\u0001\u0007a\u000eK\u0002%\u0003G\t1\"\u001e9eCR,W*\u001b=fIR\u0019\u0011-!7\t\u000b\u001d,\u0003\u0019\u00015)\u0007\u0015\n\u0019#\u0001\u0019va\u0012\fG/Z*i_VdGMT8u-\u0006d\u0017\u000eZ1uKZ+'/\u001b4jG\u0006$\u0018n\u001c8D_\u0012,w\u000b[3o/J|gn\u001a\u000b\u0004C\u0006\u0005\b\"B4'\u0001\u0004A\u0007f\u0001\u0014\u0002$\u0005yR\u000f\u001d3bi\u00164\u0016\r\\5e\u000bb\u0004\u0018N]3t'\"|W\u000f\u001c3Tk\u000e\u001cW-\u001a3\u0015\u0007\u0005\fI\u000fC\u0003hO\u0001\u0007\u0001\u000eK\u0002(\u0003G\tA%\u001e9eCR,\u0017J\u001c<bY&$W\t\u001f9je\u0016\u001c8\u000b\u001e:j]\u001e\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\u001c\u000b\u0004C\u0006E\b\"B4)\u0001\u0004A\u0007f\u0001\u0015\u0002$\u0005\tV\u000f\u001d3bi\u0016<\u0016\u000e\u001e5CS\u001e<WM]#ya&\u0014Xm\u001d+iC:\u001cVM\u001d<fe2KW.\u001b;TQ>,H\u000eZ*fiR{7+\u001a:wKJd\u0015.\\5u\u0003:$W\t\u001f9mS\u000eLG\u000f\\=SKR,(O\\3e)\r\t\u0017\u0011 \u0005\u0006O&\u0002\r\u0001\u001b\u0015\u0004S\u0005\r\u0012aH;qI\u0006$XmT;uI\u0006$X\rZ#ya&\u0014Xm]*i_VdGMR1jYR\u0019\u0011M!\u0001\t\u000b\u001dT\u0003\u0019\u00015)\u0007)\n\u0019#A\u0012va\u0012\fG/Z*i_VdGMR1jY^CWM\\+oW:|wO\u001c)s_B,'\u000f^=\u0015\u0007\u0005\u0014I\u0001C\u0003hW\u0001\u0007\u0001\u000eK\u0002,\u0003G\tQ$\u001e9eCR,7\u000b[8vY\u00124\u0015-\u001b7XQ\u0016t\u0017J\u001c<bY&$\u0017\n\u001a\u0015\u0004Y\u0005\r\u0012\u0001H;qI\u0006$Xm\u00155pk2$g)Y5m/\",gNT8u\r>,h\u000e\u001a\u0015\u0004[\u0005\r\u0012!M:fi6+G\u000f[8e\u0007J,\u0017\r^3TQ>,H\u000eZ\"bY24VM]5gS\u000e\fG/[8o)>\u0004Vo\u001d5TKJ4XM\u001d\u000b\u0004C\ne\u0001\"B7/\u0001\u0004q\u0007f\u0001\u0018\u0002$\u000595/\u001a;NKRDw\u000eZ\"sK\u0006$Xm\u00155pk2$gj\u001c;De\u0016\fG/\u001a3XQ\u0016t7)\u00197m-\u0016\u0014\u0018NZ5dCRLwN\u001c+p!V\u001c\bnU3sm\u0016\u0014\b*Y:FeJ|'\u000fF\u0002b\u0005CAQ!\\\u0018A\u00029D3aLA\u0012\u0003U\u001bX\r^'fi\"|Gm\u0011:fCR,7\u000b[8vY\u0012tu\u000e^*bm\u0016\u001cVOY:de&\u0004H/[8o\u000b:$(/_,iK:\u001c\u0015\r\u001c7WKJLg-[2bi&|g\u000eV8QkND7+\u001a:wKJD\u0015m]#se>\u0014HcA1\u0003*!)Q\u000e\ra\u0001]\"\u001a\u0001'a\t\u0002=M,G/T3uQ>$7\u000b[8vY\u0012\f5mY3qiZ\u000bG.\u001b3LKf\u001cHcA1\u00032!)Q.\ra\u0001]\"\u001a\u0011'a\t\u0002\r\n|G-\u001f*fcV,7\u000f\u001e+p!V\u001c\bnU3sm\u0016\u00148\u000b[8vY\u0012\u0014U-\u00128def\u0004H/\u001a3XQ\u0016t7\t\\5f]R\f5o]5h]\u0016s7M]=qi&|gnS3zgR\u0019\u0011M!\u000f\t\u000b5\u0014\u0004\u0019\u00018)\u0007I\n\u0019#\u0001\u000beKN$(o\\=TQ>,H\u000eZ*vG\u000e,W\r\u001a\u000b\u0004C\n\u0005\u0003\"B44\u0001\u0004A\u0007fA\u001a\u0002$\u0005qB-Z:ue>L8\u000b[8vY\u00124\u0015-\u001b7XQ\u0016t\u0017J\u001c<bY&$\u0017\n\u001a\u0015\u0004i\u0005\r\u0012!\t3fgR\u0014x._*i_VdGMT8u\r\u0006LGn\u00165f]Vs7N\\8x]&#\u0007fA\u001b\u0002$\u0005iB-Z:ue>L8\u000b[8vY\u0012D\u0015M\u001c3mK6K\u00070\u001a3DCN,7\u000fF\u0002b\u0005#BQa\u001a\u001cA\u0002!D3ANA\u0012\u0001")
public interface PushSubscriptionSetMethodContract {
    public static DateTimeFormatter TIME_FORMATTER() {
        return PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER();
    }

    public static /* synthetic */ void setUp$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.setUp(server, pushServer);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server, ClientAndServer pushServer) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
        pushServer.when((RequestDefinition)HttpRequest.request().withPath("/subscribe").withMethod("POST").withHeader(NottableString.string((String)"Content-type"), new NottableString[]{NottableString.string((String)"application/json charset=utf-8")})).respond(HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(201)));
    }

    private String getPushServerUrl(ClientAndServer pushServer) {
        return new StringBuilder(27).append("http://127.0.0.1:").append(pushServer.getLocalPort()).append("/subscribe").toString();
    }

    public static /* synthetic */ void setMethodShouldNotRequireAccountId$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotRequireAccountId();
    }

    @Test
    default public void setMethodShouldNotRequireAccountId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200);
    }

    public static /* synthetic */ void setMethodShouldFailWhenMissingCapability$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldFailWhenMissingCapability();
    }

    @Test
    default public void setMethodShouldFailWhenMissingCapability() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(414).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"unknownMethod\",\n           |                \"description\": \"Missing capability(ies): urn:ietf:params:jmap:core\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void updateShouldModifyTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldModifyTypes(server);
    }

    @Test
    default public void updateShouldModifyTypes(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(436).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"").append(pushSubscription.id().serialise()).append("\": {\n         |                  \"types\": [\"Mailbox\", \"Email\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(390).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"").append(pushSubscription.id().serialise()).append("\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
        Assertions.assertThat((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).types()).asJava()).containsExactlyInAnyOrder((Object[])new TypeName[]{MailboxTypeName$.MODULE$, EmailTypeName$.MODULE$});
    }

    public static /* synthetic */ void updateShouldRejectUnknownTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldRejectUnknownTypes(server);
    }

    @Test
    default public void updateShouldRejectUnknownTypes(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(438).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"").append(pushSubscription.id().serialise()).append("\": {\n         |                  \"types\": [\"Mailbox\", \"Unknown\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(624).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\":{\n           |                    \"").append(pushSubscription.id().serialise()).append("\":{\n           |                        \"type\":\"invalidArguments\",\n           |                        \"description\":\"Unknown typeName Unknown\",\n           |                        \"properties\":[\"types\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void updateShouldRejectBadTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldRejectBadTypes(server);
    }

    @Test
    default public void updateShouldRejectBadTypes(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(418).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"").append(pushSubscription.id().serialise()).append("\": {\n         |                  \"types\": 36\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(649).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\":{\n           |                    \"").append(pushSubscription.id().serialise()).append("\":{\n           |                        \"type\":\"invalidArguments\",\n           |                        \"description\":\"Expecting an array of JSON strings as an argument\",\n           |                        \"properties\":[\"types\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void updateShouldRejectBadType$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldRejectBadType(server);
    }

    @Test
    default public void updateShouldRejectBadType(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(429).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"").append(pushSubscription.id().serialise()).append("\": {\n         |                  \"types\": [\"Email\", 36]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(649).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\":{\n           |                    \"").append(pushSubscription.id().serialise()).append("\":{\n           |                        \"type\":\"invalidArguments\",\n           |                        \"description\":\"Expecting an array of JSON strings as an argument\",\n           |                        \"properties\":[\"types\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenMissingTypesPropertyInCreationRequest$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenMissingTypesPropertyInCreationRequest();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenMissingTypesPropertyInCreationRequest() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(600).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Missing '/types' property in PushSubscription object\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenTypesPropertyIsEmpty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenTypesPropertyIsEmpty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenTypesPropertyIsEmpty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": []\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(571).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"types must not be empty\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void getShouldReturnEmptyWhenNone$(PushSubscriptionSetMethodContract $this) {
        $this.getShouldReturnEmptyWhenNone();
    }

    @Test
    default public void getShouldReturnEmptyWhenNone() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(319).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": []\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void getShouldReturnAllRecords$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getShouldReturnAllRecords(server);
    }

    @Test
    default public void getShouldReturnAllRecords(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(923).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"").append(pushSubscription1.id().serialise()).append("\",\n           |                        \"deviceClientId\": \"12c6d086\",\n           |                        \"expires\": \"").append(new UTCDate(pushSubscription1.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER())).append("\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    },\n           |                    {\n           |                        \"id\": \"").append(pushSubscription2.id().serialise()).append("\",\n           |                        \"deviceClientId\": \"12c6d087\",\n           |                        \"expires\": \"").append(new UTCDate(pushSubscription2.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER())).append("\",\n           |                        \"types\": [\"Email\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void getShouldReturnValidatedVerificationCode$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getShouldReturnValidatedVerificationCode(server);
    }

    @Test
    default public void getShouldReturnValidatedVerificationCode(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        probe.validatePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription1.id());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(696).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"").append(pushSubscription1.id().serialise()).append("\",\n           |                        \"deviceClientId\": \"12c6d086\",\n           |                        \"expires\": \"").append(new UTCDate(pushSubscription1.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER())).append("\",\n           |                        \"verificationCode\": \"").append(pushSubscription1.verificationCode()).append("\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void getByIdShouldReturnRecords$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getByIdShouldReturnRecords(server);
    }

    @Test
    default public void getByIdShouldReturnRecords(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription3 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d088", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(186).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [ [ \"PushSubscription/get\", {\n         |       \"ids\": [\"").append(pushSubscription1.id().serialise()).append("\", \"").append(pushSubscription2.id().serialise()).append("\"]\n         |     }, \"c1\" ] ]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(923).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"").append(pushSubscription1.id().serialise()).append("\",\n           |                        \"deviceClientId\": \"12c6d086\",\n           |                        \"expires\": \"").append(new UTCDate(pushSubscription1.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER())).append("\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    },\n           |                    {\n           |                        \"id\": \"").append(pushSubscription2.id().serialise()).append("\",\n           |                        \"deviceClientId\": \"12c6d087\",\n           |                        \"expires\": \"").append(new UTCDate(pushSubscription2.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER())).append("\",\n           |                        \"types\": [\"Email\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void getByIdShouldReturnEmptyWhenEmpty$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getByIdShouldReturnEmptyWhenEmpty(server);
    }

    @Test
    default public void getByIdShouldReturnEmptyWhenEmpty(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [ [ \"PushSubscription/get\", {\n         |       \"ids\": []\n         |     }, \"c1\" ] ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(319).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": []\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void getByIdShouldReturnNotFound$(PushSubscriptionSetMethodContract $this) {
        $this.getByIdShouldReturnNotFound();
    }

    @Test
    default public void getByIdShouldReturnNotFound() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [ [ \"PushSubscription/get\", {\n         |       \"ids\": [\"notFound\"]\n         |     }, \"c1\" ] ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(373).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"notFound\": [\"notFound\"],\n           |                \"list\": []\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void getShouldFilterProperties$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getShouldFilterProperties(server);
    }

    @Test
    default public void getShouldFilterProperties(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { \"properties\": [\"types\"] }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(689).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"").append(pushSubscription1.id().serialise()).append("\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    },\n           |                    {\n           |                        \"id\": \"").append(pushSubscription2.id().serialise()).append("\",\n           |                        \"types\": [\"Email\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenInvalidURLProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenInvalidURLProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenInvalidURLProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"invalid\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(603).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"'/url' property in PushSubscription object is not valid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenCreationRequestHasVerificationCodeProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenCreationRequestHasVerificationCodeProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenCreationRequestHasVerificationCodeProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"verificationCode\": \"abc\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(739).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Some server-set properties were specified\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenCreationRequestHasIdProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenCreationRequestHasIdProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenCreationRequestHasIdProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"id\": \"abc\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(725).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Some server-set properties were specified\",\n           |                        \"properties\": [\n           |                            \"id\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenInValidExpiresProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenInValidExpiresProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenInValidExpiresProperty() {
        String invalidExpire = new UTCDate(ZonedDateTime.now().minusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(632).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n         |                  \"expires\": \"").append(invalidExpire).append("\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(646).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"`").append(invalidExpire).append("` expires must be greater than now\",\n           |                        \"properties\": [\"expires\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenInValidTypesProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenInValidTypesProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenInValidTypesProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n         |                  \"types\": [\"invalid\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(634).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"'/types(0)' property in PushSubscription object is not valid: Unknown typeName invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenDeviceClientIdExists$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldNotCreatedWhenDeviceClientIdExists(pushServer);
    }

    @Test
    default public void setMethodShouldNotCreatedWhenDeviceClientIdExists(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(516).append("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }").toString()));
        ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200);
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(593).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"`a889-ffea-910` deviceClientId must be unique\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldAcceptValidExpiresProperty$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldAcceptValidExpiresProperty(pushServer);
    }

    @Test
    default public void setMethodShouldAcceptValidExpiresProperty(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(576).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n         |                  \"expires\": \"").append(new UTCDate(ZonedDateTime.now().plusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER())).append("\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(561).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldCreatedWhenValidRequest$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldCreatedWhenValidRequest(pushServer);
    }

    @Test
    default public void setMethodShouldCreatedWhenValidRequest(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(516).append("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(561).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldCreatedSeveralValidCreationRequest$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldCreatedSeveralValidCreationRequest(pushServer);
    }

    @Test
    default public void setMethodShouldCreatedSeveralValidCreationRequest(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(725).append("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f28\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n        |                  \"types\": [\"Mailbox\"]\n        |                },\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-912\",\n        |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n        |                  \"types\": [\"Email\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(772).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f28\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    },\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldSuccessWhenMixCase$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldSuccessWhenMixCase(pushServer);
    }

    @Test
    default public void setMethodShouldSuccessWhenMixCase(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(727).append("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f28\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n        |                  \"types\": [\"Mailbox\"]\n        |                },\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-912\",\n        |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n        |                  \"types\": [\"invalid\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(916).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f28\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                },\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"'/types(0)' property in PushSubscription object is not valid: Unknown typeName invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void updateShouldValidateVerificationCode$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldValidateVerificationCode(server);
    }

    @Test
    default public void updateShouldValidateVerificationCode(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(414).append("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"").append(pushSubscription.id().serialise()).append("\": {\n        |                  \"verificationCode\": \"").append(pushSubscription.verificationCode()).append("\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(390).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"").append(pushSubscription.id().serialise()).append("\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
        Assertions.assertThat((boolean)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).validated()).isTrue();
    }

    public static /* synthetic */ void setMethodShouldRejectInvalidKey$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldRejectInvalidKey();
    }

    @Test
    default public void setMethodShouldRejectInvalidKey() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"keys\": {\n        |                    \"p256dh\": \"QmFkIGtleQo\",\n        |                    \"auth\": \"YXV0aCBzZWNyZXQK\"\n        |                  }\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(644).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"java.security.spec.InvalidKeySpecException: java.security.InvalidKeyException: IOException: null\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldAcceptValidKey$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldAcceptValidKey(pushServer);
    }

    @Test
    default public void setMethodShouldAcceptValidKey(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(814).append("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"keys\": {\n        |                    \"p256dh\": \"MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE5ozzvKUAB7GIfJ44eG-sxEcjT1O2jtk9QVD-MzFOH988CAPlSdkitm16NsMxUWksq6qGwu-r6zT7GCM9oGPXtQ==\",\n        |                    \"auth\": \"Z7B0LmM6iTZD85EWtNRwIg==\"\n        |                  }\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(561).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void updateMixed$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateMixed(server);
    }

    @Test
    default public void updateMixed(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d081", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d082", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription3 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d083", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription4 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d084", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(756).append("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"").append(pushSubscription1.id().serialise()).append("\": {\n        |                  \"verificationCode\": \"").append(pushSubscription1.verificationCode()).append("\"\n        |                },\n        |                \"").append(pushSubscription2.id().serialise()).append("\": {\n        |                  \"verificationCode\": \"wrong\"\n        |                },\n        |                \"").append(pushSubscription3.id().serialise()).append("\": {\n        |                  \"verificationCode\": \"").append(pushSubscription3.verificationCode()).append("\"\n        |                },\n        |                \"").append(pushSubscription4.id().serialise()).append("\": {\n        |                  \"verificationCode\": \"wrongAgain\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1234).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"").append(pushSubscription1.id().serialise()).append("\": {},\n           |                    \"").append(pushSubscription3.id().serialise()).append("\": {}\n           |                },\n           |                \"notUpdated\": {\n           |                    \"").append(pushSubscription2.id().serialise()).append("\": {\n           |                        \"type\": \"invalidProperties\",\n           |                        \"description\": \"Wrong verification code\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    },\n           |                    \"").append(pushSubscription4.id().serialise()).append("\": {\n           |                        \"type\": \"invalidProperties\",\n           |                        \"description\": \"Wrong verification code\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription1.id()).validated()).isTrue();
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription2.id()).validated()).isFalse();
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription3.id()).validated()).isTrue();
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription4.id()).validated()).isFalse();
        });
    }

    public static /* synthetic */ void updateShouldNotValidateVerificationCodeWhenWrong$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldNotValidateVerificationCodeWhenWrong(server);
    }

    @Test
    default public void updateShouldNotValidateVerificationCodeWhenWrong(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(419).append("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"").append(pushSubscription.id().serialise()).append("\": {\n        |                  \"verificationCode\": \"wrong\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(718).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"").append(pushSubscription.id().serialise()).append("\": {\n           |                        \"type\": \"invalidProperties\",\n           |                        \"description\": \"Wrong verification code\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
        Assertions.assertThat((boolean)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).validated()).isFalse();
    }

    public static /* synthetic */ void updateValidExpiresShouldSucceed$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateValidExpiresShouldSucceed(server);
    }

    @Test
    default public void updateValidExpiresShouldSucceed(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String validExpiresString = new UTCDate(ZonedDateTime.now().plusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(419).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"").append(pushSubscription.id().serialise()).append("\": {\n         |                 \"expires\": \"").append(validExpiresString).append("\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(390).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"").append(pushSubscription.id().serialise()).append("\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
        Assertions.assertThat((String)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).expires().value().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER())).isEqualTo(validExpiresString);
    }

    public static /* synthetic */ void updateInvalidExpiresStringShouldFail$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateInvalidExpiresStringShouldFail(server);
    }

    @Test
    default public void updateInvalidExpiresStringShouldFail(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String invalidExpiresString = "whatever";
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(419).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"").append(pushSubscription.id().serialise()).append("\": {\n         |                 \"expires\": \"").append(invalidExpiresString).append("\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(482).append("{\n           |\t\"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"PushSubscription/set\",\n           |\t\t\t{\n           |\t\t\t\t\"notUpdated\": {\n           |\t\t\t\t\t\"").append(pushSubscription.id().serialise()).append("\": {\n           |\t\t\t\t\t\t\"type\": \"invalidArguments\",\n           |\t\t\t\t\t\t\"description\": \"This string can not be parsed to UTCDate\",\n           |\t\t\t\t\t\t\"properties\": [\"expires\"]\n           |\t\t\t\t\t}\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}").toString())));
    }

    public static /* synthetic */ void updateWithBiggerExpiresThanServerLimitShouldSetToServerLimitAndExplicitlyReturned$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateWithBiggerExpiresThanServerLimitShouldSetToServerLimitAndExplicitlyReturned(server);
    }

    @Test
    default public void updateWithBiggerExpiresThanServerLimitShouldSetToServerLimitAndExplicitlyReturned(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String biggerExpiresString = new UTCDate(ZonedDateTime.now().plusDays(10L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(419).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"").append(pushSubscription.id().serialise()).append("\": {\n         |                 \"expires\": \"").append(biggerExpiresString).append("\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String fixedExpires = probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).expires().value().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(473).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"").append(pushSubscription.id().serialise()).append("\": {\n           |                        \"expires\": \"").append(fixedExpires).append("\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void updateOutdatedExpiresShouldFail$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateOutdatedExpiresShouldFail(server);
    }

    @Test
    default public void updateOutdatedExpiresShouldFail(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String invalidExpiresString = new UTCDate(ZonedDateTime.now().minusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(419).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"").append(pushSubscription.id().serialise()).append("\": {\n         |                 \"expires\": \"").append(invalidExpiresString).append("\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(477).append("{\n           |\t\"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"PushSubscription/set\",\n           |\t\t\t{\n           |\t\t\t\t\"notUpdated\": {\n           |\t\t\t\t\t\"").append(pushSubscription.id().serialise()).append("\": {\n           |\t\t\t\t\t\t\"type\": \"invalidArguments\",\n           |\t\t\t\t\t\t\"description\": \"`").append(invalidExpiresString).append("` expires must be greater than now\",\n           |\t\t\t\t\t\t\"properties\": [\"expires\"]\n           |\t\t\t\t\t}\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}").toString())));
    }

    public static /* synthetic */ void updateShouldFailWhenUnknownProperty$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldFailWhenUnknownProperty(server);
    }

    @Test
    default public void updateShouldFailWhenUnknownProperty(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(413).append("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"").append(pushSubscription.id().serialise()).append("\": {\n        |                  \"unknown\": \"whatever\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(656).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"").append(pushSubscription.id().serialise()).append("\": {\n           |                        \"description\":\"unknown property do not exist thus cannot be updated\",\n           |                        \"properties\":[\"unknown\"],\n           |                        \"type\":\"invalidArguments\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
        Assertions.assertThat((boolean)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).validated()).isFalse();
    }

    public static /* synthetic */ void updateShouldFailWhenInvalidId$(PushSubscriptionSetMethodContract $this) {
        $this.updateShouldFailWhenInvalidId();
    }

    @Test
    default public void updateShouldFailWhenInvalidId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"bad\": {\n        |                  \"verificationCode\": \"anyValue\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(571).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"bad\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Invalid UUID string: bad\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void updateShouldFailWhenNotFound$(PushSubscriptionSetMethodContract $this) {
        $this.updateShouldFailWhenNotFound();
    }

    @Test
    default public void updateShouldFailWhenNotFound() {
        String id = UUID.randomUUID().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(422).append("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"").append(id).append("\": {\n        |                  \"verificationCode\": \"anyValue\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(538).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"").append(id).append("\": {\n           |                        \"type\": \"notFound\",\n           |                        \"description\": null\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodCreateShouldCallVerificationToPushServer$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodCreateShouldCallVerificationToPushServer(pushServer);
    }

    @Test
    default public void setMethodCreateShouldCallVerificationToPushServer(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(533).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String pushSubscriptionId = (String)((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).extract().jsonPath().get("methodResponses[0][1].created.4f29.id");
        pushServer.verify((RequestDefinition)HttpRequest.request().withPath("/subscribe").withBody((Body)JsonBody.json((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(216).append("{\n                        |    \"@type\": \"PushVerification\",\n                        |    \"pushSubscriptionId\": \"").append(pushSubscriptionId).append("\",\n                        |    \"verificationCode\": \"${json-unit.any-string}\"\n                        |}").toString())))), VerificationTimes.atLeast((int)1));
    }

    public static /* synthetic */ void setMethodCreateShouldNotCreatedWhenCallVerificationToPushServerHasError$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodCreateShouldNotCreatedWhenCallVerificationToPushServerHasError(pushServer);
    }

    @Test
    default public void setMethodCreateShouldNotCreatedWhenCallVerificationToPushServerHasError(ClientAndServer pushServer) {
        pushServer.when((RequestDefinition)HttpRequest.request().withPath("/invalid").withMethod("POST")).respond(HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(500)));
        String pushServerUrl = new StringBuilder(25).append("http://127.0.0.1:").append(pushServer.getLocalPort()).append("/invalid").toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(533).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"").append(pushServerUrl).append("\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(574).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"serverFail\",\n           |                        \"description\": \"Error when call to Push Server. \"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodCreateShouldNotSaveSubscriptionEntryWhenCallVerificationToPushServerHasError$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodCreateShouldNotSaveSubscriptionEntryWhenCallVerificationToPushServerHasError(pushServer);
    }

    @Test
    default public void setMethodCreateShouldNotSaveSubscriptionEntryWhenCallVerificationToPushServerHasError(ClientAndServer pushServer) {
        pushServer.when((RequestDefinition)HttpRequest.request().withPath("/invalid").withMethod("POST")).respond(HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(500)));
        String deviceId = "a889-ffea-910";
        String invalidPushServerUrl = new StringBuilder(25).append("http://127.0.0.1:").append(pushServer.getLocalPort()).append("/invalid").toString();
        ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(554).append("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"").append(deviceId).append("\",\n           |                  \"url\": \"").append(invalidPushServerUrl).append("\",\n           |                  \"types\": [\"Mailbox\"]\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }").toString()))).when().post()).then().statusCode(200);
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(554).append("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"").append(deviceId).append("\",\n           |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n           |                  \"types\": [\"Mailbox\"]\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(561).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void setMethodShouldAcceptValidKeys$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldAcceptValidKeys(pushServer);
    }

    @Test
    default public void setMethodShouldAcceptValidKeys(ClientAndServer pushServer) {
        KeyPair uaKeyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256);
        ECPublicKey uaPublicKey = (ECPublicKey)uaKeyPair.getPublic();
        byte[] authSecret = Random.randBytes((int)16);
        String p256dh = Base64.getUrlEncoder().encodeToString(uaPublicKey.getEncoded());
        String auth = Base64.getUrlEncoder().encodeToString(authSecret);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(687).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n         |                  \"types\": [\"Mailbox\"],\n         |                  \"keys\": {\n         |                    \"p256dh\": \"").append(p256dh).append("\",\n         |                    \"auth\": \"").append(auth).append("\"\n         |                  }\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(561).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void bodyRequestToPushServerShouldBeEncryptedWhenClientAssignEncryptionKeys$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.bodyRequestToPushServerShouldBeEncryptedWhenClientAssignEncryptionKeys(pushServer);
    }

    @Test
    default public void bodyRequestToPushServerShouldBeEncryptedWhenClientAssignEncryptionKeys(ClientAndServer pushServer) {
        KeyPair uaKeyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256);
        ECPublicKey uaPublicKey = (ECPublicKey)uaKeyPair.getPublic();
        byte[] authSecret = "secret123secret1".getBytes();
        String p256dh = Base64.getUrlEncoder().encodeToString(uaPublicKey.getEncoded());
        String auth = Base64.getUrlEncoder().encodeToString(authSecret);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(687).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"").append(this.getPushServerUrl(pushServer)).append("\",\n         |                  \"types\": [\"Mailbox\"],\n         |                  \"keys\": {\n         |                    \"p256dh\": \"").append(p256dh).append("\",\n         |                    \"auth\": \"").append(auth).append("\"\n         |                  }\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200);
        pushServer.verify((RequestDefinition)HttpRequest.request().withPath("/subscribe").withBody((Body)Not.not((Not)JsonBody.json((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"@type\": \"PushVerification\",\n           |    \"pushSubscriptionId\": \"${json-unit.any-string}\",\n           |    \"verificationCode\": \"${json-unit.any-string}\"\n           |}"))))), VerificationTimes.atLeast((int)1));
    }

    public static /* synthetic */ void destroyShouldSucceed$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.destroyShouldSucceed(server);
    }

    @Test
    default public void destroyShouldSucceed(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(296).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"").append(pushSubscription.id().value().toString()).append("\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(326).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"destroyed\": [\"").append(pushSubscription.id().value().toString()).append("\"]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
        Assertions.assertThat((Object)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id())).isNull();
    }

    public static /* synthetic */ void destroyShouldFailWhenInvalidId$(PushSubscriptionSetMethodContract $this) {
        $this.destroyShouldFailWhenInvalidId();
    }

    @Test
    default public void destroyShouldFailWhenInvalidId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"invalid\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(618).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notDestroyed\": {\n           |                    \"invalid\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"invalid is not a PushSubscriptionId: Invalid UUID string: invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void destroyShouldNotFailWhenUnknownId$(PushSubscriptionSetMethodContract $this) {
        $this.destroyShouldNotFailWhenUnknownId();
    }

    @Test
    default public void destroyShouldNotFailWhenUnknownId() {
        String id = UUID.randomUUID().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(296).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"").append(id).append("\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(325).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"destroyed\":[\"").append(id).append("\"]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void destroyShouldHandleMixedCases$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.destroyShouldHandleMixedCases(server);
    }

    @Test
    default public void destroyShouldHandleMixedCases(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d086")), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URL("https://example.com/push/?device=X8980fc&client=12c6d087")), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(311).append("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"").append(pushSubscription1.id().value().toString()).append("\", \"").append(pushSubscription2.id().value().toString()).append("\", \"invalid\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }").toString()));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(763).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"destroyed\": [\n           |                    \"").append(pushSubscription1.id().value().toString()).append("\",\n           |                    \"").append(pushSubscription2.id().value().toString()).append("\"\n           |                ],\n           |                \"notDestroyed\": {\n           |                    \"invalid\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"invalid is not a PushSubscriptionId: Invalid UUID string: invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static void $init$(PushSubscriptionSetMethodContract $this) {
    }
}

