/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import com.google.common.hash.Hashing;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.io.Serializable;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Y4qAD\b\u0011\u0002\u0007\u0005A\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003<\u0001\u0011\u0005A\bC\u0003C\u0001\u0011\u00051\tC\u0003G\u0001\u0011\u0005q\tC\u0003K\u0001\u0011\u00051\nC\u0003O\u0001\u0011\u0005q\nC\u0003S\u0001\u0011\u0005A\u0005C\u0003U\u0001\u0011\u0005A\u0005C\u0003W\u0001\u0011\u0005A\u0005C\u0003Y\u0001\u0011\u0005A\u0005C\u0003[\u0001\u0011\u0005A\u0005C\u0003]\u0001\u0011%QL\u0001\u000eNC&d'm\u001c=Rk\u0016\u0014\u00180T3uQ>$7i\u001c8ue\u0006\u001cGO\u0003\u0002\u0011#\u0005A1m\u001c8ue\u0006\u001cGO\u0003\u0002\u0013'\u00059!OZ29mI\n$B\u0001\u000b\u0016\u0003\u0011QW.\u00199\u000b\u0005Y9\u0012!\u00026b[\u0016\u001c(B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#A\u0013\u0011\u0005y1\u0013BA\u0014 \u0005\u0011)f.\u001b;\u0002\u000bM,G/\u00169\u0015\u0005\u0015R\u0003\"B\u0016\u0003\u0001\u0004a\u0013AB:feZ,'\u000f\u0005\u0002.]5\tQ#\u0003\u00020+\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\u0005E\u0002\"AM\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00027o\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001d\u001a\u0003\u0015QWO\\5u\u0013\tQ4G\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001&\\1jY\n|\u00070U;fef\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\\,iK:<&o\u001c8h\u0003\u000e\u001cw.\u001e8u\u0013\u0012$\"!J\u001f\t\u000b-\u001a\u0001\u0019\u0001\u0017)\u0005\ry\u0004C\u0001\u001aA\u0013\t\t5G\u0001\u0003UKN$\u0018!\t:pY\u0016\u001c\u0006n\\;mI\u0006cGn\\<U_J+GO]5fm\u0016$\u0006.Z%oE>DHCA\u0013E\u0011\u0015YC\u00011\u0001-Q\t!q(\u0001\u001as_2,7\u000b[8vY\u0012\fE\u000e\\8x)>\u0014V\r\u001e:jKZ,G\u000b[3J]\n|\u00070\u00169p]\u000e\u000b7/\u001a,be&\fG/[8o)\t)\u0003\nC\u0003,\u000b\u0001\u0007A\u0006\u000b\u0002\u0006\u007f\u0005a\u0013/^3ss\nK(k\u001c7f'\"|W\u000f\u001c3O_R\u0014V\r^;s]\u0012+G.Z4bi\u0016$W*Y5mE>DXm\u001d\u000b\u0003K1CQa\u000b\u0004A\u00021B#AB \u0002{E,XM]=CsJ{G.Z*i_VdGMT8u%\u0016$XO\u001d8EK2,w-\u0019;fI6\u000b\u0017\u000e\u001c2pq\u0016\u001cx\u000b[3o\u0007\u0006\u001cXMV1sS\u0006$\u0018n\u001c8\u0015\u0005\u0015\u0002\u0006\"B\u0016\b\u0001\u0004a\u0003FA\u0004@\u0003mIgN^1mS\u0012\u0014v\u000e\\3TQ>,H\u000e\u001a\"f%\u0016TWm\u0019;fI\"\u0012\u0001bP\u0001\u0014e>dWm\u00155pk2$')Z!TiJLgn\u001a\u0015\u0003\u0013}\naC]8mKNCw.\u001e7e\u0005\u0016\u001cu.\u001c9vYN|'/\u001f\u0015\u0003\u0015}\nag\u001d5pk2$'+\u001a;ve:LeN^1mS\u0012\f%oZ;nK:$8o\u00165f]&sg/\u00197jI\u001aKG\u000e^3s\u0007>tG-\u001b;j_:D#aC \u00021\u0019LG\u000e^3s'\"|W\u000f\u001c3CK\u000e{W\u000e];mg>\u0014\u0018\u0010\u000b\u0002\r\u007f\u0005\u0011r-\u001a8fe\u0006$X-U;fef\u001cF/\u0019;f)\tq\u0016\u000e\u0005\u0002`M:\u0011\u0001\r\u001a\t\u0003C~i\u0011A\u0019\u0006\u0003Gn\ta\u0001\u0010:p_Rt\u0014BA3 \u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015|\u0002\"\u00026\u000e\u0001\u0004Y\u0017aA5egB\u0019a\u0004\u001c8\n\u00055|\"A\u0003\u001fsKB,\u0017\r^3e}A\u0011q\u000e^\u0007\u0002a*\u0011\u0011O]\u0001\u0006[>$W\r\u001c\u0006\u0003gV\tq!\\1jY\n|\u00070\u0003\u0002va\nIQ*Y5mE>D\u0018\n\u001a")
public interface MailboxQueryMethodContract {
    public static /* synthetic */ void setUp$(MailboxQueryMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void mailboxQueryShouldFailWhenWrongAccountId$(MailboxQueryMethodContract $this, GuiceJamesServer server) {
        $this.mailboxQueryShouldFailWhenWrongAccountId(server);
    }

    @Test
    default public void mailboxQueryShouldFailWhenWrongAccountId(GuiceJamesServer server) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/query\",\n         |    {\n         |      \"accountId\": \"unknownAccountId\",\n         |      \"filter\": {\"role\":\"Inbox\"}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().log().ifValidationFails().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(176).append("{\n        |  \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n        |  \"methodResponses\": [\n        |    [\"error\", {\n        |      \"type\": \"accountNotFound\"\n        |    }, \"c1\"]\n        |  ]\n        |}").toString())));
    }

    public static /* synthetic */ void roleShouldAllowToRetrieveTheInbox$(MailboxQueryMethodContract $this, GuiceJamesServer server) {
        $this.roleShouldAllowToRetrieveTheInbox(server);
    }

    @Test
    default public void roleShouldAllowToRetrieveTheInbox(GuiceJamesServer server) {
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"INBOX"));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"filter\": {\"role\":\"Inbox\"}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(673).append("{\n           |    \"sessionState\": \"").append(UuidState$.MODULE$.INSTANCE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Mailbox/query\",\n           |            {\n           |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |                \"queryState\": \"").append(this.generateQueryState((Seq<MailboxId>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MailboxId[]{mailboxId}))).append("\",\n           |                \"canCalculateChanges\": false,\n           |                \"ids\": [\n           |                    \"").append(mailboxId.serialize()).append("\"\n           |                ],\n           |                \"position\": 0,\n           |                \"limit\": 256\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void roleShouldAllowToRetrieveTheInboxUponCaseVariation$(MailboxQueryMethodContract $this, GuiceJamesServer server) {
        $this.roleShouldAllowToRetrieveTheInboxUponCaseVariation(server);
    }

    @Test
    default public void roleShouldAllowToRetrieveTheInboxUponCaseVariation(GuiceJamesServer server) {
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"InBoX"));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"filter\": {\"role\":\"Inbox\"}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].ids").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(32).append("[\n           |  \"").append(mailboxId.serialize()).append("\"\n           |]").toString())));
    }

    public static /* synthetic */ void queryByRoleShouldNotReturnDelegatedMailboxes$(MailboxQueryMethodContract $this, GuiceJamesServer server) {
        $this.queryByRoleShouldNotReturnDelegatedMailboxes(server);
    }

    @Test
    default public void queryByRoleShouldNotReturnDelegatedMailboxes(GuiceJamesServer server) {
        MailboxPath andreInbox = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andreInbox);
        MailboxId bobInboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andreInbox, Fixture$.MODULE$.BOB().asString(), MailboxACL.FULL_RIGHTS);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:apache:james:params:jmap:mail:shares\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"filter\": {\"role\":\"Inbox\"}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(673).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Mailbox/query\",\n           |            {\n           |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |                \"queryState\": \"").append(this.generateQueryState((Seq<MailboxId>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MailboxId[]{bobInboxId}))).append("\",\n           |                \"canCalculateChanges\": false,\n           |                \"ids\": [\n           |                    \"").append(bobInboxId.serialize()).append("\"\n           |                ],\n           |                \"position\": 0,\n           |                \"limit\": 256\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void queryByRoleShouldNotReturnDelegatedMailboxesWhenCaseVariation$(MailboxQueryMethodContract $this, GuiceJamesServer server) {
        $this.queryByRoleShouldNotReturnDelegatedMailboxesWhenCaseVariation(server);
    }

    @Test
    default public void queryByRoleShouldNotReturnDelegatedMailboxesWhenCaseVariation(GuiceJamesServer server) {
        MailboxPath andreInbox = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andreInbox);
        MailboxId bobInboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"InBoX"));
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andreInbox, Fixture$.MODULE$.BOB().asString(), MailboxACL.FULL_RIGHTS);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:apache:james:params:jmap:mail:shares\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"filter\": {\"role\":\"Inbox\"}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(673).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Mailbox/query\",\n           |            {\n           |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |                \"queryState\": \"").append(this.generateQueryState((Seq<MailboxId>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MailboxId[]{bobInboxId}))).append("\",\n           |                \"canCalculateChanges\": false,\n           |                \"ids\": [\n           |                    \"").append(bobInboxId.serialize()).append("\"\n           |                ],\n           |                \"position\": 0,\n           |                \"limit\": 256\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void invalidRoleShouldBeRejected$(MailboxQueryMethodContract $this) {
        $this.invalidRoleShouldBeRejected();
    }

    @Test
    default public void invalidRoleShouldBeRejected() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"filter\": {\"role\":\"Invalid\"}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(459).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"invalidArguments\",\n           |                \"description\": \"{\\\"errors\\\":[{\\\"path\\\":\\\"obj.filter.role\\\",\\\"messages\\\":[\\\"Invalid is not a valid role\\\"]}]}\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void roleShouldBeAString$(MailboxQueryMethodContract $this) {
        $this.roleShouldBeAString();
    }

    @Test
    default public void roleShouldBeAString() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"filter\": {\"role\":123}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(491).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"invalidArguments\",\n           |                \"description\": \"{\\\"errors\\\":[{\\\"path\\\":\\\"obj.filter.role\\\",\\\"messages\\\":[\\\"Expecting a JsString to be representing a role\\\"]}]}\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}\n           |").toString())));
    }

    public static /* synthetic */ void roleShouldBeCompulsory$(MailboxQueryMethodContract $this) {
        $this.roleShouldBeCompulsory();
    }

    @Test
    default public void roleShouldBeCompulsory() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"filter\": {}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(450).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"invalidArguments\",\n           |                \"description\": \"{\\\"errors\\\":[{\\\"path\\\":\\\"obj.filter.role\\\",\\\"messages\\\":[\\\"error.path.missing\\\"]}]}\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void shouldReturnInvalidArgumentsWhenInvalidFilterCondition$(MailboxQueryMethodContract $this) {
        $this.shouldReturnInvalidArgumentsWhenInvalidFilterCondition();
    }

    @Test
    default public void shouldReturnInvalidArgumentsWhenInvalidFilterCondition() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"filter\":{\n         |        \"unsupported_option\": \"blahh_blahh\",\n         |        \"role\":\"Inbox\"\n         |      }\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(486).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"invalidArguments\",\n           |                \"description\": \"{\\\"errors\\\":[{\\\"path\\\":\\\"obj.filter\\\",\\\"messages\\\":[\\\"These '[unsupported_option]' was unsupported filter options\\\"]}]}\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}").toString())));
    }

    public static /* synthetic */ void filterShouldBeCompulsory$(MailboxQueryMethodContract $this) {
        $this.filterShouldBeCompulsory();
    }

    @Test
    default public void filterShouldBeCompulsory() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(458).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"invalidArguments\",\n           |                \"description\": \"{\\\"errors\\\":[{\\\"path\\\":\\\"obj.filter\\\",\\\"messages\\\":[\\\"error.path.missing\\\"]}]}\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}\n           |").toString())));
    }

    private String generateQueryState(Seq<MailboxId> ids) {
        return Hashing.murmur3_32().hashUnencodedChars((CharSequence)ids.toList().map((Function1 & Serializable)x$1 -> x$1.serialize()).mkString(" ")).toString();
    }

    public static void $init$(MailboxQueryMethodContract $this) {
    }
}

