/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.mail.internet.SharedInputStream;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.mail.MDNParseRequest$;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.BodyPartBuilder;
import org.apache.james.mime4j.message.MultipartBuilder;
import org.apache.james.mime4j.message.SingleBodyBuilder;
import org.apache.james.mime4j.stream.NameValuePair;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.utils.DataProbeImpl;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005eaa\u0002\u000b\u0016!\u0003\r\tA\t\u0005\u0006S\u0001!\tA\u000b\u0005\t]\u0001A)\u0019!C\u0005_!A\u0001\b\u0001EC\u0002\u0013%\u0011\b\u0003\u0005C\u0001!\u0015\r\u0011\"\u0003:\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u00151\u0006A\"\u0001X\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015\u0001\b\u0001\"\u0001+\u0011\u0015\u0011\b\u0001\"\u0001+\u0011\u0015!\b\u0001\"\u0001v\u0011\u0015A\b\u0001\"\u0001+\u0011\u0015Q\b\u0001\"\u0001+\u0011\u0015a\b\u0001\"\u0001~\u0011\u0019\t\t\u0001\u0001C\u0001U!1\u0011Q\u0001\u0001\u0005\u0002)Bq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\u0003-5#e\nU1sg\u0016lU\r\u001e5pI\u000e{g\u000e\u001e:bGRT!AF\f\u0002\u0011\r|g\u000e\u001e:bGRT!\u0001G\r\u0002\u000fI47\r\u000f\u001c3c)\u0011!dG\u0001\u0005U6\f\u0007O\u0003\u0002\u001d;\u0005)!.Y7fg*\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\t1\u0006\u0005\u0002%Y%\u0011Q&\n\u0002\u0005+:LG/A\u000btY><\b+Y2fIB{G\u000e\\%oi\u0016\u0014h/\u00197\u0016\u0003A\u0002\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\tQLW.\u001a\u0006\u0002k\u0005!!.\u0019<b\u0013\t9$G\u0001\u0005EkJ\fG/[8o\u0003-\u0019\u0017\r\\7ms\u0006;\u0018-\u001b;\u0016\u0003i\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\t\r|'/\u001a\u0006\u0003\u007f}\t!\"Y<bSRLG.\u001b;z\u0013\t\tEH\u0001\tD_:$\u0017\u000e^5p]\u001a\u000b7\r^8ss\u0006)\u0012m^1ji\u000e{g\u000eZ5uS>tg)Y2u_JL\u0018!B:fiV\u0003HCA\u0016F\u0011\u00151U\u00011\u0001H\u0003\u0019\u0019XM\u001d<feB\u0011\u0001*S\u0007\u00027%\u0011!j\u0007\u0002\u0011\u000fVL7-\u001a&b[\u0016\u001c8+\u001a:wKJD#!\u0002'\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016aA1qS*\u0011\u0011KU\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019v$A\u0003kk:LG/\u0003\u0002V\u001d\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001fI\fg\u000eZ8n\u001b\u0016\u001c8/Y4f\u0013\u0012,\u0012\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000bQ!\\8eK2T!!X\u000e\u0002\u000f5\f\u0017\u000e\u001c2pq&\u0011qL\u0017\u0002\n\u001b\u0016\u001c8/Y4f\u0013\u0012\f\u0011\u0006]1sg\u0016\u001c\u0006n\\;mIN+8mY3tg^KG\u000f['E\u001d\"\u000b7/\u00117m!J|\u0007/\u001a:uS\u0016\u001cHCA\u0016c\u0011\u0015\u0019w\u00011\u0001H\u0003A9W/[2f\u0015\u0006lWm]*feZ,'\u000f\u000b\u0002\bKB\u0011QJZ\u0005\u0003O:\u0013A\u0001V3ti\u0006Y\u0002/\u0019:tKNCw.\u001e7e\u0003\u000e\u001cW\r\u001d;TKZ,'/\u00197JIN$\"a\u000b6\t\u000b\rD\u0001\u0019A$)\u0005!)\u0017!\f9beN,7\u000b[8vY\u0012\u001cVoY2fgN<\u0016\u000e\u001e5N\t:C\u0015m]'j]&l\u0017\r\u001c)s_B,'\u000f^5fgR\u00111F\u001c\u0005\u0006G&\u0001\ra\u0012\u0015\u0003\u0013\u0015\fA%\u001c3o!\u0006\u00148/Z*i_VdGMR1jY^CWM\\,s_:<\u0017iY2pk:$\u0018\n\u001a\u0015\u0003\u0015\u0015\fQ&\u001c3o!\u0006\u00148/Z*i_VdGMR1jY^CWM\u001c(v[\n,'o\u00144CY>\u0014\u0017\nZ:U_>d\u0015M]4fQ\tYQ-A\u0015qCJ\u001cXm\u00155pk2$'+\u001a;ve:tu\u000e\u001e)beN,\u0017M\u00197f/\",gNT8u\u0003:lEI\u0014\u000b\u0003WYDQa\u0019\u0007A\u0002\u001dC#\u0001D3\u0002WA\f'o]3TQ>,H\u000e\u001a*fiV\u0014hNT8u\r>,h\u000eZ,iK:\u0014En\u001c2E_:{G/\u0012=jgRD#!D3\u0002MA\f'o]3TQ>,H\u000e\u001a*fiV\u0014hNT8u\r>,h\u000eZ,iK:\u0014\u0015\r\u001a\"m_\nLE\r\u000b\u0002\u000fK\u0006A\u0003/\u0019:tK\u0006sGMT8u\r>,h\u000eZ!oI:{G\u000fU1sg\u0006\u0014G.Z\"b]\n+W*\u001b=fIR\u00111F \u0005\u0006G>\u0001\ra\u0012\u0015\u0003\u001f\u0015\f\u0011(\u001c3o!\u0006\u00148/Z*i_VdGMU3ukJtWK\\6o_^tW*\u001a;i_\u0012<\u0006.\u001a8NSN\u001c\u0018N\\4P]\u0016\u001c\u0015\r]1cS2LG/\u001f\u0015\u0003!\u0015\f1(\u001c3o!\u0006\u00148/Z*i_VdGMU3ukJtWK\\6o_^tW*\u001a;i_\u0012<\u0006.\u001a8NSN\u001c\u0018N\\4BY2\u001c\u0015\r]1cS2LG/[3tQ\t\tR-\u0001\u001bg_J,U.Y5m\u0013\u0012\u001c\u0006n\\;mIJ+G/\u001e:o/\",gn\u0014:jO&t\u0017\r\\'fgN\fw-Z%e\u0013N\u0014V\r\\1uK\u0012$2aKA\u0007\u0011\u0015\u0019'\u00031\u0001HQ\t\u0011R-A\u001bg_J,U.Y5m\u0013\u0012\u001c\u0006n\\;mI\n+g*\u001e7m/\",gn\u0014:jO&t\u0017\r\\'fgN\fw-Z%e\u0013Ntu\u000e\u001e$pk:$GcA\u0016\u0002\u0016!)1m\u0005a\u0001\u000f\"\u00121#\u001a")
public interface MDNParseMethodContract {
    public static /* synthetic */ Duration org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$slowPacedPollInterval$(MDNParseMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$slowPacedPollInterval();
    }

    default public Duration org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$slowPacedPollInterval() {
        return Durations.ONE_HUNDRED_MILLISECONDS;
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$calmlyAwait$(MDNParseMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$calmlyAwait();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$calmlyAwait() {
        return Awaitility.with().pollInterval(this.org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$slowPacedPollInterval()).and().with().pollDelay(this.org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$slowPacedPollInterval()).await();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$awaitConditionFactory$(MDNParseMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$awaitConditionFactory();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$awaitConditionFactory() {
        return this.org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$calmlyAwait().atMost(5L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ void setUp$(MDNParseMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public MessageId randomMessageId();

    public static /* synthetic */ void parseShouldSuccessWithMDNHasAllProperties$(MDNParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseShouldSuccessWithMDNHasAllProperties(guiceJamesServer);
    }

    @Test
    default public void parseShouldSuccessWithMDNHasAllProperties(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/mdn_complex.eml"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(407).append("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"").append(messageId.serialize()).append("\" ]\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1550).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |      [ \"MDN/parse\", {\n           |         \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |         \"parsed\": {\n           |           \"").append(messageId.serialize()).append("\": {\n           |             \"subject\": \"Read: test\",\n           |             \"textBody\": \"To: magiclan@linagora.com\\r\\nSubject: test\\r\\nMessage was displayed on Tue Mar 30 2021 10:31:50 GMT+0700 (Indochina Time)\",\n           |             \"reportingUA\": \"OpenPaaS Unified Inbox; UA_Product\",\n           |             \"disposition\": {\n           |               \"actionMode\": \"manual-action\",\n           |               \"sendingMode\": \"mdn-sent-manually\",\n           |               \"type\": \"displayed\"\n           |             },\n           |             \"finalRecipient\": \"rfc822; tungexplorer@linagora.com\",\n           |             \"originalMessageId\": \"<633c6811-f897-ec7c-642a-2360366e1b93@linagora.com>\",\n           |             \"originalRecipient\": \"rfc822; tungexplorer@linagora.com\",\n           |             \"includeOriginalMessage\": true,\n           |             \"error\": [\n           |                \"Message1\",\n           |                \"Message2\"\n           |             ],\n           |             \"extensionFields\": {\n           |                \"X-OPENPAAS-IP\" : \" 177.177.177.77\",\n           |                \"X-OPENPAAS-PORT\" : \" 8000\"\n           |             }\n           |           }\n           |         }\n           |      }, \"c1\" ]]\n           |}").toString())));
    }

    public static /* synthetic */ void parseShouldAcceptSeveralIds$(MDNParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseShouldAcceptSeveralIds(guiceJamesServer);
    }

    @Test
    default public void parseShouldAcceptSeveralIds(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId1 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/mdn_simple.eml"))).getMessageId();
        MessageId messageId2 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/mdn_simple.eml"))).getMessageId();
        MessageId messageId3 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/mdn_simple.eml"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(414).append("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"").append(messageId1.serialize()).append("\", \"").append(messageId2.serialize()).append("\", \"").append(messageId3.serialize()).append("\"]\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].parsed").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1544).append("{\n           |    \"").append(messageId1.serialize()).append("\": {\n           |        \"subject\": \"Read: test\",\n           |        \"textBody\": \"This is simple body of human-readable part\",\n           |        \"finalRecipient\": \"rfc822; tungexplorer@linagora.com\",\n           |        \"includeOriginalMessage\": false,\n           |        \"disposition\": {\n           |            \"actionMode\": \"manual-action\",\n           |            \"sendingMode\": \"mdn-sent-manually\",\n           |            \"type\": \"displayed\"\n           |        }\n           |    },\n           |    \"").append(messageId2.serialize()).append("\": {\n           |        \"subject\": \"Read: test\",\n           |        \"textBody\": \"This is simple body of human-readable part\",\n           |        \"finalRecipient\": \"rfc822; tungexplorer@linagora.com\",\n           |        \"includeOriginalMessage\": false,\n           |        \"disposition\": {\n           |            \"actionMode\": \"manual-action\",\n           |            \"sendingMode\": \"mdn-sent-manually\",\n           |            \"type\": \"displayed\"\n           |        }\n           |    },\n           |    \"").append(messageId3.serialize()).append("\": {\n           |        \"subject\": \"Read: test\",\n           |        \"textBody\": \"This is simple body of human-readable part\",\n           |        \"finalRecipient\": \"rfc822; tungexplorer@linagora.com\",\n           |        \"includeOriginalMessage\": false,\n           |        \"disposition\": {\n           |            \"actionMode\": \"manual-action\",\n           |            \"sendingMode\": \"mdn-sent-manually\",\n           |            \"type\": \"displayed\"\n           |        }\n           |    }\n           |}").toString())));
    }

    public static /* synthetic */ void parseShouldSuccessWithMDNHasMinimalProperties$(MDNParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseShouldSuccessWithMDNHasMinimalProperties(guiceJamesServer);
    }

    @Test
    default public void parseShouldSuccessWithMDNHasMinimalProperties(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/mdn_simple.eml"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(407).append("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"").append(messageId.serialize()).append("\" ]\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(872).append("{\n           |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |    \"methodResponses\": [\n           |      [ \"MDN/parse\", {\n           |         \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |         \"parsed\": {\n           |           \"").append(messageId.serialize()).append("\": {\n           |             \"subject\": \"Read: test\",\n           |             \"textBody\": \"This is simple body of human-readable part\",\n           |             \"disposition\": {\n           |               \"actionMode\": \"manual-action\",\n           |               \"sendingMode\": \"mdn-sent-manually\",\n           |               \"type\": \"displayed\"\n           |             },\n           |             \"finalRecipient\": \"rfc822; tungexplorer@linagora.com\",\n           |             \"includeOriginalMessage\": false\n           |           }\n           |         }\n           |      }, \"c1\" ]]\n           |}").toString())));
    }

    public static /* synthetic */ void mdnParseShouldFailWhenWrongAccountId$(MDNParseMethodContract $this) {
        $this.mdnParseShouldFailWhenWrongAccountId();
    }

    @Test
    default public void mdnParseShouldFailWhenWrongAccountId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"unknownAccountId\",\n         |      \"blobIds\": [ \"0f9f65ab-dc7b-4146-850f-6e4881093965\" ]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(263).append("{\n         |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n         |    \"methodResponses\": [[\n         |            \"error\",\n         |            {\n         |                \"type\": \"accountNotFound\"\n         |            },\n         |            \"c1\"\n         |        ]]\n         |}").toString())));
    }

    public static /* synthetic */ void mdnParseShouldFailWhenNumberOfBlobIdsTooLarge$(MDNParseMethodContract $this) {
        $this.mdnParseShouldFailWhenNumberOfBlobIdsTooLarge();
    }

    @Test
    default public void mdnParseShouldFailWhenNumberOfBlobIdsTooLarge() {
        String[] blogIds = (String[])package$.MODULE$.LazyList().continually((Function0 & Serializable)() -> this.randomMessageId().serialize()).take(MDNParseRequest$.MODULE$.MAXIMUM_NUMBER_OF_BLOB_IDS() + 1).toArray(ClassTag$.MODULE$.apply(String.class));
        String blogIdsJson = Json$.MODULE$.stringify((JsValue)Json$.MODULE$.arr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Json.JsValueWrapper[]{Json$.MODULE$.toJsFieldJsValueWrapper((Object)blogIds, Writes$.MODULE$.arrayWrites(ClassTag$.MODULE$.apply(String.class), (Writes)Writes$.MODULE$.StringWrites()))}))).replace("[[", "[").replace("]]", "]");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(402).append("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\":  ").append(blogIdsJson).append("\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].description"}).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(384).append("{\n           |  \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n           |  \"methodResponses\": [[\n           |    \"error\",\n           |    {\n           |          \"type\": \"requestTooLarge\",\n           |          \"description\": \"The number of ids requested by the client exceeds the maximum number the server is willing to process in a single method call\"\n           |    },\n           |    \"c1\"]]\n           |}").toString())));
    }

    public static /* synthetic */ void parseShouldReturnNotParseableWhenNotAnMDN$(MDNParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseShouldReturnNotParseableWhenNotAnMDN(guiceJamesServer);
    }

    @Test
    default public void parseShouldReturnNotParseableWhenNotAnMDN(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Subject MDN").setSender(Fixture$.MODULE$.ANDRE().asString()).setFrom(Fixture$.MODULE$.ANDRE().asString()).setBody(MultipartBuilder.create((String)"report").addTextPart("This is body of text part", StandardCharsets.UTF_8).build()).build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(407).append("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"").append(messageId.serialize()).append("\" ]\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(328).append("{\n         |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n         |    \"methodResponses\": [[\n         |      \"MDN/parse\",\n         |      {\n         |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |        \"notParsable\": [\"").append(messageId.serialize()).append("\"]\n         |      },\n         |      \"c1\"\n         |        ]]\n         |}").toString())));
    }

    public static /* synthetic */ void parseShouldReturnNotFoundWhenBlobDoNotExist$(MDNParseMethodContract $this) {
        $this.parseShouldReturnNotFoundWhenBlobDoNotExist();
    }

    @Test
    default public void parseShouldReturnNotFoundWhenBlobDoNotExist() {
        String blobIdShouldNotFound = this.randomMessageId().serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(407).append("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"").append(blobIdShouldNotFound).append("\" ]\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(325).append("{\n         |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n         |    \"methodResponses\": [[\n         |      \"MDN/parse\",\n         |      {\n         |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |        \"notFound\": [\"").append(blobIdShouldNotFound).append("\"]\n         |      },\n         |      \"c1\"\n         |        ]]\n         |}").toString())));
    }

    public static /* synthetic */ void parseShouldReturnNotFoundWhenBadBlobId$(MDNParseMethodContract $this) {
        $this.parseShouldReturnNotFoundWhenBadBlobId();
    }

    @Test
    default public void parseShouldReturnNotFoundWhenBadBlobId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"invalid\" ]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(332).append("{\n         |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n         |    \"methodResponses\": [[\n         |      \"MDN/parse\",\n         |      {\n         |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |        \"notFound\": [\"invalid\"]\n         |      },\n         |      \"c1\"\n         |        ]]\n         |}").toString())));
    }

    public static /* synthetic */ void parseAndNotFoundAndNotParsableCanBeMixed$(MDNParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseAndNotFoundAndNotParsableCanBeMixed(guiceJamesServer);
    }

    @Test
    default public void parseAndNotFoundAndNotParsableCanBeMixed(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId blobIdParsable = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/mdn_complex.eml"))).getMessageId();
        MessageId blobIdNotParsable = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Subject MDN").setSender(Fixture$.MODULE$.ANDRE().asString()).setFrom(Fixture$.MODULE$.ANDRE().asString()).setBody(MultipartBuilder.create((String)"report").addTextPart("This is body of text part", StandardCharsets.UTF_8).build()).build())).getMessageId();
        MessageId blobIdNotFound = this.randomMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(415).append("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"").append(blobIdParsable.serialize()).append("\", \"").append(blobIdNotParsable.serialize()).append("\", \"").append(blobIdNotFound.serialize()).append("\" ]\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        this.org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$awaitConditionFactory().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1750).append("{\n             |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n             |    \"methodResponses\": [[\n             |      \"MDN/parse\",\n             |      {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"notFound\": [\"").append(blobIdNotFound.serialize()).append("\"],\n             |        \"notParsable\": [\"").append(blobIdNotParsable.serialize()).append("\"],\n             |        \"parsed\": {\n             |           \"").append(blobIdParsable.serialize()).append("\": {\n             |             \"subject\": \"Read: test\",\n             |             \"textBody\": \"To: magiclan@linagora.com\\r\\nSubject: test\\r\\nMessage was displayed on Tue Mar 30 2021 10:31:50 GMT+0700 (Indochina Time)\",\n             |             \"reportingUA\": \"OpenPaaS Unified Inbox; UA_Product\",\n             |             \"disposition\": {\n             |               \"actionMode\": \"manual-action\",\n             |               \"sendingMode\": \"mdn-sent-manually\",\n             |               \"type\": \"displayed\"\n             |             },\n             |             \"finalRecipient\": \"rfc822; tungexplorer@linagora.com\",\n             |             \"originalMessageId\": \"<633c6811-f897-ec7c-642a-2360366e1b93@linagora.com>\",\n             |             \"originalRecipient\": \"rfc822; tungexplorer@linagora.com\",\n             |             \"includeOriginalMessage\": true,\n             |             \"error\": [\n             |                \"Message1\",\n             |                \"Message2\"\n             |             ],\n             |             \"extensionFields\": {\n             |                \"X-OPENPAAS-IP\" : \" 177.177.177.77\",\n             |                \"X-OPENPAAS-PORT\" : \" 8000\"\n             |             }\n             |          }\n             |        }\n             |      },\n             |      \"c1\"\n             |        ]]\n             |}").toString())));
        });
    }

    public static /* synthetic */ void mdnParseShouldReturnUnknownMethodWhenMissingOneCapability$(MDNParseMethodContract $this) {
        $this.mdnParseShouldReturnUnknownMethodWhenMissingOneCapability();
    }

    @Test
    default public void mdnParseShouldReturnUnknownMethodWhenMissingOneCapability() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"123\" ]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(280).append("{\n         |  \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:mdn\"\n         |    },\n         |    \"c1\"]]\n         |}").toString())));
    }

    public static /* synthetic */ void mdnParseShouldReturnUnknownMethodWhenMissingAllCapabilities$(MDNParseMethodContract $this) {
        $this.mdnParseShouldReturnUnknownMethodWhenMissingAllCapabilities();
    }

    @Test
    default public void mdnParseShouldReturnUnknownMethodWhenMissingAllCapabilities() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"123\" ]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(334).append("{\n         |  \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:mdn, urn:ietf:params:jmap:mail, urn:ietf:params:jmap:core\"\n         |    },\n         |    \"c1\"]]\n         |}").toString())));
    }

    public static /* synthetic */ void forEmailIdShouldReturnWhenOriginalMessageIdIsRelated$(MDNParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.forEmailIdShouldReturnWhenOriginalMessageIdIsRelated(guiceJamesServer);
    }

    @Test
    default public void forEmailIdShouldReturnWhenOriginalMessageIdIsRelated(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId originalMessageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/mdn_relate_original_message.eml"))).getMessageId();
        BodyPart mdnBodyPart = BodyPartBuilder.create().setBody(SingleBodyBuilder.create().setText(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(387).append("Reporting-UA: UA_name; UA_product\n                    |MDN-Gateway: smtp; apache.org\n                    |Original-Recipient: rfc822; originalRecipient\n                    |Final-Recipient: rfc822; ").append(Fixture$.MODULE$.BOB().asString()).append("\n                    |Original-Message-ID: <messageId1@Atlassian.JIRA>\n                    |Disposition: automatic-action/MDN-sent-automatically;processed/error,failed\n                    |").toString().replace(System.lineSeparator(), "\r\n")))).buildText()).setContentType("message/disposition-notification", new NameValuePair[0]).build();
        MessageId mdnMessageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Subject MDN").setSender(Fixture$.MODULE$.BOB().asString()).setFrom(Fixture$.MODULE$.BOB().asString()).setBody(MultipartBuilder.create((String)"report").addTextPart("This is body of text part", StandardCharsets.UTF_8).addBodyPart((Entity)mdnBodyPart).build()).build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(407).append("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"").append(mdnMessageId.serialize()).append("\" ]\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        this.org$apache$james$jmap$rfc8621$contract$MDNParseMethodContract$$awaitConditionFactory().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).inPath(new StringBuilder(40).append("methodResponses[0][1].parsed.").append(mdnMessageId.serialize()).append(".forEmailId").toString()).isEqualTo((Object)new StringBuilder(2).append("\"").append(originalMessageId.serialize()).append("\"").toString());
        });
    }

    public static /* synthetic */ void forEmailIdShouldBeNullWhenOriginalMessageIdIsNotFound$(MDNParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.forEmailIdShouldBeNullWhenOriginalMessageIdIsNotFound(guiceJamesServer);
    }

    @Test
    default public void forEmailIdShouldBeNullWhenOriginalMessageIdIsNotFound(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        BodyPart mdnBodyPart = BodyPartBuilder.create().setBody(SingleBodyBuilder.create().setText(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Reporting-UA: UA_name; UA_product\n                    |MDN-Gateway: smtp; apache.org\n                    |Original-Recipient: rfc822; originalRecipient\n                    |Final-Recipient: rfc822; final_recipient\n                    |Original-Message-ID: <notFound@Atlassian.JIRA>\n                    |Disposition: automatic-action/MDN-sent-automatically;processed/error,failed\n                    |".replace(System.lineSeparator(), "\r\n")))).buildText()).setContentType("message/disposition-notification", new NameValuePair[0]).build();
        MessageId mdnMessageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Subject MDN").setSender(Fixture$.MODULE$.BOB().asString()).setFrom(Fixture$.MODULE$.BOB().asString()).setBody(MultipartBuilder.create((String)"report").addTextPart("This is body of text part", StandardCharsets.UTF_8).addBodyPart((Entity)mdnBodyPart).build()).build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(407).append("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mdn\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"MDN/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"").append(mdnMessageId.serialize()).append("\" ]\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath(new StringBuilder(40).append("methodResponses[0][1].parsed.").append(mdnMessageId.serialize()).append(".forEmailId").toString()).isAbsent();
    }

    public static void $init$(MDNParseMethodContract $this) {
    }
}

