/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.util.UUID;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.internal.Options;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.MailAddress;
import org.apache.james.jmap.api.identity.IdentityCreationRequest;
import org.apache.james.jmap.api.model.EmailAddress;
import org.apache.james.jmap.api.model.EmailerName;
import org.apache.james.jmap.api.model.HtmlSignature;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityName;
import org.apache.james.jmap.api.model.TextSignature;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.IdentityProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e3q!\u0004\b\u0011\u0002\u0007\u00051\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003;\u0001\u0011\u00051\u0005C\u0003@\u0001\u0011\u0005\u0001\tC\u0003D\u0001\u0011\u0005A\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0003L\u0001\u0011\u0005A\nC\u0003P\u0001\u0011\u00051\u0005C\u0003R\u0001\u0011\u00051\u0005C\u0003T\u0001\u0011\u00051\u0005C\u0003V\u0001\u0011\u00051\u0005C\u0003X\u0001\u0011\u00051EA\nJI\u0016tG/\u001b;z\u000f\u0016$8i\u001c8ue\u0006\u001cGO\u0003\u0002\u0010!\u0005A1m\u001c8ue\u0006\u001cGO\u0003\u0002\u0012%\u00059!OZ29mI\n$BA\n\u0015\u0003\u0011QW.\u00199\u000b\u0005U1\u0012!\u00026b[\u0016\u001c(BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00019A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#\u0001\u0013\u0011\u0005u)\u0013B\u0001\u0014\u001f\u0005\u0011)f.\u001b;\u0002\u000bM,G/\u00169\u0015\u0005\u0011J\u0003\"\u0002\u0016\u0003\u0001\u0004Y\u0013AB:feZ,'\u000f\u0005\u0002-[5\tA#\u0003\u0002/)\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\u0005A\u0002\"!\r\u001d\u000e\u0003IR!a\r\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00026m\u00059!.\u001e9ji\u0016\u0014(BA\u001c\u0019\u0003\u0015QWO\\5u\u0013\tI$G\u0001\u0006CK\u001a|'/Z#bG\"\faeZ3u\u0013\u0012,g\u000e^5usNCw.\u001e7e%\u0016$XO\u001d8EK\u001a\fW\u000f\u001c;JI\u0016tG/\u001b;zQ\t\u0019A\b\u0005\u00022{%\u0011aH\r\u0002\u0005)\u0016\u001cH/A\u0013hKRLE-\u001a8uSRL8\u000b[8vY\u0012\u0014V\r^;s]\u000e+8\u000f^8n\u0013\u0012,g\u000e^5usR\u0011A%\u0011\u0005\u0006U\u0011\u0001\ra\u000b\u0015\u0003\tq\nadZ3u\u0013\u0012,g\u000e^5usNCw.\u001e7e%\u0016$XO\u001d8BY&\f7/Z:\u0015\u0005\u0011*\u0005\"\u0002\u0016\u0006\u0001\u0004Y\u0003FA\u0003=\u0003\u0001:W\r^%eK:$\u0018\u000e^=TQ>,H\u000eZ*vaB|'\u000f^%eg\u001aKW\r\u001c3\u0015\u0005\u0011J\u0005\"\u0002\u0016\u0007\u0001\u0004Y\u0003F\u0001\u0004=\u0003\u0011:W\r^%eK:$\u0018\u000e^=TQ>,H\u000e\u001a*fiV\u0014h\u000eR8nC&t\u0017\t\\5bg\u0016\u001cHC\u0001\u0013N\u0011\u0015Qs\u00011\u0001,Q\t9A(A\u000eqe>\u0004XM\u001d;jKN\u001c\u0006n\\;mI\n+7+\u001e9q_J$X\r\u001a\u0015\u0003\u0011q\n!\u0004\u001d:pa\u0016\u0014H/[3t'\"|W\u000f\u001c3CK\u001aKG\u000e^3sK\u0012D#!\u0003\u001f\u0002;\t\fG\r\u0015:pa\u0016\u0014H/[3t'\"|W\u000f\u001c3CKJ+'.Z2uK\u0012D#A\u0003\u001f\u00029\t\fG-Q2d_VtG/\u00133TQ>,H\u000e\u001a\"f%\u0016TWm\u0019;fI\"\u00121\u0002P\u0001\u0019O\u0016$(+\u00198e_6LEm\u00155pk2$gj\u001c;GC&d\u0007F\u0001\u0007=\u0001")
public interface IdentityGetContract {
    public static /* synthetic */ void setUp$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addDomain("domain-alias.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void getIdentityShouldReturnDefaultIdentity$(IdentityGetContract $this) {
        $this.getIdentityShouldReturnDefaultIdentity();
    }

    @Test
    default public void getIdentityShouldReturnDefaultIdentity() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(468).append("{\n        |  \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n        |  \"state\": \"").append(UuidState$.MODULE$.INSTANCE().value()).append("\",\n        |  \"list\": [\n        |      {\n        |          \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n        |          \"name\": \"bob@domain.tld\",\n        |          \"email\": \"bob@domain.tld\",\n        |          \"mayDelete\": false,\n        |          \"textSignature\":\"\",\n        |          \"htmlSignature\":\"\"\n        |      }\n        |  ]\n        |}").toString())));
    }

    public static /* synthetic */ void getIdentityShouldReturnCustomIdentity$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.getIdentityShouldReturnCustomIdentity(server);
    }

    @Test
    default public void getIdentityShouldReturnCustomIdentity(GuiceJamesServer server) {
        SMono qual$1 = SMono$.MODULE$.apply(((IdentityProbe)server.getProbe(IdentityProbe.class)).save(Fixture$.MODULE$.BOB(), new IdentityCreationRequest((Option)new Some((Object)new IdentityName("Bob (custom address)")), Fixture$.MODULE$.BOB().asMailAddress(), (Option)new Some((Object)new .colon.colon((Object)new EmailAddress((Option)new Some((Object)new EmailerName("My Boss")), new MailAddress("boss@domain.tld")), (List)Nil$.MODULE$)), (Option)new Some((Object)new .colon.colon((Object)new EmailAddress((Option)new Some((Object)new EmailerName("My Boss 2")), new MailAddress("boss2@domain.tld")), (List)Nil$.MODULE$)), (Option)new Some((Object)new TextSignature("text signature")), (Option)new Some((Object)new HtmlSignature("html signature")))));
        Duration x$1 = qual$1.block$default$1();
        String id = ((Identity)qual$1.block(x$1)).id().id().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(339).append("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"").append(id).append("\"]\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].list[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(455).append("{\n         |\t\"bcc\": [{\n         |\t\t\"email\": \"boss2@domain.tld\",\n         |\t\t\"name\": \"My Boss 2\"\n         |\t}],\n         |\t\"email\": \"bob@domain.tld\",\n         |\t\"htmlSignature\": \"html signature\",\n         |\t\"id\": \"").append(id).append("\",\n         |\t\"mayDelete\": true,\n         |\t\"name\": \"Bob (custom address)\",\n         |\t\"replyTo\": [{\n         |\t\t\"email\": \"boss@domain.tld\",\n         |\t\t\"name\": \"My Boss\"\n         |\t}],\n         |\t\"textSignature\": \"text signature\"\n         |}").toString())));
    }

    public static /* synthetic */ void getIdentityShouldReturnAliases$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.getIdentityShouldReturnAliases(server);
    }

    @Test
    default public void getIdentityShouldReturnAliases(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUserAliasMapping("bob-alias", "domain.tld", "bob@domain.tld");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(new Options(net.javacrumbs.jsonunit.core.Option.IGNORING_ARRAY_ORDER, new net.javacrumbs.jsonunit.core.Option[0])).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(827).append("{\n        |    \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n        |    \"state\": \"").append(UuidState$.MODULE$.INSTANCE().value()).append("\",\n        |    \"list\": [\n        |        {\n        |            \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n        |            \"name\": \"bob@domain.tld\",\n        |            \"email\": \"bob@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        },\n        |        {\n        |            \"id\": \"3739a34e-cd8c-3a42-bf28-578ba24da9da\",\n        |            \"name\": \"bob-alias@domain.tld\",\n        |            \"email\": \"bob-alias@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        }\n        |    ]\n        |}").toString())));
    }

    public static /* synthetic */ void getIdentityShouldSupportIdsField$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.getIdentityShouldSupportIdsField(server);
    }

    @Test
    default public void getIdentityShouldSupportIdsField(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUserAliasMapping("bob-alias", "domain.tld", "bob@domain.tld");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"idNotFound\", \"3739a34e-cd8c-3a42-bf28-578ba24da9da\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(545).append("{\n        |    \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n        |    \"state\": \"").append(UuidState$.MODULE$.INSTANCE().value()).append("\",\n        |    \"list\": [\n        |        {\n        |            \"id\": \"3739a34e-cd8c-3a42-bf28-578ba24da9da\",\n        |            \"name\": \"bob-alias@domain.tld\",\n        |            \"email\": \"bob-alias@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        }\n        |    ],\n        |    \"notFound\": [\"idNotFound\"]\n        |}").toString())));
    }

    public static /* synthetic */ void getIdentityShouldReturnDomainAliases$(IdentityGetContract $this, GuiceJamesServer server) {
        $this.getIdentityShouldReturnDomainAliases(server);
    }

    @Test
    default public void getIdentityShouldReturnDomainAliases(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUserAliasMapping("bob-alias", "domain.tld", "bob@domain.tld");
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addDomainAliasMapping("domain-alias.tld", "domain.tld");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(new Options(net.javacrumbs.jsonunit.core.Option.IGNORING_ARRAY_ORDER, new net.javacrumbs.jsonunit.core.Option[0])).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1509).append("{\n        |    \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n        |    \"state\": \"").append(UuidState$.MODULE$.INSTANCE().value()).append("\",\n        |    \"list\": [\n        |        {\n        |            \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n        |            \"name\": \"bob@domain.tld\",\n        |            \"email\": \"bob@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        },\n        |        {\n        |            \"id\": \"b025b9f1-95c6-30fb-a9d4-0fddfcc3a92c\",\n        |            \"name\": \"bob@domain-alias.tld\",\n        |            \"email\": \"bob@domain-alias.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        },\n        |        {\n        |            \"id\": \"3739a34e-cd8c-3a42-bf28-578ba24da9da\",\n        |            \"name\": \"bob-alias@domain.tld\",\n        |            \"email\": \"bob-alias@domain.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        },\n        |        {\n        |            \"id\": \"d2e1e9d2-78ef-3967-87c6-cdc2e0f1541d\",\n        |            \"name\": \"bob-alias@domain-alias.tld\",\n        |            \"email\": \"bob-alias@domain-alias.tld\",\n        |            \"mayDelete\": false,\n        |            \"textSignature\":\"\",\n        |            \"htmlSignature\":\"\"\n        |        }\n        |    ]\n        |}").toString())));
    }

    public static /* synthetic */ void propertiesShouldBeSupported$(IdentityGetContract $this) {
        $this.propertiesShouldBeSupported();
    }

    @Test
    default public void propertiesShouldBeSupported() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null,\n         |      \"properties\": [\"id\", \"name\", \"email\", \"replyTo\", \"bcc\", \"textSignature\", \"htmlSignature\", \"mayDelete\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(494).append("{\n          |  \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n          |  \"state\": \"").append(UuidState$.MODULE$.INSTANCE().value()).append("\",\n          |  \"list\": [\n          |      {\n          |          \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n          |          \"name\": \"bob@domain.tld\",\n          |          \"email\": \"bob@domain.tld\",\n          |          \"mayDelete\": false,\n          |          \"textSignature\":\"\",\n          |          \"htmlSignature\":\"\"\n          |      }\n          |  ]\n          |}").toString())));
    }

    public static /* synthetic */ void propertiesShouldBeFiltered$(IdentityGetContract $this) {
        $this.propertiesShouldBeFiltered();
    }

    @Test
    default public void propertiesShouldBeFiltered() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null,\n         |      \"properties\": [\"id\", \"email\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(324).append("{\n          |  \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n          |  \"state\": \"").append(UuidState$.MODULE$.INSTANCE().value()).append("\",\n          |  \"list\": [\n          |      {\n          |          \"id\": \"becaf930-ea9e-3ef4-81ea-206eecb04aa7\",\n          |          \"email\": \"bob@domain.tld\"\n          |      }\n          |  ]\n          |}").toString())));
    }

    public static /* synthetic */ void badPropertiesShouldBeRejected$(IdentityGetContract $this) {
        $this.badPropertiesShouldBeRejected();
    }

    @Test
    default public void badPropertiesShouldBeRejected() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null,\n         |      \"properties\": [\"id\", \"bad\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(399).append("{\n          |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n          |    \"methodResponses\": [\n          |        [\n          |            \"error\",\n          |            {\n          |                \"type\": \"invalidArguments\",\n          |                \"description\": \"The following properties [bad] do not exist.\"\n          |            },\n          |            \"c1\"\n          |        ]\n          |    ]\n          |}").toString())));
    }

    public static /* synthetic */ void badAccountIdShouldBeRejected$(IdentityGetContract $this) {
        $this.badAccountIdShouldBeRejected();
    }

    @Test
    default public void badAccountIdShouldBeRejected() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"bad\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(308).append("{\n          |    \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n          |    \"methodResponses\": [\n          |        [\n          |            \"error\",\n          |            {\n          |                \"type\": \"accountNotFound\"\n          |            },\n          |            \"c1\"\n          |        ]\n          |    ]\n          |}").toString())));
    }

    public static /* synthetic */ void getRandomIdShouldNotFail$(IdentityGetContract $this) {
        $this.getRandomIdShouldNotFail();
    }

    @Test
    default public void getRandomIdShouldNotFail() {
        String id = UUID.randomUUID().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(339).append("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"").append(id).append("\"]\n         |    },\n         |    \"c1\"]]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(509).append("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"Identity/get\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\t\"notFound\": [\n           |\t\t\t\t\t\"").append(id).append("\"\n           |\t\t\t\t],\n           |\t\t\t\t\"state\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\t\"list\": []\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}").toString())));
    }

    public static void $init$(IdentityGetContract $this) {
    }
}

