/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.authentication.PreemptiveBasicAuthScheme;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.draft.JmapGuiceProbe;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.mime4j.dom.Message;
import scala.Predef$;
import scala.collection.StringOps$;

public final class Fixture$ {
    public static final Fixture$ MODULE$ = new Fixture$();
    private static final String ACCOUNT_ID = "29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6";
    private static final String ALICE_ACCOUNT_ID = "2bd806c97f0e00af1a1fc3328fa763a9269723c8db8fac4f93af71db186d6e90";
    private static final String ANDRE_ACCOUNT_ID = "1e8584548eca20f26faf6becc1704a0f352839f12c208a47fbd486d60f491f7c";
    private static final String DAVID_ACCOUNT_ID = "a63dc794489dca3a428ae19c0632425619aa2d8551cd8dab26f4b9a87c774342";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final Domain DOMAIN = Domain.of((String)"domain.tld");
    private static final String DOMAIN_WITH_SPACE = "dom ain.tld";
    private static final Domain _2_DOT_DOMAIN = Domain.of((String)"do.main.tld");
    private static final Username BOB = Username.fromLocalPartWithDomain((String)"bob", (Domain)MODULE$.DOMAIN());
    private static final Username ANDRE = Username.fromLocalPartWithDomain((String)"andre", (Domain)MODULE$.DOMAIN());
    private static final Username CEDRIC = Username.fromLocalPartWithDomain((String)"cedric", (Domain)MODULE$.DOMAIN());
    private static final Username DAVID = Username.fromLocalPartWithDomain((String)"david", (Domain)MODULE$.DOMAIN());
    private static final Username ALICE = Username.fromLocalPartWithDomain((String)"alice", (Domain)MODULE$._2_DOT_DOMAIN());
    private static final String DAVID_IDENTITY_ID = UUID.nameUUIDFromBytes(MODULE$.ANDRE().asString().getBytes(StandardCharsets.UTF_8)).toString();
    private static final String ANDRE_IDENTITY_ID = "1d684cf0-101b-300b-82c0-8e17f8d464bc";
    private static final String IDENTITY_ID = UUID.nameUUIDFromBytes(MODULE$.BOB().asString().getBytes(StandardCharsets.UTF_8)).toString();
    private static final String BOB_PASSWORD = "bobpassword";
    private static final String ANDRE_PASSWORD = "andrepassword";
    private static final String ALICE_PASSWORD = "alicepassword";
    private static final Header BOB_BASIC_AUTH_HEADER = new Header(MODULE$.AUTHORIZATION_HEADER(), new StringBuilder(6).append("Basic ").append(MODULE$.toBase64(new StringBuilder(1).append(MODULE$.BOB().asString()).append(":").append(MODULE$.BOB_PASSWORD()).toString())).toString());
    private static final String ECHO_REQUEST_OBJECT = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      |  \"using\": [\n      |    \"urn:ietf:params:jmap:core\"\n      |  ],\n      |  \"methodCalls\": [\n      |    [\n      |      \"Core/echo\",\n      |      {\n      |        \"arg1\": \"arg1data\",\n      |        \"arg2\": \"arg2data\"\n      |      },\n      |      \"c1\"\n      |    ]\n      |  ]\n      |}"));
    private static final String ECHO_REQUEST_OBJECT_WITHOUT_CORE_CAPABILITY = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      |  \"using\": [],\n      |  \"methodCalls\": [\n      |    [\n      |      \"Core/echo\",\n      |      {\n      |        \"arg1\": \"arg1data\",\n      |        \"arg2\": \"arg2data\"\n      |      },\n      |      \"c1\"\n      |    ]\n      |  ]\n      |}"));
    private static final String ECHO_RESPONSE_OBJECT = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(250).append("{\n      |  \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n      |  \"methodResponses\": [\n      |    [\n      |      \"Core/echo\",\n      |      {\n      |        \"arg1\": \"arg1data\",\n      |        \"arg2\": \"arg2data\"\n      |      },\n      |      \"c1\"\n      |    ]\n      |  ]\n      |}").toString()));
    private static final String ACCEPT_RFC8621_VERSION_HEADER = "application/json; jmapVersion=rfc-8621";
    private static final String RFC8621_VERSION_HEADER = "jmapVersion=rfc-8621";
    private static final Username USER = Username.fromLocalPartWithDomain((String)"user", (Domain)MODULE$.DOMAIN());
    private static final String USER_PASSWORD = "user";
    private static final String USER_TOKEN = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiJ1c2VyQGRvbWFpbi50bGQifQ.U-dUPv6OU6KO5N7CooHUfMkCdFJHx2F3H4fm7Q79g1BPfBSkifPj5xyVlZ0JwEGXypC4zBw9ay3l4DxzX7D_6p1Hx_ihXsoLx1Ca-WUo44x-XRSpPfgxiZjHCJkGBLMV3RZlAjip-d18mxkcX3JGplX_sCQkFisduAOAHuKSUg9wI6VBgUQi_0B35FYv6tP_bD6eFtvaAUN9QyXXh8UQjEp8CO12lRz6enfLx_V6BG_fEMkee6vRqdEqx_F9OF3eWTe1giMp_JhQ7_l1OXXtbd4TndVvTeuVy4irPbsRc-M8x_-qTDpFp6saRRsyOcFspxPp5n3yIhEK7B3UZiseXw";
    private static final String UNKNOWN_USER_TOKEN = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIn0.T04BTkLXkJj24coSZkK13RfG25lpvmSl2MJ7N10KpBk9_-95EGYZdog-BDAn3PJzqVw52z-Bwjh4VOj1-j7cURu0cT4jXehhUrlCxS4n7QHZDN_bsEYGu7KzjWTpTsUiHe-rN7izXVFxDGG1TGwlmBCBnPW-EFCf9ylUsJi0r2BKNdaaPRfMIrHptH1zJBkkUziWpBN1RNLjmvlAUf49t1Tbv21ZqYM5Ht2vrhJWczFbuC-TD-8zJkXhjTmA1GVgomIX5dx1cH-dZX1wANNmshUJGHgepWlPU-5VIYxPEhb219RMLJIELMY2qNOR8Q31ydinyqzXvCSzVJOf6T60-w";
    private static final String INVALID_JWT_TOKEN = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiJhZG1pbkBvcGVuthispartiscompletelywrong.reQc3DiVvbQHF08oW1qOUyDJyv3tfzDNk8jhVZequiCdOI9vXnRlOe-yDYktd4WT8MYhqY7MgS-wR0vO9jZFv8ZCgd_MkKCvCO0HmMjP5iQPZ0kqGkgWUH7X123tfR38MfbCVAdPDba-K3MfkogV1xvDhlkPScFr_6MxExtedOK2JnQZn7t9sUzSrcyjWverm7gZkPptkIVoS8TsEeMMME5vFXe_nqkEG69q3kuBUm_33tbR5oNS0ZGZKlG9r41lHBjyf9J1xN4UYV8n866da7RPPCzshIWUtO0q9T2umWTnp-6OnOdBCkndrZmRR6pPxsD5YL0_77Wq8KT_5__fGA";
    private static final String GET_ALL_MAILBOXES_REQUEST = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      |  \"using\": [\n      |    \"urn:ietf:params:jmap:core\",\n      |    \"urn:ietf:params:jmap:mail\"],\n      |  \"methodCalls\": [[\n      |      \"Mailbox/get\",\n      |      {\n      |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n      |        \"ids\": null\n      |      },\n      |      \"c1\"]]\n      |}"));

    public String ACCOUNT_ID() {
        return ACCOUNT_ID;
    }

    public String ALICE_ACCOUNT_ID() {
        return ALICE_ACCOUNT_ID;
    }

    public String ANDRE_ACCOUNT_ID() {
        return ANDRE_ACCOUNT_ID;
    }

    public String DAVID_ACCOUNT_ID() {
        return DAVID_ACCOUNT_ID;
    }

    public Message createTestMessage() {
        return Message.Builder.of().setSubject("test").setSender(this.ANDRE().asString()).setFrom(this.ANDRE().asString()).setSubject("World domination \r\n and this is also part of the header").setBody("testmail", StandardCharsets.UTF_8).build();
    }

    public RequestSpecBuilder baseRequestSpecBuilder(GuiceJamesServer server) {
        return new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).setPort(((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue()).setBasePath("/jmap");
    }

    public PreemptiveBasicAuthScheme authScheme(UserCredential userCredential) {
        PreemptiveBasicAuthScheme authScheme = new PreemptiveBasicAuthScheme();
        authScheme.setUserName(userCredential.username().asString());
        authScheme.setPassword(userCredential.password());
        return authScheme;
    }

    public String toBase64(String stringValue) {
        return Base64.getEncoder().encodeToString(stringValue.getBytes(StandardCharsets.UTF_8));
    }

    public Headers getHeadersWith(Header authHeader) {
        return new Headers(new Header[]{new Header(HttpHeaderNames.ACCEPT.toString(), this.ACCEPT_RFC8621_VERSION_HEADER()), authHeader});
    }

    public String AUTHORIZATION_HEADER() {
        return AUTHORIZATION_HEADER;
    }

    public Domain DOMAIN() {
        return DOMAIN;
    }

    public String DOMAIN_WITH_SPACE() {
        return DOMAIN_WITH_SPACE;
    }

    public Domain _2_DOT_DOMAIN() {
        return _2_DOT_DOMAIN;
    }

    public Username BOB() {
        return BOB;
    }

    public Username ANDRE() {
        return ANDRE;
    }

    public Username CEDRIC() {
        return CEDRIC;
    }

    public Username DAVID() {
        return DAVID;
    }

    public Username ALICE() {
        return ALICE;
    }

    public String DAVID_IDENTITY_ID() {
        return DAVID_IDENTITY_ID;
    }

    public String ANDRE_IDENTITY_ID() {
        return ANDRE_IDENTITY_ID;
    }

    public String IDENTITY_ID() {
        return IDENTITY_ID;
    }

    public String BOB_PASSWORD() {
        return BOB_PASSWORD;
    }

    public String ANDRE_PASSWORD() {
        return ANDRE_PASSWORD;
    }

    public String ALICE_PASSWORD() {
        return ALICE_PASSWORD;
    }

    public Header BOB_BASIC_AUTH_HEADER() {
        return BOB_BASIC_AUTH_HEADER;
    }

    public String ECHO_REQUEST_OBJECT() {
        return ECHO_REQUEST_OBJECT;
    }

    public String ECHO_REQUEST_OBJECT_WITHOUT_CORE_CAPABILITY() {
        return ECHO_REQUEST_OBJECT_WITHOUT_CORE_CAPABILITY;
    }

    public String ECHO_RESPONSE_OBJECT() {
        return ECHO_RESPONSE_OBJECT;
    }

    public String ACCEPT_RFC8621_VERSION_HEADER() {
        return ACCEPT_RFC8621_VERSION_HEADER;
    }

    public String RFC8621_VERSION_HEADER() {
        return RFC8621_VERSION_HEADER;
    }

    public Username USER() {
        return USER;
    }

    public String USER_PASSWORD() {
        return USER_PASSWORD;
    }

    public String USER_TOKEN() {
        return USER_TOKEN;
    }

    public String UNKNOWN_USER_TOKEN() {
        return UNKNOWN_USER_TOKEN;
    }

    public String INVALID_JWT_TOKEN() {
        return INVALID_JWT_TOKEN;
    }

    public String GET_ALL_MAILBOXES_REQUEST() {
        return GET_ALL_MAILBOXES_REQUEST;
    }

    private Fixture$() {
    }
}

