/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.QuotaProbesImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsLookupResult;
import play.api.libs.json.JsLookupResult$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005mbaB\u000b\u0017!\u0003\r\ta\t\u0005\u0006U\u0001!\ta\u000b\u0005\t_\u0001A)\u0019!C\u0005a!)1\b\u0001C\u0001y!)a\n\u0001D\u0001\u001f\")\u0001\f\u0001D\u00013\")Q\f\u0001C\u0001W!)!\r\u0001C\u0001W!)A\r\u0001C\u0001K\")\u0001\u000e\u0001C\u0001S\")A\u000e\u0001C\u0001[\")\u0001\u000f\u0001C\u0001c\")A\u000f\u0001C\u0001k\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aa!a\t\u0001\t\u0003Y\u0003BBA\u0014\u0001\u0011\u00051\u0006C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\t\u0019R)\\1jY&k\u0007o\u001c:u\u0007>tGO]1di*\u0011q\u0003G\u0001\tG>tGO]1di*\u0011\u0011DG\u0001\be\u001a\u001c\u0007H\u000e\u001a2\u0015\tYB$\u0001\u0003k[\u0006\u0004(BA\u000f\u001f\u0003\u0015Q\u0017-\\3t\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005a\u0003CA\u0013.\u0013\tqcE\u0001\u0003V]&$\u0018aD+U\u0007~#\u0015\tV#`\r>\u0013V*\u0011+\u0016\u0003E\u0002\"AM\u001d\u000e\u0003MR!\u0001N\u001b\u0002\r\u0019|'/\\1u\u0015\t1t'\u0001\u0003uS6,'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uM\u0012\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0003\u0015\u0019X\r^+q)\taS\bC\u0003?\u0007\u0001\u0007q(\u0001\u0004tKJ4XM\u001d\t\u0003\u0001\u0006k\u0011\u0001H\u0005\u0003\u0005r\u0011\u0001cR;jG\u0016T\u0015-\\3t'\u0016\u0014h/\u001a:)\u0005\r!\u0005CA#M\u001b\u00051%BA$I\u0003\r\t\u0007/\u001b\u0006\u0003\u0013*\u000bqA[;qSR,'O\u0003\u0002LA\u0005)!.\u001e8ji&\u0011QJ\u0012\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017a\u0004:b]\u0012|W.T3tg\u0006<W-\u00133\u0016\u0003A\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u000b5|G-\u001a7\u000b\u0005Uc\u0012aB7bS2\u0014w\u000e_\u0005\u0003/J\u0013\u0011\"T3tg\u0006<W-\u00133\u0002\u001fI\fg\u000eZ8n\u001b\u0006LGNY8y\u0013\u0012,\u0012A\u0017\t\u0003#nK!\u0001\u0018*\u0003\u00135\u000b\u0017\u000e\u001c2pq&#\u0017\u0001O5na>\u0014Ho\u00155pk2$'+\u001a;ve:,fn\u001b8po:lU\r\u001e5pI^CWM\\'jgNLgnZ\"pe\u0016\u001c\u0015\r]1cS2LG/\u001f\u0015\u0003\r}\u0003\"!\u00121\n\u0005\u00054%\u0001\u0002+fgR\f\u0001([7q_J$8\u000b[8vY\u0012\u0014V\r^;s]Vs7N\\8x]6+G\u000f[8e/\",g.T5tg&tw-T1jY\u000e\u000b\u0007/\u00192jY&$\u0018\u0010\u000b\u0002\b?\u0006\u0011\u0013.\u001c9peR\u001c\u0006n\\;mI\u0006#G\r\u00165f\u001b\u0006LG.\u00138UQ\u0016l\u0015-\u001b7c_b$\"\u0001\f4\t\u000byB\u0001\u0019A )\u0005!y\u0016!G5na>\u0014Ho\u00155pk2$WI\u001c4pe\u000e,\u0017+^8uCN$\"\u0001\f6\t\u000byJ\u0001\u0019A )\u0005%y\u0016aI5na>\u0014Ho\u00155pk2$\u0017\t\u001a3UQ\u0016l\u0015-\u001b7t\u0013:$\u0006.Z'bS2\u0014w\u000e\u001f\u000b\u0003Y9DQA\u0010\u0006A\u0002}B#AC0\u0002C%l\u0007o\u001c:u'\"|W\u000f\u001c3ESN\u0004H.Y=PY\u0012\fe\u000e\u001a(foN#\u0018\r^3\u0015\u00051\u0012\b\"\u0002 \f\u0001\u0004y\u0004FA\u0006`\u0003I\u0011X\r\u001e:jKZ,W)\\1jYN#\u0018\r^3\u0016\u0003Y\u0004\"a\u001e@\u000f\u0005ad\bCA='\u001b\u0005Q(BA>#\u0003\u0019a$o\\8u}%\u0011QPJ\u0001\u0007!J,G-\u001a4\n\u0007}\f\tA\u0001\u0004TiJLgn\u001a\u0006\u0003{\u001a\n1%[7q_J$8\u000b[8vY\u00124\u0015-\u001b7XQ\u0016tW*Y5mE>Dhj\u001c;Po:,G\rF\u0002-\u0003\u000fAQAP\u0007A\u0002}B#!D0\u0002O%l\u0007o\u001c:u'\"|W\u000f\u001c3Tk\u000e\u001cW-\u001a3XQ\u0016tW*Y5mE>DH)\u001a7fO\u0006$X\r\u001a\u000b\u0004Y\u0005=\u0001\"\u0002 \u000f\u0001\u0004y\u0004F\u0001\b`\u0003\u0001JW\u000e]8siNCw.\u001e7e\r\u0006LGn\u00165f]\ncwN\u0019(pi>;h.\u001a3\u0015\u00071\n9\u0002C\u0003?\u001f\u0001\u0007q\b\u000b\u0002\u0010?\u0006!\u0013.\u001c9peR\u001c\u0006n\\;mIN+8mY3fI^CWM\u001c\"m_\n$U\r\\3hCR,G\rF\u0002-\u0003?AQA\u0010\tA\u0002}B#\u0001E0\u0002?%l\u0007o\u001c:u'\"|W\u000f\u001c3GC&dw\u000b[3o\u001d>l\u0015-\u001b7c_b,7\u000f\u000b\u0002\u0012?\u0006!\u0013.\u001c9peR\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\\,iK:$vn\\'b]fl\u0015-\u001b7c_b,7\u000f\u000b\u0002\u0013?\u0006\u0001\u0013.\u001c9peR\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\\,iK:\u0014En\u001c2O_R4u.\u001e8e)\ra\u0013q\u0006\u0005\u0006}M\u0001\ra\u0010\u0015\u0003'}\u000bA%[7q_J$8\u000b[8vY\u00124\u0015-\u001b7XQ\u0016t\u0017J\u001c<bY&$\u0017iY2pk:$\u0018\n\u001a\u000b\u0004Y\u0005]\u0002\"\u0002 \u0015\u0001\u0004y\u0004F\u0001\u000b`\u0001")
public interface EmailImportContract {
    public static /* synthetic */ DateTimeFormatter org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT$(EmailImportContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT();
    }

    default public DateTimeFormatter org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssX");
    }

    public static /* synthetic */ void setUp$(EmailImportContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public MessageId randomMessageId();

    public MailboxId randomMailboxId();

    public static /* synthetic */ void importShouldReturnUnknownMethodWhenMissingCoreCapability$(EmailImportContract $this) {
        $this.importShouldReturnUnknownMethodWhenMissingCoreCapability();
    }

    @Test
    default public void importShouldReturnUnknownMethodWhenMissingCoreCapability() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\n              |      \"Email/import\",\n              |      {\n              |        \"arg1\": \"arg1data\",\n              |        \"arg2\": \"arg2data\"\n              |      },\n              |      \"c1\"\n              |    ]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(281).append("{\n         |  \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:core\"\n         |    },\n         |    \"c1\"]]\n         |}").toString())));
    }

    public static /* synthetic */ void importShouldReturnUnknownMethodWhenMissingMailCapability$(EmailImportContract $this) {
        $this.importShouldReturnUnknownMethodWhenMissingMailCapability();
    }

    @Test
    default public void importShouldReturnUnknownMethodWhenMissingMailCapability() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\"],\n              |  \"methodCalls\": [\n              |    [\n              |      \"Email/import\",\n              |      {\n              |        \"arg1\": \"arg1data\",\n              |        \"arg2\": \"arg2data\"\n              |      },\n              |      \"c1\"\n              |    ]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(281).append("{\n         |  \"sessionState\": \"").append(ResponseObject$.MODULE$.SESSION_STATE().value()).append("\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:mail\"\n         |    },\n         |    \"c1\"]]\n         |}").toString())));
    }

    public static /* synthetic */ void importShouldAddTheMailInTheMailbox$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldAddTheMailInTheMailbox(server);
    }

    @Test
    default public void importShouldAddTheMailInTheMailbox(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1104).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(mailboxId.serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"],\n              |    [\"Email/get\",\n              |     {\n              |       \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |       \"ids\": [\"#C42\"],\n              |       \"properties\": [\"keywords\", \"mailboxIds\", \"receivedAt\", \"subject\", \"size\", \"bodyValues\", \"htmlBody\"],\n              |       \"fetchHTMLBodyValues\": true\n              |     },\n              |     \"c2\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsLookupResult responseAsJson = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42");
        String messageId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(responseAsJson), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(2118).append("    [\n         |        [\"Email/import\",\n         |            {\n         |                \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n         |                \"created\": {\n         |                    \"C42\": {\n         |                        \"id\": \"").append(messageId).append("\",\n         |                        \"blobId\": \"").append(messageId).append("\",\n         |                        \"threadId\": \"").append(messageId).append("\",\n         |                        \"size\": 836\n         |                    }\n         |                }\n         |            }, \"c1\"],\n         |        [\"Email/get\",\n         |            {\n         |                \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n         |                \"notFound\": [],\n         |                \"list\": [\n         |                    {\n         |                        \"id\": \"").append(messageId).append("\",\n         |                        \"htmlBody\": [\n         |                            {\n         |                                \"charset\": \"utf-8\",\n         |                                \"size\": 39,\n         |                                \"partId\": \"2\",\n         |                                \"blobId\": \"").append(messageId).append("_2\",\n         |                                \"type\": \"text/html\"\n         |                            }\n         |                        ],\n         |                        \"size\": 836,\n         |                        \"keywords\": {\n         |                            \"toto\": true\n         |                        },\n         |                        \"subject\": \"MultiAttachment\",\n         |                        \"mailboxIds\": {\n         |                            \"").append(mailboxId.serialize()).append("\": true\n         |                        },\n         |                        \"receivedAt\": \"").append(receivedAtString).append("\",\n         |                        \"bodyValues\": {\n         |                            \"2\": {\n         |                                \"value\": \"<p>Send<br/>concerted from html</p>\\r\\n\\r\\n\",\n         |                                \"isEncodingProblem\": false,\n         |                                \"isTruncated\": false\n         |                            }\n         |                        }\n         |                    }\n         |                ]\n         |            }, \"c2\"]\n         |    ]").toString())));
    }

    public static /* synthetic */ void importShouldEnforceQuotas$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldEnforceQuotas(server);
    }

    @Test
    default public void importShouldEnforceQuotas(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        quotaProbe.setMaxMessageCount(quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB())), QuotaCountLimit.count((long)0L));
        MailboxId id1 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(670).append("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:apache:james:params:jmap:mail:shares\"],\n         |  \"methodCalls\": [[\"Email/import\", {\n         |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n         |        \"emails\": {\n         |           \"C42\": {\n         |             \"blobId\": \"").append(blobId).append("\",\n         |             \"mailboxIds\": {\n         |               \"").append(id1.serialize()).append("\": true\n         |             },\n         |             \"keywords\": {\n         |               \"toto\": true\n         |             },\n         |             \"receivedAt\": \"").append(receivedAtString).append("\"\n         |           }\n         |         }\n         |      }, \"c1\"]]\n         |}").toString()));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState", "methodResponses[0][1].oldState"}).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\"Email/import\", {\n           |\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\"notCreated\": {\n           |\t\t\t\t\"C42\": {\n           |\t\t\t\t\t\"type\": \"overQuota\",\n           |\t\t\t\t\t\"description\": \"You have too many messages in #private&bob@domain.tld\"\n           |\t\t\t\t}\n           |\t\t\t}\n           |\t\t}, \"c1\"]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void importShouldAddTheMailsInTheMailbox$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldAddTheMailsInTheMailbox(server);
    }

    @Test
    default public void importShouldAddTheMailsInTheMailbox(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse1 = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String uploadResponse2 = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/html.eml")).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId1 = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse1)), "blobId").get()).value();
        String blobId2 = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse2)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1419).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId1).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(mailboxId.serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           },\n              |           \"C43\": {\n              |             \"blobId\": \"").append(blobId2).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(mailboxId.serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"],\n              |    [\"Email/get\",\n              |     {\n              |       \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |       \"ids\": [\"#C42\", \"#C43\"],\n              |       \"properties\": [\"subject\"],\n              |       \"fetchHTMLBodyValues\": true\n              |     },\n              |     \"c2\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String messageId1 = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42")), "id").get()).value();
        String messageId2 = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C43")), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1445).append("[\n         |        [\n         |            \"Email/import\",\n         |            {\n         |                \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n         |                \"created\": {\n         |                    \"C42\": {\n         |                        \"id\": \"").append(messageId1).append("\",\n         |                        \"blobId\": \"").append(messageId1).append("\",\n         |                        \"threadId\": \"").append(messageId1).append("\",\n         |                        \"size\": 836\n         |                    },\n         |                    \"C43\": {\n         |                        \"id\": \"").append(messageId2).append("\",\n         |                        \"blobId\": \"").append(messageId2).append("\",\n         |                        \"threadId\": \"").append(messageId1).append("\",\n         |                        \"size\": 2727\n         |                    }\n         |                }\n         |            },\n         |            \"c1\"\n         |        ],\n         |        [\n         |            \"Email/get\",\n         |            {\n         |                \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n         |                \"notFound\": [],\n         |                \"list\": [\n         |                    {\n         |                        \"subject\": \"MultiAttachment\",\n         |                        \"id\": \"").append(messageId1).append("\"\n         |                    },\n         |                    {\n         |                        \"subject\": \"MultiAttachment\",\n         |                        \"id\": \"").append(messageId2).append("\"\n         |                    }\n         |                ]\n         |            },\n         |            \"c2\"\n         |        ]\n         |    ]").toString())));
    }

    public static /* synthetic */ void importShouldDisplayOldAndNewState$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldDisplayOldAndNewState(server);
    }

    @Test
    default public void importShouldDisplayOldAndNewState(GuiceJamesServer server) {
        String oldState = this.retrieveEmailState();
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(748).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(mailboxId.serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String newState = this.retrieveEmailState();
        String importOldState = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "oldState").get()).value();
        String importNewState = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "newState").get()).value();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(importOldState).isEqualTo(oldState);
            softly.assertThat(importNewState).isEqualTo(newState);
        });
    }

    public static /* synthetic */ String retrieveEmailState$(EmailImportContract $this) {
        return $this.retrieveEmailState();
    }

    default public String retrieveEmailState() {
        return (String)((Validatable)RestAssured.with().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |  \"urn:ietf:params:jmap:core\",\n         |  \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |    [\"Email/get\", {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\":[]\n         |    }, \"c1\"]\n         |  ]\n         |}"))).post()).then().extract().jsonPath().get("methodResponses[0][1].state");
    }

    public static /* synthetic */ void importShouldFailWhenMailboxNotOwned$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldFailWhenMailboxNotOwned(server);
    }

    @Test
    default public void importShouldFailWhenMailboxNotOwned(GuiceJamesServer server) {
        MailboxPath alicePath = MailboxPath.inbox((Username)Fixture$.MODULE$.ALICE());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(alicePath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body("whatever").when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(748).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(mailboxId.serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(389).append("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |    \"notCreated\":{\n           |      \"C42\":{\n           |        \"type\":\"notFound\",\n           |        \"description\":\"Mailbox ").append(mailboxId).append(" can not be found\"\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]").toString())));
    }

    public static /* synthetic */ void importShouldSucceedWhenMailboxDelegated$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldSucceedWhenMailboxDelegated(server);
    }

    @Test
    default public void importShouldSucceedWhenMailboxDelegated(GuiceJamesServer server) {
        MailboxPath andrePath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andrePath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andrePath, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Insert, MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(748).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(mailboxId.serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsLookupResult responseAsJson = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42");
        String messageId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(responseAsJson), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(349).append("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n           |    \"created\":{\n           |      \"C42\":{\n           |        \"id\":\"").append(messageId).append("\",\n           |        \"blobId\":\"").append(messageId).append("\",\n           |        \"threadId\":\"").append(messageId).append("\",\n           |        \"size\":836\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]").toString())));
    }

    public static /* synthetic */ void importShouldFailWhenBlobNotOwned$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldFailWhenBlobNotOwned(server);
    }

    @Test
    default public void importShouldFailWhenBlobNotOwned(GuiceJamesServer server) {
        MailboxPath andrePath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andrePath);
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId bobId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), andrePath, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        String blobId = messageId.serialize();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(748).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(bobId.serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(396).append("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |    \"notCreated\":{\n           |      \"C42\":{\n           |        \"type\":\"notFound\",\n           |        \"description\":\"Blob BlobId(").append(blobId).append(") could not be found\"\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]").toString())));
    }

    public static /* synthetic */ void importShouldSucceedWhenBlobDelegated$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldSucceedWhenBlobDelegated(server);
    }

    @Test
    default public void importShouldSucceedWhenBlobDelegated(GuiceJamesServer server) {
        MailboxPath andrePath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andrePath);
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId bobId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        String blobId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), andrePath, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andrePath, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Insert, MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(748).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(bobId.serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsLookupResult responseAsJson = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42");
        String messageId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(responseAsJson), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(348).append("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n           |    \"created\":{\n           |      \"C42\":{\n           |        \"id\":\"").append(messageId).append("\",\n           |        \"blobId\":\"").append(messageId).append("\",\n           |        \"threadId\":\"").append(messageId).append("\",\n           |        \"size\":85\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]").toString())));
    }

    public static /* synthetic */ void importShouldFailWhenNoMailboxes$(EmailImportContract $this) {
        $this.importShouldFailWhenNoMailboxes();
    }

    @Test
    default public void importShouldFailWhenNoMailboxes() {
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body("whatever").when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(680).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId).append("\",\n              |             \"mailboxIds\": {},\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |    \"notCreated\":{\n           |      \"C42\":{\n           |        \"type\":\"invalidArguments\",\n           |        \"description\":\"Email/import so far only supports a single mailboxId\"\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void importShouldFailWhenTooManyMailboxes$(EmailImportContract $this) {
        $this.importShouldFailWhenTooManyMailboxes();
    }

    @Test
    default public void importShouldFailWhenTooManyMailboxes() {
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body("whatever").when().post(new StringBuilder(8).append("/upload/").append(Fixture$.MODULE$.ACCOUNT_ID()).toString(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(788).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(this.randomMailboxId().serialize()).append("\": true,\n              |               \"").append(this.randomMailboxId().serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |    \"notCreated\":{\n           |      \"C42\":{\n           |        \"type\":\"invalidArguments\",\n           |        \"description\":\"Email/import so far only supports a single mailboxId\"\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void importShouldFailWhenBlobNotFound$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldFailWhenBlobNotFound(server);
    }

    @Test
    default public void importShouldFailWhenBlobNotFound(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String blobId = this.randomMessageId().serialize();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(748).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(mailboxId.serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState"}).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(236).append("{\n           |  \"accountId\":\"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n           |  \"notCreated\":{\n           |    \"C42\":{\n           |      \"type\":\"notFound\",\n           |      \"description\":\"Blob BlobId(").append(blobId).append(") could not be found\"\n           |    }\n           |  }\n           |}").toString())));
    }

    public static /* synthetic */ void importShouldFailWhenInvalidAccountId$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldFailWhenInvalidAccountId(server);
    }

    @Test
    default public void importShouldFailWhenInvalidAccountId(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String blobId = this.randomMessageId().serialize();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(751).append("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"bad\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"").append(blobId).append("\",\n              |             \"mailboxIds\": {\n              |               \"").append(mailboxId.serialize()).append("\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"").append(receivedAtString).append("\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)"[\"error\",{\"type\":\"accountNotFound\"},\"c1\"]");
    }

    public static void $init$(EmailImportContract $this) {
    }
}

