/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.response.Validatable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.mail.internet.SharedInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.DownloadContract$;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005mt!\u0002\u0010 \u0011\u0003ac!\u0002\u0018 \u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004b\u0002\u001d\u0002\u0005\u0004%\t!\u000f\u0005\u0007\u0005\u0006\u0001\u000b\u0011\u0002\u001e\u0007\u000f9z\u0002\u0013aA\u0001\u0007\")A)\u0002C\u0001\u000b\")\u0011*\u0002C\u0001\u0015\")A,\u0002D\u0001;\")a-\u0002C\u0001O\")Q.\u0002C\u0001]\")\u0011/\u0002C\u0001e\")Q/\u0002C\u0001m\")\u00110\u0002C\u0001u\")Q0\u0002C\u0001}\"9\u00111A\u0003\u0005\u0002\u0005\u0015\u0001bBA\u0006\u000b\u0011\u0005\u0011Q\u0002\u0005\b\u0003')A\u0011AA\u000b\u0011\u001d\tY\"\u0002C\u0001\u0003;Aq!a\t\u0006\t\u0003\t)\u0003C\u0004\u0002,\u0015!\t!!\f\t\u000f\u0005MR\u0001\"\u0001\u00026!9\u00111H\u0003\u0005\u0002\u0005u\u0002bBA\"\u000b\u0011\u0005\u0011Q\t\u0005\b\u0003\u0017*A\u0011AA'\u0011\u001d\t\u0019&\u0002C\u0001\u0003+Bq!a\u0017\u0006\t\u0003\ti\u0006C\u0004\u0002d\u0015!\t!!\u001a\t\u000f\u0005-T\u0001\"\u0001\u0002n!9\u00111O\u0003\u0005\u0002\u0005U\u0014\u0001\u0005#po:dw.\u00193D_:$(/Y2u\u0015\t\u0001\u0013%\u0001\u0005d_:$(/Y2u\u0015\t\u00113%A\u0004sM\u000eDdGM\u0019\u000b\u0005\u0011*\u0013\u0001\u00026nCBT!AJ\u0014\u0002\u000b)\fW.Z:\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001!\ti\u0013!D\u0001 \u0005A!un\u001e8m_\u0006$7i\u001c8ue\u0006\u001cGo\u0005\u0002\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0017\u0002\u0013\u0005\u001c7m\\;oi&#W#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014\u0001\u00027b]\u001eT\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\t11\u000b\u001e:j]\u001e\f!\"Y2d_VtG/\u00133!'\t)\u0001'\u0001\u0004%S:LG\u000f\n\u000b\u0002\rB\u0011\u0011gR\u0005\u0003\u0011J\u0012A!\u00168ji\u0006)1/\u001a;VaR\u0011ai\u0013\u0005\u0006\u0019\u001e\u0001\r!T\u0001\u0007g\u0016\u0014h/\u001a:\u0011\u00059{U\"A\u0013\n\u0005A+#\u0001E$vS\u000e,'*Y7fgN+'O^3sQ\t9!\u000b\u0005\u0002T56\tAK\u0003\u0002V-\u0006\u0019\u0011\r]5\u000b\u0005]C\u0016a\u00026va&$XM\u001d\u0006\u00033&\nQA[;oSRL!a\u0017+\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\bsC:$w.\\'fgN\fw-Z%e+\u0005q\u0006CA0e\u001b\u0005\u0001'BA1c\u0003\u0015iw\u000eZ3m\u0015\t\u0019W%A\u0004nC&d'm\u001c=\n\u0005\u0015\u0004'!C'fgN\fw-Z%e\u0003=!wn\u001e8m_\u0006$W*Z:tC\u001e,GC\u0001$i\u0011\u0015a\u0015\u00021\u0001NQ\tI!\u000e\u0005\u0002TW&\u0011A\u000e\u0016\u0002\u0005)\u0016\u001cH/A\u0016e_^tGn\\1e\u001b\u0016\u001c8/Y4f'\"|W\u000f\u001c3GC&dw\u000b[3o+:\fW\u000f\u001e5f]RLg-[3e)\t1u\u000eC\u0003M\u0015\u0001\u0007Q\n\u000b\u0002\u000bU\u0006ICm\\<oY>\fG-T3tg\u0006<Wm\u00155pk2$7+^2dK\u0016$w\u000b[3o\t\u0016dWmZ1uK\u0012$\"AR:\t\u000b1[\u0001\u0019A')\u0005-Q\u0017a\n3po:dw.\u00193j]\u001e|E\u000f[3s!\u0016|\u0007\u000f\\3NKN\u001c\u0018mZ3TQ>,H\u000e\u001a$bS2$\"AR<\t\u000b1c\u0001\u0019A')\u00051Q\u0017\u0001\n3po:dw.\u00193j]\u001eLen\u0014;iKJ\f5mY8v]R\u001c8\u000b[8vY\u00124\u0015-\u001b7\u0015\u0005\u0019[\b\"\u0002'\u000e\u0001\u0004i\u0005FA\u0007k\u0003\u0019\"wn\u001e8m_\u0006$\u0007+\u0019:u'\"|W\u000f\u001c3Tk\u000e\u001cW-\u001a3XQ\u0016tG)\u001a7fO\u0006$X\r\u001a\u000b\u0003\r~DQ\u0001\u0014\bA\u00025C#A\u00046\u0002W\u0011|wO\u001c7pC\u0012LgnZ(uQ\u0016\u0014\b+Z8qY\u0016lUm]:bO\u0016\u0004\u0016M\u001d;TQ>,H\u000e\u001a$bS2$2ARA\u0004\u0011\u0015au\u00021\u0001NQ\ty!.\u0001\u0007e_^tGn\\1e!\u0006\u0014H\u000fF\u0002G\u0003\u001fAQ\u0001\u0014\tA\u00025C#\u0001\u00056\u0002_U\u001cXM]\"b]N\u0003XmY5gs\u000e{g\u000e^3oiRK\b/Z,iK:$un\u001e8m_\u0006$\u0017N\\4NKN\u001c\u0018mZ3\u0015\u0007\u0019\u000b9\u0002C\u0003M#\u0001\u0007Q\n\u000b\u0002\u0012U\u0006aSo]3s\u0007\u0006t7\u000b]3dS\u001aL8i\u001c8uK:$H+\u001f9f/\",g\u000eR8x]2|\u0017\rZ5oOB\u000b'\u000f\u001e\u000b\u0004\r\u0006}\u0001\"\u0002'\u0013\u0001\u0004i\u0005F\u0001\nk\u0003]\"wn\u001e8m_\u0006$\u0007+\u0019:u'\"|W\u000f\u001c3ESN\u001c\u0017M\u001d3OC6,w\u000b[3o\u001d>$8+\u001e9qY&,GMQ=UQ\u0016\u001cE.[3oiR\u0019a)a\n\t\u000b1\u001b\u0002\u0019A')\u0005MQ\u0017!J;tKJ\u001c\u0015M\\*qK\u000eLg-\u001f(b[\u0016<\u0006.\u001a8E_^tGn\\1eS:<\u0007+\u0019:u)\r1\u0015q\u0006\u0005\u0006\u0019R\u0001\r!\u0014\u0015\u0003))\f!\bZ8x]2|\u0017\rZ'fgN\fw-Z*i_VdG\rR5tG\u0006\u0014HMT1nK^CWM\u001c(piN+\b\u000f\u001d7jK\u0012\u0014\u0015\u0010\u00165f\u00072LWM\u001c;\u0015\u0007\u0019\u000b9\u0004C\u0003M+\u0001\u0007Q\n\u000b\u0002\u0016U\u0006ASo]3s\u0007\u0006t7\u000b]3dS\u001aLh*Y7f/\",g\u000eR8x]2|\u0017\rZ5oO6+7o]1hKR\u0019a)a\u0010\t\u000b13\u0002\u0019A')\u0005YQ\u0017a\u00063po:dw.\u00193O_R,\u00050[:uS:<\u0007+\u0019:u)\r1\u0015q\t\u0005\u0006\u0019^\u0001\r!\u0014\u0015\u0003/)\f1\u0003Z8x]2|\u0017\rZ%om\u0006d\u0017\u000e\u001a)beR$2ARA(\u0011\u0015a\u0005\u00041\u0001NQ\tA\".A\u000be_^tGn\\1e/&$\b.\u00138wC2LG-\u00133\u0015\u0007\u0019\u000b9\u0006C\u0003M3\u0001\u0007Q\n\u000b\u0002\u001aU\u00061Bm\\<oY>\fGmV5uQ:{GOR8v]\u0012LE\rF\u0002G\u0003?BQ\u0001\u0014\u000eA\u00025C#A\u00076\u0002?\u0011|wO\u001c7pC\u0012\u0004\u0016M\u001d;XQ\u0016tW*Z:tC\u001e,gj\u001c;G_VtG\rF\u0002G\u0003OBQ\u0001T\u000eA\u00025C#a\u00076\u00023\u0011|wO\u001c7pC\u0012\u0004\u0016M\u001d;XQ\u0016tW*\u001e7uSB\f'\u000f\u001e\u000b\u0004\r\u0006=\u0004\"\u0002'\u001d\u0001\u0004i\u0005F\u0001\u000fk\u0003\u0005\"wn\u001e8m_\u0006$\u0007+\u0019:u/\",g\u000eV8p\u001bV\u001c\u0007.\u00168eKJ\u001c8m\u001c:f)\r1\u0015q\u000f\u0005\u0006\u0019v\u0001\r!\u0014\u0015\u0003;)\u0004")
public interface DownloadContract {
    public static String accountId() {
        return DownloadContract$.MODULE$.accountId();
    }

    public static /* synthetic */ void setUp$(DownloadContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public MessageId randomMessageId();

    public static /* synthetic */ void downloadMessage$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessage(server);
    }

    @Test
    default public void downloadMessage(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(11).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).toString(), new Object[0])).then().statusCode(200).contentType("message/rfc822").extract().body().asString();
        String expectedResponse = IOUtils.toString((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadMessageShouldFailWhenUnauthentified$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldFailWhenUnauthentified(server);
    }

    @Test
    default public void downloadMessageShouldFailWhenUnauthentified(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().auth().none().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(11).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).toString(), new Object[0])).then().statusCode(401).header("WWW-Authenticate", "Basic realm=\"simple\", Bearer realm=\"JWT\"").body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"No valid authentication methods provided"), new Object[0]);
    }

    public static /* synthetic */ void downloadMessageShouldSucceedWhenDelegated$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldSucceedWhenDelegated(server);
    }

    @Test
    default public void downloadMessageShouldSucceedWhenDelegated(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read, MailboxACL.Right.Lookup}));
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(11).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).toString(), new Object[0])).then().statusCode(200).contentType("message/rfc822").extract().body().asString();
        String expectedResponse = IOUtils.toString((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadingOtherPeopleMessageShouldFail$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadingOtherPeopleMessageShouldFail(server);
    }

    @Test
    default public void downloadingOtherPeopleMessageShouldFail(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(11).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).toString(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadingInOtherAccountsShouldFail$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadingInOtherAccountsShouldFail(server);
    }

    @Test
    default public void downloadingInOtherAccountsShouldFail(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(11).append("/download/").append(Fixture$.MODULE$.ALICE_ACCOUNT_ID()).append("/").append(messageId.serialize()).toString(), new Object[0])).then().statusCode(403).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)403)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"You cannot download in others accounts"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartShouldSucceedWhenDelegated$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartShouldSucceedWhenDelegated(server);
    }

    @Test
    default public void downloadPartShouldSucceedWhenDelegated(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read, MailboxACL.Right.Lookup}));
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(13).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).append("_3").toString(), new Object[0])).then().statusCode(200).contentType("text/plain").extract().body().asString();
        String expectedResponse = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("-----BEGIN RSA PRIVATE KEY-----\n        |MIIEogIBAAKCAQEAx7PG0+E//EMpm7IgI5Q9TMDSFya/1hE+vvTJrk0iGFllPeHL\n        |A5/VlTM0YWgG6X50qiMfE3VLazf2c19iXrT0mq/21PZ1wFnogv4zxUNaih+Bng62\n        |F0SyruE/O/Njqxh/Ccq6K/e05TV4T643USxAeG0KppmYW9x8HA/GvV832apZuxkV\n        |i6NVkDBrfzaUCwu4zH+HwOv/pI87E7KccHYC++Biaj3\n        |"));
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadingOtherPeopleMessagePartShouldFail$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadingOtherPeopleMessagePartShouldFail(server);
    }

    @Test
    default public void downloadingOtherPeopleMessagePartShouldFail(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(13).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).append("_3").toString(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPart(server);
    }

    @Test
    default public void downloadPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(13).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).append("_3").toString(), new Object[0])).then().statusCode(200).contentType("text/plain").extract().body().asString();
        String expectedResponse = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("-----BEGIN RSA PRIVATE KEY-----\n        |MIIEogIBAAKCAQEAx7PG0+E//EMpm7IgI5Q9TMDSFya/1hE+vvTJrk0iGFllPeHL\n        |A5/VlTM0YWgG6X50qiMfE3VLazf2c19iXrT0mq/21PZ1wFnogv4zxUNaih+Bng62\n        |F0SyruE/O/Njqxh/Ccq6K/e05TV4T643USxAeG0KppmYW9x8HA/GvV832apZuxkV\n        |i6NVkDBrfzaUCwu4zH+HwOv/pI87E7KccHYC++Biaj3\n        |"));
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void userCanSpecifyContentTypeWhenDownloadingMessage$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyContentTypeWhenDownloadingMessage(server);
    }

    @Test
    default public void userCanSpecifyContentTypeWhenDownloadingMessage(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("type", new Object[]{"text/plain"}).when().get(new StringBuilder(11).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).toString(), new Object[0])).then().statusCode(200).contentType("text/plain");
    }

    public static /* synthetic */ void userCanSpecifyContentTypeWhenDownloadingPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyContentTypeWhenDownloadingPart(server);
    }

    @Test
    default public void userCanSpecifyContentTypeWhenDownloadingPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("type", new Object[]{"text/markdown"}).when().get(new StringBuilder(13).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).append("_3").toString(), new Object[0])).then().statusCode(200).contentType("text/markdown");
    }

    public static /* synthetic */ void downloadPartShouldDiscardNameWhenNotSuppliedByTheClient$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartShouldDiscardNameWhenNotSuppliedByTheClient(server);
    }

    @Test
    default public void downloadPartShouldDiscardNameWhenNotSuppliedByTheClient(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String contentDisposition = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(13).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).append("_3").toString(), new Object[0])).then().statusCode(200).extract().header("Content-Disposition");
        Assertions.assertThat((String)contentDisposition).isNullOrEmpty();
    }

    public static /* synthetic */ void userCanSpecifyNameWhenDownloadingPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyNameWhenDownloadingPart(server);
    }

    @Test
    default public void userCanSpecifyNameWhenDownloadingPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("name", new Object[]{"gabouzomeuh.txt"}).when().get(new StringBuilder(13).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).append("_3").toString(), new Object[0])).then().statusCode(200).header("Content-Disposition", Matchers.containsString((String)"filename=\"gabouzomeuh.txt\""));
    }

    public static /* synthetic */ void downloadMessageShouldDiscardNameWhenNotSuppliedByTheClient$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldDiscardNameWhenNotSuppliedByTheClient(server);
    }

    @Test
    default public void downloadMessageShouldDiscardNameWhenNotSuppliedByTheClient(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String contentDisposition = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(11).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).toString(), new Object[0])).then().statusCode(200).extract().header("Content-Disposition");
        Assertions.assertThat((String)contentDisposition).isNullOrEmpty();
    }

    public static /* synthetic */ void userCanSpecifyNameWhenDownloadingMessage$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyNameWhenDownloadingMessage(server);
    }

    @Test
    default public void userCanSpecifyNameWhenDownloadingMessage(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("name", new Object[]{"gabouzomeuh.eml"}).when().get(new StringBuilder(11).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).toString(), new Object[0])).then().statusCode(200).header("Content-Disposition", Matchers.containsString((String)"filename=\"gabouzomeuh.eml\""));
    }

    public static /* synthetic */ void downloadNotExistingPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadNotExistingPart(server);
    }

    @Test
    default public void downloadNotExistingPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(15).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).append("_333").toString(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadInvalidPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadInvalidPart(server);
    }

    @Test
    default public void downloadInvalidPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(19).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).append("_invalid").toString(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadWithInvalidId$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadWithInvalidId(server);
    }

    @Test
    default public void downloadWithInvalidId(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(18).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/invalid").toString(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadWithNotFoundId$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadWithNotFoundId(server);
    }

    @Test
    default public void downloadWithNotFoundId(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(11).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(this.randomMessageId().serialize()).toString(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartWhenMessageNotFound$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartWhenMessageNotFound(server);
    }

    @Test
    default public void downloadPartWhenMessageNotFound(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(13).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(this.randomMessageId().serialize()).append("_3").toString(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartWhenMultipart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartWhenMultipart(server);
    }

    @Test
    default public void downloadPartWhenMultipart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(13).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(this.randomMessageId().serialize()).append("_2").toString(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartWhenTooMuchUnderscore$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartWhenTooMuchUnderscore(server);
    }

    @Test
    default public void downloadPartWhenTooMuchUnderscore(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get(new StringBuilder(15).append("/download/").append(DownloadContract$.MODULE$.accountId()).append("/").append(messageId.serialize()).append("_3_3").toString(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static void $init$(DownloadContract $this) {
    }
}

