/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.CustomNamespaceContract$;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0001<Qa\u0004\t\t\u0002u1Qa\b\t\t\u0002\u0001BQaJ\u0001\u0005\u0002!Bq!K\u0001C\u0002\u0013\u0005!\u0006\u0003\u00044\u0003\u0001\u0006Ia\u000b\u0005\bi\u0005\u0011\r\u0011\"\u0001+\u0011\u0019)\u0014\u0001)A\u0005W!9a'\u0001b\u0001\n\u0003Q\u0003BB\u001c\u0002A\u0003%1FB\u0004 !A\u0005\u0019\u0011\u0001\u001d\t\u000beJA\u0011\u0001\u001e\t\u000byJA\u0011A \t\u000bEKA\u0011\u0001*\t\u000baKA\u0011A-\t\u000bqKA\u0011A/\u0002/\r+8\u000f^8n\u001d\u0006lWm\u001d9bG\u0016\u001cuN\u001c;sC\u000e$(BA\t\u0013\u0003!\u0019wN\u001c;sC\u000e$(BA\n\u0015\u0003\u001d\u0011hm\u0019\u001d7eER!!\u0006\f\u0002\t)l\u0017\r\u001d\u0006\u0003/a\tQA[1nKNT!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u0001\u0001C\u0001\u0010\u0002\u001b\u0005\u0001\"aF\"vgR|WNT1nKN\u0004\u0018mY3D_:$(/Y2u'\t\t\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\tQdQ+T)>kuLT!N\u000bN\u0003\u0016iQ#`\u001b\u0006KEJQ(Y?B\u000bE\u000bS\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0006[>$W\r\u001c\u0006\u0003aY\tq!\\1jY\n|\u00070\u0003\u00023[\tYQ*Y5mE>D\b+\u0019;i\u0003y\u0019Uk\u0015+P\u001b~s\u0015)T#T!\u0006\u001bUiX'B\u00132\u0013u\nW0Q\u0003RC\u0005%A\u0010Q\u000bJ\u001bvJT!M?:\u000bU*R*Q\u0003\u000e+u,T!J\u0019\n{\u0005l\u0018)B)\"\u000b\u0001\u0005U#S'>s\u0015\tT0O\u00036+5\u000bU!D\u000b~k\u0015)\u0013'C\u001fb{\u0006+\u0011+IA\u0005\u0001C)\u0012'F\u000f\u0006#V\tR0O\u00036+5\u000bU!D\u000b~k\u0015)\u0013'C\u001fb{\u0006+\u0011+I\u0003\u0005\"U\tT#H\u0003R+Ei\u0018(B\u001b\u0016\u001b\u0006+Q\"F?6\u000b\u0015\n\u0014\"P1~\u0003\u0016\t\u0016%!'\tI\u0011%\u0001\u0004%S:LG\u000f\n\u000b\u0002wA\u0011!\u0005P\u0005\u0003{\r\u0012A!\u00168ji\u0006)1/\u001a;VaR\u00111\b\u0011\u0005\u0006\u0003.\u0001\rAQ\u0001\u0007g\u0016\u0014h/\u001a:\u0011\u0005\r#U\"\u0001\f\n\u0005\u00153\"\u0001E$vS\u000e,'*Y7fgN+'O^3sQ\tYq\t\u0005\u0002I\u001f6\t\u0011J\u0003\u0002K\u0017\u0006\u0019\u0011\r]5\u000b\u00051k\u0015a\u00026va&$XM\u001d\u0006\u0003\u001dj\tQA[;oSRL!\u0001U%\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u001bhKRl\u0015-\u001b7c_b\u001c\u0006n\\;mI&s7\r\\;eK\u000e+8\u000f^8n\u001d\u0006lWm\u001d9bG\u0016<\u0006.\u001a8BgN|7-[1uK\u0012$\"aO*\t\u000b\u0005c\u0001\u0019\u0001\")\u00051)\u0006C\u0001%W\u0013\t9\u0016J\u0001\u0003UKN$\u0018AN4fi6\u000b\u0017\u000e\u001c2pqNCw.\u001e7e\u0013:\u001cG.\u001e3f!\u0016\u00148o\u001c8bY:\u000bW.Z:qC\u000e,w\u000b[3o\u0003N\u001cxnY5bi\u0016$GCA\u001e[\u0011\u0015\tU\u00021\u0001CQ\tiQ+A\u001chKRl\u0015-\u001b7c_b\u001c\u0006n\\;mI&s7\r\\;eK\u0012+G.Z4bi\u0016$g*Y7fgB\f7-Z,iK:\f5o]8dS\u0006$X\r\u001a\u000b\u0003wyCQ!\u0011\bA\u0002\tC#AD+")
public interface CustomNamespaceContract {
    public static MailboxPath DELEGATED_NAMESPACE_MAILBOX_PATH() {
        return CustomNamespaceContract$.MODULE$.DELEGATED_NAMESPACE_MAILBOX_PATH();
    }

    public static MailboxPath PERSONAL_NAMESPACE_MAILBOX_PATH() {
        return CustomNamespaceContract$.MODULE$.PERSONAL_NAMESPACE_MAILBOX_PATH();
    }

    public static MailboxPath CUSTOM_NAMESPACE_MAILBOX_PATH() {
        return CustomNamespaceContract$.MODULE$.CUSTOM_NAMESPACE_MAILBOX_PATH();
    }

    public static /* synthetic */ void setUp$(CustomNamespaceContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void getMailboxShouldIncludeCustomNamespaceWhenAssociated$(CustomNamespaceContract $this, GuiceJamesServer server) {
        $this.getMailboxShouldIncludeCustomNamespaceWhenAssociated(server);
    }

    @Test
    default public void getMailboxShouldIncludeCustomNamespaceWhenAssociated(GuiceJamesServer server) {
        String mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(CustomNamespaceContract$.MODULE$.CUSTOM_NAMESPACE_MAILBOX_PATH()).serialize();
        String namespace = (String)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(379).append("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:mail\",\n           |    \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/get\",\n           |    {\n           |      \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n           |      \"ids\": [\"").append(mailboxId).append("\"]\n           |    },\n           |    \"c1\"]]\n           |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().jsonPath().get("methodResponses[0][1].list[0].namespace");
        Assertions.assertThat((String)namespace).isEqualTo("custom 123");
    }

    public static /* synthetic */ void getMailboxShouldIncludePersonalNamespaceWhenAssociated$(CustomNamespaceContract $this, GuiceJamesServer server) {
        $this.getMailboxShouldIncludePersonalNamespaceWhenAssociated(server);
    }

    @Test
    default public void getMailboxShouldIncludePersonalNamespaceWhenAssociated(GuiceJamesServer server) {
        String mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(CustomNamespaceContract$.MODULE$.PERSONAL_NAMESPACE_MAILBOX_PATH()).serialize();
        String namespace = (String)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(379).append("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:mail\",\n           |    \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/get\",\n           |    {\n           |      \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n           |      \"ids\": [\"").append(mailboxId).append("\"]\n           |    },\n           |    \"c1\"]]\n           |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().jsonPath().get("methodResponses[0][1].list[0].namespace");
        Assertions.assertThat((String)namespace).isEqualTo("Personal");
    }

    public static /* synthetic */ void getMailboxShouldIncludeDelegatedNamespaceWhenAssociated$(CustomNamespaceContract $this, GuiceJamesServer server) {
        $this.getMailboxShouldIncludeDelegatedNamespaceWhenAssociated(server);
    }

    @Test
    default public void getMailboxShouldIncludeDelegatedNamespaceWhenAssociated(GuiceJamesServer server) {
        String mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(CustomNamespaceContract$.MODULE$.DELEGATED_NAMESPACE_MAILBOX_PATH()).serialize();
        String namespace = (String)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(379).append("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:mail\",\n           |    \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/get\",\n           |    {\n           |      \"accountId\": \"").append(Fixture$.MODULE$.ACCOUNT_ID()).append("\",\n           |      \"ids\": [\"").append(mailboxId).append("\"]\n           |    },\n           |    \"c1\"]]\n           |}").toString()))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().jsonPath().get("methodResponses[0][1].list[0].namespace");
        Assertions.assertThat((String)namespace).isEqualTo("Delegated[bob@domain.tld]");
    }

    public static void $init$(CustomNamespaceContract $this) {
    }
}

