/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.http.Header;
import io.restassured.response.Validatable;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.rfc8621.contract.AuthenticationContract$;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015q!B\f\u0019\u0011\u0003)c!B\u0014\u0019\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004\"B\u0019\u0002\t\u0003\u0011daB\u0014\u0019!\u0003\r\ta\u0012\u0005\u0006\u0011\u0012!\t!\u0013\u0004\u0005\u0015\u0012\u00011\nC\u00030\r\u0011\u0005A\nC\u0003P\r\u0011\u0005\u0011J\u0002\u0003`\t\u0001\u0001\u0007\"B\u0018\n\t\u0003\t\u0007\"B2\n\t\u0003I\u0005\"B3\n\t\u0003I\u0005\"\u00025\n\t\u0003I\u0005\"\u00026\n\t\u0003I\u0005\"\u00027\n\t\u0003I\u0005\"\u00028\n\t\u0003I\u0005\"\u00029\n\t\u0003Ie\u0001\u0002;\u0005\u0001UDQa\f\n\u0005\u0002YDQ\u0001\u001f\n\u0005\u0002%CQa\u001f\n\u0005\u0002%CQA \n\u0005\u0002%\u000ba#Q;uQ\u0016tG/[2bi&|gnQ8oiJ\f7\r\u001e\u0006\u00033i\t\u0001bY8oiJ\f7\r\u001e\u0006\u00037q\tqA\u001d4dqY\u0012\u0014G\u0003\u0002\u001e=\u0005!!.\\1q\u0015\ty\u0002%A\u0003kC6,7O\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001\u0001\t\u0003M\u0005i\u0011\u0001\u0007\u0002\u0017\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0007>tGO]1diN\u0011\u0011!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0013!B:fiV\u0004HCA\u001a7!\tQC'\u0003\u00026W\t!QK\\5u\u0011\u001594\u00011\u00019\u0003\u0019\u0019XM\u001d<feB\u0011\u0011HO\u0007\u0002=%\u00111H\b\u0002\u0011\u000fVL7-\u001a&b[\u0016\u001c8+\u001a:wKJD#aA\u001f\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015aA1qS*\u0011!iQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!%%A\u0003kk:LG/\u0003\u0002G\u007f\tI!)\u001a4pe\u0016\fE\u000e\\\n\u0003\t%\na\u0001J5oSR$C#A\u001a\u00039\t{G\u000f[!vi\",g\u000e^5dCRLwN\\'fG\"\fg.[:ngN\u0011a!\u000b\u000b\u0002\u001bB\u0011aJB\u0007\u0002\t\u000513\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012$\u0004\u0007M,iK:\u0014u\u000e\u001e5BkRDWM\u001c;jG\u0006$\u0018n\u001c8)\u0005!\t\u0006C\u0001 S\u0013\t\u0019vH\u0001\u0003UKN$\b\u0006\u0002\u0005V1f\u0003\"A\u0010,\n\u0005]{$a\u0001+bO\u0006)a/\u00197vK\u0006\n!,\u0001\u0007CCNL7MR3biV\u0014X\r\u000b\u0002\u00079B\u0011a(X\u0005\u0003=~\u0012aAT3ti\u0016$'!\u0003\"bg&\u001c\u0017)\u001e;i'\tI\u0011\u0006F\u0001c!\tq\u0015\"A\u0017q_N$8\u000b[8vY\u0012\u0014Vm\u001d9p]\u0012$\u0004'M,iK:tu.Q;uQ>\u0014\u0018N_1uS>t\u0007*Z1eKJD#aC)\u0002MA|7\u000f^*i_VdGMU3ta>tGM\r\u00191/\",g\u000eS1t\u0007J,G-\u001a8uS\u0006d7\u000f\u000b\u0003\r+bK\u0006F\u0001\u0007R\u0003I\u0002xn\u001d;TQ>,H\u000e\u001a*fgB|g\u000e\u001a\u001b1c]CWM\\\"sK\u0012,g\u000e^5bYN<\u0016\u000e\u001e5J]Z\fG.\u001b3Vg\u0016\u0014\bFA\u0007R\u0003E\u0002xn\u001d;TQ>,H\u000e\u001a*fgB|g\u000e\u001a\u001a1a]CWM\\\"sK\u0012,g\u000e^5bYN<\u0016\u000e\u001e53\t>$Hi\\7bS:D#AD)\u0002eA|7\u000f^*i_VdGMU3ta>tG\r\u000e\u00192/\",gn\u0011:fI\u0016tG/[1mg^KG\u000f[*qC\u000e,Gi\\7bS:D#aD)\u0002IA|7\u000f^*i_VdGMU3ta>tG\r\u000e\u00192/\",g.V:fe:{GOR8v]\u0012D#\u0001E)\u0002KA|7\u000f^*i_VdGMU3ta>tG\r\u000e\u00192/\",gn\u0016:p]\u001e\u0004\u0016m]:x_J$\u0007\u0006B\tV1fC#!E))\u0005%a&a\u0002&X)\u0006+H\u000f[\n\u0003%%\"\u0012a\u001e\t\u0003\u001dJ\t!\u0007]8tiNCw.\u001e7e%\u0016$XO\u001d83aA:\u0006.\u001a8WC2LGMS<u\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8IK\u0006$WM\u001d\u0015\u0003)ECC\u0001F+Y3\u0006i\u0004o\\:u'\"|W\u000f\u001c3SKR,(O\u001c\u001b1c]CWM\u001c,bY&$WK\\6o_^tWk]3s\u0015^$\u0018)\u001e;i_JL'0\u0019;j_:DU-\u00193fe\"\"Q#\u0016-ZQ\t)\u0012+\u0001\u001bq_N$8\u000b[8vY\u0012\u0014V\r^;s]R\u0002\u0014g\u00165f]&sg/\u00197jI*;H/Q;uQ>\u0014\u0018N_1uS>t\u0007*Z1eKJDCAF+Y3\"\u0012a#\u0015\u0015\u0003%q\u0003")
public interface AuthenticationContract {
    @BeforeAll
    public static void setup(GuiceJamesServer server) {
        AuthenticationContract$.MODULE$.setup(server);
    }

    public static void $init$(AuthenticationContract $this) {
    }

    @Nested
    public class BasicAuth {
        @Test
        public void postShouldRespond401WhenNoAuthorizationHeader() {
            ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(401).header("WWW-Authenticate", "Basic realm=\"simple\", Bearer realm=\"JWT\"").body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"No valid authentication methods provided"), new Object[0]);
        }

        @Test
        @Tag(value="BasicFeature")
        public void postShouldRespond200WhenHasCredentials() {
            ((Validatable)RestAssured.given().headers(Fixture$.MODULE$.getHeadersWith(Fixture$.MODULE$.BOB_BASIC_AUTH_HEADER())).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(200);
        }

        @Test
        public void postShouldRespond401WhenCredentialsWithInvalidUser() {
            Header authHeader = new Header(Fixture$.MODULE$.AUTHORIZATION_HEADER(), new StringBuilder(6).append("Basic ").append(Fixture$.MODULE$.toBase64(new StringBuilder(3).append(Fixture$.MODULE$.BOB().getLocalPart()).append("@@").append(Fixture$.MODULE$.DOMAIN()).append(":").append(Fixture$.MODULE$.BOB_PASSWORD()).toString())).toString());
            ((Validatable)RestAssured.given().headers(Fixture$.MODULE$.getHeadersWith(authHeader)).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(401).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"Username is not valid"), new Object[0]);
        }

        @Test
        public void postShouldRespond200WhenCredentialsWith2DotDomain() {
            Header authHeader = new Header(Fixture$.MODULE$.AUTHORIZATION_HEADER(), new StringBuilder(6).append("Basic ").append(Fixture$.MODULE$.toBase64(new StringBuilder(1).append(Fixture$.MODULE$.ALICE().asString()).append(":").append(Fixture$.MODULE$.ALICE_PASSWORD()).toString())).toString());
            ((Validatable)RestAssured.given().headers(Fixture$.MODULE$.getHeadersWith(authHeader)).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(200);
        }

        @Test
        public void postShouldRespond401WhenCredentialsWithSpaceDomain() {
            Header authHeader = new Header(Fixture$.MODULE$.AUTHORIZATION_HEADER(), new StringBuilder(6).append("Basic ").append(Fixture$.MODULE$.toBase64(new StringBuilder(2).append(Fixture$.MODULE$.BOB().getLocalPart()).append("@").append(Fixture$.MODULE$.DOMAIN_WITH_SPACE()).append(":").append(Fixture$.MODULE$.BOB_PASSWORD()).toString())).toString());
            ((Validatable)RestAssured.given().headers(Fixture$.MODULE$.getHeadersWith(authHeader)).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(401).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"Username is not valid"), new Object[0]);
        }

        @Test
        public void postShouldRespond401WhenUserNotFound() {
            Header authHeader = new Header(Fixture$.MODULE$.AUTHORIZATION_HEADER(), new StringBuilder(6).append("Basic ").append(Fixture$.MODULE$.toBase64(new StringBuilder(14).append("usernotfound@").append(Fixture$.MODULE$.DOMAIN()).append(":").append(Fixture$.MODULE$.BOB_PASSWORD()).toString())).toString());
            ((Validatable)RestAssured.given().headers(Fixture$.MODULE$.getHeadersWith(authHeader)).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(401).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"Username is not valid"), new Object[0]);
        }

        @Test
        @Tag(value="BasicFeature")
        public void postShouldRespond401WhenWrongPassword() {
            Header authHeader = new Header(Fixture$.MODULE$.AUTHORIZATION_HEADER(), new StringBuilder(6).append("Basic ").append(Fixture$.MODULE$.toBase64(new StringBuilder(15).append(Fixture$.MODULE$.BOB().asString()).append(":WRONG_PASSWORD").toString())).toString());
            ((Validatable)RestAssured.given().headers(Fixture$.MODULE$.getHeadersWith(authHeader)).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(401).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"No valid authentication methods provided"), new Object[0]);
        }

        public /* synthetic */ AuthenticationContract org$apache$james$jmap$rfc8621$contract$AuthenticationContract$BasicAuth$$$outer() {
            return AuthenticationContract.this;
        }

        public BasicAuth() {
            if (AuthenticationContract.this == null) {
                throw null;
            }
        }
    }

    @Nested
    public class BothAuthenticationMechanisms {
        @Tag(value="BasicFeature")
        @Test
        public void shouldRespond400WhenBothAuthentication() {
            ((Validatable)RestAssured.given().headers(Fixture$.MODULE$.getHeadersWith(Fixture$.MODULE$.BOB_BASIC_AUTH_HEADER())).header(new Header(Fixture$.MODULE$.AUTHORIZATION_HEADER(), new StringBuilder(7).append("Bearer ").append(Fixture$.MODULE$.USER_TOKEN()).toString())).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(400).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)400)), new Object[0]).body("detail", Matchers.containsString((String)"Only one set of credential is allowed"), new Object[0]);
        }

        public /* synthetic */ AuthenticationContract org$apache$james$jmap$rfc8621$contract$AuthenticationContract$BothAuthenticationMechanisms$$$outer() {
            return AuthenticationContract.this;
        }

        public BothAuthenticationMechanisms() {
            if (AuthenticationContract.this == null) {
                throw null;
            }
        }
    }

    @Nested
    public class JWTAuth {
        @Tag(value="BasicFeature")
        @Test
        public void postShouldReturn200WhenValidJwtAuthorizationHeader() {
            ((Validatable)RestAssured.given().headers(Fixture$.MODULE$.getHeadersWith(new Header(Fixture$.MODULE$.AUTHORIZATION_HEADER(), new StringBuilder(7).append("Bearer ").append(Fixture$.MODULE$.USER_TOKEN()).toString()))).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(200);
        }

        @Test
        @Tag(value="BasicFeature")
        public void postShouldReturn401WhenValidUnknownUserJwtAuthorizationHeader() {
            Header authHeader = new Header(Fixture$.MODULE$.AUTHORIZATION_HEADER(), new StringBuilder(7).append("Bearer ").append(Fixture$.MODULE$.UNKNOWN_USER_TOKEN()).toString());
            ((Validatable)RestAssured.given().headers(Fixture$.MODULE$.getHeadersWith(authHeader)).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(401).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"Failed Jwt verification"), new Object[0]);
        }

        @Test
        @Tag(value="BasicFeature")
        public void postShouldReturn401WhenInvalidJwtAuthorizationHeader() {
            ((Validatable)RestAssured.given().headers(Fixture$.MODULE$.getHeadersWith(new Header(Fixture$.MODULE$.AUTHORIZATION_HEADER(), new StringBuilder(7).append("Bearer ").append(Fixture$.MODULE$.INVALID_JWT_TOKEN()).toString()))).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(401).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"Failed Jwt verification"), new Object[0]);
        }

        public /* synthetic */ AuthenticationContract org$apache$james$jmap$rfc8621$contract$AuthenticationContract$JWTAuth$$$outer() {
            return AuthenticationContract.this;
        }

        public JWTAuth() {
            if (AuthenticationContract.this == null) {
                throw null;
            }
        }
    }
}

