/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Instant;
import java.util.Optional;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.json.DTOModule;
import org.apache.james.json.JsonGenericSerializer;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueue;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueFactory;
import org.apache.james.webadmin.service.ClearMailQueueTask;
import org.apache.james.webadmin.service.RepublishNotProcessedMailsTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.RepublishNotProcessedMailsTaskDTO;
import org.apache.james.webadmin.service.RepublishNotprocessedMailsTask;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class RepublishNotprocessedMailsTaskTest {
    private static final Instant OLDER_THAN = Instant.parse("2018-11-13T12:00:55Z");
    private static final Instant NOW = Instant.now();
    private static final long NB_REQUEUED_MAILS = 12L;
    private static final String SERIALIZED = "{\"type\": \"republish-not-processed-mails\",\"mailQueue\":\"anyQueue\", \"olderThan\": \"" + OLDER_THAN + "\"}";
    private static final String SERIALIZED_TASK_ADDITIONAL_INFORMATION = "{\"type\": \"republish-not-processed-mails\",\"mailQueue\":\"anyQueue\", \"olderThan\": \"" + OLDER_THAN + "\" ,\"nbRequeuedMails\":12,\"timestamp\":\"" + NOW.toString() + "\"}";
    private static final MailQueueName QUEUE_NAME = MailQueueName.of((String)"anyQueue");
    private ClearMailQueueTask.MailQueueFactory queueFactory;

    RepublishNotprocessedMailsTaskTest() {
    }

    @BeforeEach
    void setUp() {
        RabbitMQMailQueueFactory mockedQueueFactory = (RabbitMQMailQueueFactory)Mockito.mock(RabbitMQMailQueueFactory.class);
        RabbitMQMailQueue mockedQueue = (RabbitMQMailQueue)Mockito.mock(RabbitMQMailQueue.class);
        Mockito.when((Object)mockedQueue.getName()).thenReturn((Object)QUEUE_NAME);
        Mockito.when((Object)mockedQueueFactory.getQueue(QUEUE_NAME)).thenReturn(Optional.of(mockedQueue));
        this.queueFactory = (ClearMailQueueTask.MailQueueFactory)Mockito.mock(ClearMailQueueTask.MailQueueFactory.class);
    }

    @Test
    void taskShouldBeSerializable() throws Exception {
        RepublishNotprocessedMailsTask task = new RepublishNotprocessedMailsTask(QUEUE_NAME, this.queueFactory, OLDER_THAN);
        JsonSerializationVerifier.dtoModule((DTOModule)RepublishNotProcessedMailsTaskDTO.module((ClearMailQueueTask.MailQueueFactory)this.queueFactory)).bean((Object)task).json(SERIALIZED).verify();
    }

    @Test
    void taskShouldBeDeserializable() throws Exception {
        RepublishNotprocessedMailsTask task = new RepublishNotprocessedMailsTask(QUEUE_NAME, this.queueFactory, OLDER_THAN);
        JsonSerializationVerifier.dtoModule((DTOModule)RepublishNotProcessedMailsTaskDTO.module((ClearMailQueueTask.MailQueueFactory)this.queueFactory)).bean((Object)task).json(SERIALIZED).verify();
    }

    @Test
    void additionalInformationShouldBeSerializable() throws Exception {
        RepublishNotprocessedMailsTask.AdditionalInformation details = new RepublishNotprocessedMailsTask.AdditionalInformation(QUEUE_NAME, OLDER_THAN, 12L, NOW);
        JsonSerializationVerifier.dtoModule((DTOModule)RepublishNotProcessedMailsTaskAdditionalInformationDTO.module()).bean((Object)details).json(SERIALIZED_TASK_ADDITIONAL_INFORMATION).verify();
    }

    @Test
    void additionalInformationShouldBeDeserializable() throws Exception {
        RepublishNotprocessedMailsTask.AdditionalInformation details = new RepublishNotprocessedMailsTask.AdditionalInformation(QUEUE_NAME, OLDER_THAN, 12L, NOW);
        RepublishNotprocessedMailsTask.AdditionalInformation deserialized = (RepublishNotprocessedMailsTask.AdditionalInformation)JsonGenericSerializer.forModules((DTOModule[])new DTOModule[]{RepublishNotProcessedMailsTaskAdditionalInformationDTO.module()}).withoutNestedType().deserialize(SERIALIZED_TASK_ADDITIONAL_INFORMATION);
        Assertions.assertThat((Object)deserialized).isEqualToComparingFieldByField((Object)details);
    }
}

