/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableSet;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueue;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueFactory;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.utils.UpdatableTickingClock;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.RabbitMQMailQueuesRoutes;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class RabbitMQMailQueuesRoutesTest {
    static final ZonedDateTime DATE = ZonedDateTime.parse("2015-10-30T14:12:00Z");
    WebAdminServer webAdminServer;
    MailQueueFactory mailQueueFactory;
    Clock clock;

    RabbitMQMailQueuesRoutesTest() {
    }

    WebAdminServer createServer(MailQueueFactory mailQueueFactory) {
        MemoryTaskManager taskManager = new MemoryTaskManager(new Hostname("foo"));
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        this.clock = UpdatableTickingClock.fixed((Instant)DATE.toInstant(), (ZoneId)ZoneOffset.UTC);
        return WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new RabbitMQMailQueuesRoutes(mailQueueFactory, this.clock, jsonTransformer, (TaskManager)taskManager, (Set)ImmutableSet.of()), new TasksRoutes((TaskManager)taskManager, jsonTransformer, DTOConverter.of((DTOModule[])new DTOModule[0]))}).start();
    }

    RequestSpecification buildRequestSpecification(WebAdminServer server) {
        return new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setBasePath("/").setPort(server.getPort().getValue()).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).build();
    }

    @BeforeEach
    void setUp() {
        this.mailQueueFactory = (MailQueueFactory)Mockito.mock(RabbitMQMailQueueFactory.class);
        this.webAdminServer = this.createServer(this.mailQueueFactory);
        RestAssured.requestSpecification = this.buildRequestSpecification(this.webAdminServer);
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
    }

    @Test
    void triggeringARepublishNotProcessedMailsShouldCreateATask() {
        Mockito.when((Object)this.mailQueueFactory.getQueue((MailQueueName)Mockito.any())).thenReturn(Optional.of((RabbitMQMailQueue)Mockito.mock(RabbitMQMailQueue.class)));
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"RepublishNotProcessedMails"}).queryParam("olderThan", new Object[]{"1d"}).when().post("/mailQueues/spooler", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/tasks", new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)1), new Object[0]);
    }

    @Test
    void triggeringARepublishNotProcessedMailsWhenTheQueueHasNotBeenInitializedShouldFail() {
        Mockito.when((Object)this.mailQueueFactory.getQueue((MailQueueName)Mockito.any())).thenReturn(Optional.empty());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"RepublishNotProcessedMails"}).queryParam("olderThan", new Object[]{"1d"}).when().post("/mailQueues/spooler", new Object[0])).then()).statusCode(404)).body("message", Matchers.containsString((String)"MailQueueName{value=spooler} can not be found"), new Object[0]);
    }

    @Test
    void triggeringARepublishNotProcessedMailsWithAnInvalidOlderThanShouldFail() {
        Mockito.when((Object)this.mailQueueFactory.getQueue((MailQueueName)Mockito.any())).thenReturn(Optional.of((RabbitMQMailQueue)Mockito.mock(RabbitMQMailQueue.class)));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("action", new Object[]{"RepublishNotProcessedMails"}).queryParam("olderThan", new Object[]{"invalidValue"}).when().post("/mailQueues/spooler", new Object[0])).then()).statusCode(400)).body("message", Matchers.containsString((String)"Invalid olderThan"), new Object[0])).body("details", Matchers.containsString((String)"Supplied value do not follow the unit format (number optionally suffixed with a string representing the unit"), new Object[0]);
    }
}

