/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import com.google.inject.Module;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.apache.james.CassandraJmapTestRule;
import org.apache.james.DockerCassandraRule;
import org.apache.james.GuiceJamesServer;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.integration.WebAdminConfigurationModule;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class WebAdminServerIntegrationTest {
    private static final String DOMAIN = "domain";
    private static final String USERNAME = "username@domain";
    private static final String SPECIFIC_DOMAIN = "/domains/domain";
    private static final String SPECIFIC_USER = "/users/username@domain";
    private static final String MAILBOX = "mailbox";
    private static final String SPECIFIC_MAILBOX = "/users/username@domain/mailboxes/mailbox";
    private static final String VERSION = "/cassandra/version";
    private static final String VERSION_LATEST = "/cassandra/version/latest";
    private static final String UPGRADE_VERSION = "/cassandra/version/upgrade";
    private static final String UPGRADE_TO_LATEST_VERSION = "/cassandra/version/upgrade/latest";
    @ClassRule
    public static DockerCassandraRule cassandra = new DockerCassandraRule();
    @Rule
    public CassandraJmapTestRule cassandraJmapTestRule = CassandraJmapTestRule.defaultTestRule();
    private GuiceJamesServer guiceJamesServer;
    private DataProbe dataProbe;

    @Before
    public void setUp() throws Exception {
        this.guiceJamesServer = this.cassandraJmapTestRule.jmapServer(new Module[]{cassandra.getModule()}).overrideWith(new Module[]{new WebAdminConfigurationModule()});
        this.guiceJamesServer.start();
        this.dataProbe = (DataProbe)this.guiceJamesServer.getProbe(DataProbeImpl.class);
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)this.guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
    }

    @After
    public void tearDown() {
        this.guiceJamesServer.stop();
    }

    @Test
    public void postShouldAddTheGivenDomain() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.when().put(SPECIFIC_DOMAIN, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((List)this.dataProbe.listDomains()).contains((Object[])new String[]{DOMAIN});
    }

    @Test
    public void mailQueueRoutesShouldBeExposed() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/mailQueues", new Object[0])).then()).statusCode(200);
    }

    @Test
    public void mailRepositoriesRoutesShouldBeExposed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("mailRepositories", new Object[0])).then()).statusCode(200)).body("repository", Matchers.containsInAnyOrder((Object[])new String[]{"var/mail/error/", "var/mail/relay-denied/", "var/mail/address-error/"}), new Object[0]);
    }

    @Test
    public void gettingANonExistingMailRepositoryShouldNotCreateIt() {
        RestAssured.given().get("mailRepositoriesfile%3A%2F%2Fvar%2Fmail%2Fcustom%2F", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("mailRepositories", new Object[0])).then()).statusCode(200)).body("repository", Matchers.containsInAnyOrder((Object[])new String[]{"var/mail/error/", "var/mail/relay-denied/", "var/mail/address-error/"}), new Object[0]);
    }

    @Test
    public void deleteShouldRemoveTheGivenDomain() throws Exception {
        this.dataProbe.addDomain(DOMAIN);
        ((ValidatableResponse)((Response)RestAssured.when().delete(SPECIFIC_DOMAIN, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((List)this.dataProbe.listDomains()).doesNotContain((Object[])new String[]{DOMAIN});
    }

    @Test
    public void postShouldAddTheUser() throws Exception {
        this.dataProbe.addDomain(DOMAIN);
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(SPECIFIC_USER, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Object[])this.dataProbe.listUsers()).contains((Object[])new String[]{USERNAME});
    }

    @Test
    public void deleteShouldRemoveTheUser() throws Exception {
        this.dataProbe.addDomain(DOMAIN);
        this.dataProbe.addUser(USERNAME, "anyPassword");
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"username\":\"username@domain\",\"password\":\"password\"}").when().delete(SPECIFIC_USER, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Object[])this.dataProbe.listUsers()).doesNotContain((Object[])new String[]{USERNAME});
    }

    @Test
    public void getUsersShouldDisplayUsers() throws Exception {
        this.dataProbe.addDomain(DOMAIN);
        this.dataProbe.addUser(USERNAME, "anyPassword");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/users", new Object[0])).then()).statusCode(200)).contentType("application/json")).body(Matchers.is((Object)"[{\"username\":\"username@domain\"}]"), new Matcher[0]);
    }

    @Test
    public void putMailboxShouldAddAMailbox() throws Exception {
        this.dataProbe.addDomain(DOMAIN);
        this.dataProbe.addUser(USERNAME, "anyPassword");
        ((ValidatableResponse)((Response)RestAssured.when().put(SPECIFIC_MAILBOX, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Iterable)((MailboxProbeImpl)this.guiceJamesServer.getProbe(MailboxProbeImpl.class)).listUserMailboxes(USERNAME)).containsExactly((Object[])new String[]{MAILBOX});
    }

    @Test
    public void deleteMailboxShouldRemoveAMailbox() throws Exception {
        this.dataProbe.addDomain(DOMAIN);
        this.dataProbe.addUser(USERNAME, "anyPassword");
        ((MailboxProbeImpl)this.guiceJamesServer.getProbe(MailboxProbeImpl.class)).createMailbox("#private", USERNAME, MAILBOX);
        ((ValidatableResponse)((Response)RestAssured.when().delete(SPECIFIC_MAILBOX, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Iterable)((MailboxProbeImpl)this.guiceJamesServer.getProbe(MailboxProbeImpl.class)).listUserMailboxes(USERNAME)).isEmpty();
    }

    @Test
    public void getCurrentVersionShouldReturnNullForCurrentVersionAsBeginning() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(VERSION, new Object[0])).then()).statusCode(200)).contentType("application/json")).body(Matchers.is((Object)"{\"version\":null}"), new Matcher[0]);
    }

    @Test
    public void getLatestVersionShouldReturnTheConfiguredLatestVersion() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(VERSION_LATEST, new Object[0])).then()).statusCode(200)).contentType("application/json")).body(Matchers.is((Object)("{\"version\":" + CassandraSchemaVersionManager.MAX_VERSION.getValue() + "}")), new Matcher[0]);
    }

    @Test
    public void postShouldDoMigrationAndUpdateCurrentVersion() {
        String taskId = (String)((Response)RestAssured.with().body(String.valueOf(CassandraSchemaVersionManager.MAX_VERSION.getValue())).post(UPGRADE_VERSION, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().get("/task/" + taskId + "/await", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(VERSION, new Object[0])).then()).statusCode(200)).contentType("application/json")).body(Matchers.is((Object)("{\"version\":" + CassandraSchemaVersionManager.MAX_VERSION.getValue() + "}")), new Matcher[0]);
    }

    @Test
    public void postShouldDoMigrationAndUpdateToTheLatestVersion() {
        String taskId = (String)((Response)RestAssured.with().post(UPGRADE_TO_LATEST_VERSION, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().get("/task/" + taskId + "/await", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(VERSION, new Object[0])).then()).statusCode(200)).contentType("application/json")).body(Matchers.is((Object)("{\"version\":" + CassandraSchemaVersionManager.MAX_VERSION.getValue() + "}")), new Matcher[0]);
    }

    @Test
    public void addressGroupsEndpointShouldHandleRequests() throws Exception {
        this.dataProbe.addGroupMapping("group", "domain.com", "user1@domain.com");
        this.dataProbe.addGroupMapping("group", "domain.com", "user2@domain.com");
        List members = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/address/groups/group@domain.com", new Object[0])).then()).statusCode(200)).contentType("application/json")).extract().jsonPath().getList(".");
        Assertions.assertThat((List)members).containsOnly((Object[])new String[]{"user1@domain.com", "user2@domain.com"});
    }

    @Test
    public void addressForwardsEndpointShouldListForwardAddresses() throws Exception {
        this.dataProbe.addForwardMapping("from1", "domain.com", "user1@domain.com");
        this.dataProbe.addForwardMapping("from2", "domain.com", "user2@domain.com");
        List members = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/address/forwards", new Object[0])).then()).statusCode(200)).contentType("application/json")).extract().jsonPath().getList(".");
        Assertions.assertThat((List)members).containsOnly((Object[])new String[]{"from1@domain.com", "from2@domain.com"});
    }

    @Test
    public void getSwaggerShouldReturnJsonDataForSwagger() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/james-swagger", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"\"swagger\":\"2.0\""), new Matcher[0])).body(Matchers.containsString((String)"\"info\":{\"description\":\"All the web administration API for JAMES\",\"version\":\"V1.0\",\"title\":\"JAMES Web Admin API\"}"), new Matcher[0])).body(Matchers.containsString((String)"\"tags\":[\"User's Mailbox\"]"), new Matcher[0])).body(Matchers.containsString((String)"\"tags\":[\"GlobalQuota\"]"), new Matcher[0])).body(Matchers.containsString((String)"\"tags\":[\"DomainQuota\"]"), new Matcher[0])).body(Matchers.containsString((String)"\"tags\":[\"UserQuota\"]"), new Matcher[0])).body(Matchers.containsString((String)"\"tags\":[\"Domains\"]"), new Matcher[0])).body(Matchers.containsString((String)"\"tags\":[\"Users\"]"), new Matcher[0])).body(Matchers.containsString((String)"\"tags\":[\"MailRepositories\"]"), new Matcher[0])).body(Matchers.containsString((String)"\"tags\":[\"MailQueues\"]"), new Matcher[0])).body(Matchers.containsString((String)"\"tags\":[\"Address Forwards\"]"), new Matcher[0])).body(Matchers.containsString((String)"\"tags\":[\"Address Groups\"]"), new Matcher[0])).body(Matchers.containsString((String)"{\"name\":\"ReIndexing\"}"), new Matcher[0])).body(Matchers.containsString((String)"{\"name\":\"MessageIdReIndexing\"}"), new Matcher[0]);
    }

    @Test
    public void validateHealthChecksShouldReturnOk() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/healthcheck", new Object[0])).then()).statusCode(200);
    }
}

