/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.GuiceJamesServer;
import org.apache.james.util.Port;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.integration.CassandraJmapExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@ExtendWith(value={CassandraJmapExtension.class})
class UnauthorizedEndpointsTest {
    UnauthorizedEndpointsTest() {
    }

    @BeforeEach
    void setup(GuiceJamesServer james) {
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)james.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
    }

    @ParameterizedTest
    @ValueSource(strings={"/cassandra/version", "/cassandra/version/latest", "/dlp/rules/james.org", "/domainMappings", "/domainMappings/from.com", "/quota/domains/james.org", "/quota/domains/james.org/count", "/quota/domains/james.org/size", "/domains", "/users/someuser/mailboxes", "/users/someuser/mailboxes/mymailbox", "/quota/users", "/quota/users/joe@perdu.com", "/quota/users/joe@perdu.com/count", "/quota/users/joe@perdu.com/size", "/users", "address/forwards", "address/forwards/alice@james.org", "/quota", "/quota/count", "/quota/size", "address/groups", "address/groups/group@james.org", "/mailQueues/first_queue", "mailRepositories", "mailRepositories/myRepo", "mailRepositories/myRepo/mails", "mailRepositories/myRepo/mails/1", "/sieve/quota/default", "/sieve/quota/users/user@james.org", "/tasks", "/tasks/taskId", "/tasks/taskId/await"})
    void checkUrlProtectionOnGet(String url) {
        ((ValidatableResponse)((Response)RestAssured.when().get(url, new Object[0])).then()).statusCode(401);
    }

    @ParameterizedTest
    @ValueSource(strings={"/cassandra/version/upgrade", "/cassandra/version/upgrade/latest"})
    void checkUrlProtectionOnPost(String url) {
        ((ValidatableResponse)((Response)RestAssured.when().post(url, new Object[0])).then()).statusCode(401);
    }

    @ParameterizedTest
    @ValueSource(strings={"/dlp/rules/james.org", "/domainMappings/from.com", "/quota/domains/james.org/count", "/quota/domains/james.org/size", "/quota/domains/james.org", "/domains/james.org", "/users/someuser/mailboxes/mymailbox", "/quota/users/joe@perdu.com", "/quota/users/joe@perdu.com/count", "/quota/users/joe@perdu.com/size", "/users/user@james.org", "address/forwards/alice@james.org/bob@james.org", "/quota/count", "/quota/size", "/quota", "address/groups/group@james.org/user@james.org", "mailRepositories/myRepo", "/sieve/quota/default", "/sieve/quota/users/user@james.org"})
    void checkUrlProtectionOnPut(String url) {
        ((ValidatableResponse)((Response)RestAssured.when().put(url, new Object[0])).then()).statusCode(401);
    }

    @ParameterizedTest
    @ValueSource(strings={"/dlp/rules/james.org", "/quota/domains/james.org/count", "/quota/domains/james.org/size", "/domainMappings/from.com", "/domains/james.org", "/users/someuser/mailboxes", "/users/someuser/mailboxes/mymailbox", "/quota/users/joe@perdu.com/count", "/quota/users/joe@perdu.com/size", "/users/user@james.org", "address/forwards/alice@james.org/bob@james.org", "/quota/count", "/quota/size", "address/groups/group@james.org/user@james.org", "/mailQueues", "/mailQueues/first_queue/mails", "/mailQueues/second_queue/mails", "mailRepositories/myRepo/mails/1", "mailRepositories/myRepo/mails", "/sieve/quota/default", "/sieve/quota/users/user@james.org", "/tasks/taskId"})
    void checkUrlProtectionOnDelete(String url) {
        ((ValidatableResponse)((Response)RestAssured.when().delete(url, new Object[0])).then()).statusCode(401);
    }

    @ParameterizedTest
    @ValueSource(strings={"/mailQueues/first_queue/mails", "mailRepositories/myRepo/mails", "mailRepositories/myRepo/mails/name1"})
    void checkUrlProtectionOnPath(String url) {
        ((ValidatableResponse)((Response)RestAssured.when().patch(url, new Object[0])).then()).statusCode(401);
    }
}

