/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import com.google.inject.Module;
import java.io.IOException;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerCassandraRule;
import org.apache.james.GuiceJamesServer;
import org.apache.james.backends.es.EmbeddedElasticSearch;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.store.search.PDFTextExtractor;
import org.apache.james.modules.TestESMetricReporterModule;
import org.apache.james.modules.TestElasticSearchModule;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.util.Runnables;
import org.apache.james.webadmin.integration.UnauthorizedModule;
import org.apache.james.webadmin.integration.WebAdminConfigurationModule;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.rules.TemporaryFolder;

public class CassandraJmapExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final int LIMIT_TO_20_MESSAGES = 20;
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final DockerCassandraRule cassandra = new DockerCassandraRule();
    private final EmbeddedElasticSearch elasticSearch = new EmbeddedElasticSearch(this.temporaryFolder);
    private GuiceJamesServer james;

    private GuiceJamesServer james() throws IOException {
        Configuration configuration = Configuration.builder().workingDirectory(this.temporaryFolder.newFolder()).configurationFromClasspath().build();
        return GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{CassandraJamesServerMain.ALL_BUT_JMX_CASSANDRA_MODULE}).overrideWith(new Module[]{binder -> binder.bind(TextExtractor.class).to(PDFTextExtractor.class)}).overrideWith(new Module[]{new TestJMAPServerModule(20L)}).overrideWith(new Module[]{new TestESMetricReporterModule()}).overrideWith(new Module[]{this.cassandra.getModule()}).overrideWith(new Module[]{new TestElasticSearchModule(this.elasticSearch)}).overrideWith(new Module[]{new WebAdminConfigurationModule()}).overrideWith(new Module[]{new UnauthorizedModule()});
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.temporaryFolder.create();
        Runnable[] runnableArray = new Runnable[2];
        runnableArray[0] = () -> ((DockerCassandraRule)this.cassandra).start();
        runnableArray[1] = () -> ((EmbeddedElasticSearch)this.elasticSearch).before();
        Runnables.runParallel((Runnable[])runnableArray);
    }

    public void afterAll(ExtensionContext context) {
        this.elasticSearch.after();
        Runnable[] runnableArray = new Runnable[2];
        runnableArray[0] = () -> ((DockerCassandraRule)this.cassandra).stop();
        runnableArray[1] = () -> ((EmbeddedElasticSearch)this.elasticSearch).after();
        Runnables.runParallel((Runnable[])runnableArray);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.james = this.james();
        this.james.start();
    }

    public void afterEach(ExtensionContext context) {
        this.james.stop();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == GuiceJamesServer.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.james;
    }
}

