/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import com.google.inject.Module;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.CassandraJmapTestRule;
import org.apache.james.DockerCassandraRule;
import org.apache.james.GuiceJamesServer;
import org.apache.james.util.Port;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.integration.UnauthorizedModule;
import org.apache.james.webadmin.integration.WebAdminConfigurationModule;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class AuthorizedEndpointsTest {
    @ClassRule
    public static DockerCassandraRule cassandra = new DockerCassandraRule();
    @Rule
    public CassandraJmapTestRule cassandraJmapTestRule = CassandraJmapTestRule.defaultTestRule();
    private GuiceJamesServer guiceJamesServer;

    @Before
    public void setUp() throws Exception {
        this.guiceJamesServer = this.cassandraJmapTestRule.jmapServer(new Module[]{cassandra.getModule(), new UnauthorizedModule()}).overrideWith(new Module[]{new WebAdminConfigurationModule()});
        this.guiceJamesServer.start();
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)this.guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
    }

    @After
    public void tearDown() {
        this.guiceJamesServer.stop();
    }

    @Test
    public void getHealthchecksShouldNotNeedAuthentication() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/healthcheck", new Object[0])).then()).statusCode(IsNot.not((Object)401));
    }
}

