/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import com.google.common.base.Charsets;
import com.google.inject.Module;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.builder.RequestSpecBuilder;
import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.config.RestAssuredConfig;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.response.ValidatableResponse;
import java.util.List;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.GuiceJamesServer;
import org.apache.james.backends.cassandra.EmbeddedCassandra;
import org.apache.james.mailbox.elasticsearch.EmbeddedElasticSearch;
import org.apache.james.modules.CassandraJmapServerModule;
import org.apache.james.webadmin.Port;
import org.apache.james.webadmin.integration.WebAdminConfigurationModule;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class WebAdminServerIntegrationTest {
    public static final String DOMAIN = "domain";
    public static final String USERNAME = "username@domain";
    public static final String SPECIFIC_DOMAIN = "/domains/domain";
    public static final String SPECIFIC_USER = "/users/username@domain";
    public static final String MAILBOX = "mailbox";
    public static final String SPECIFIC_MAILBOX = "/users/username@domain/mailboxes/mailbox";
    private TemporaryFolder temporaryFolder = new TemporaryFolder();
    private EmbeddedElasticSearch embeddedElasticSearch = new EmbeddedElasticSearch(this.temporaryFolder);
    private EmbeddedCassandra cassandra = EmbeddedCassandra.createStartServer();
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.temporaryFolder).around((TestRule)this.embeddedElasticSearch);
    private GuiceJamesServer guiceJamesServer;

    @Before
    public void setUp() throws Exception {
        this.guiceJamesServer = new GuiceJamesServer().combineWith(new Module[]{CassandraJamesServerMain.cassandraServerModule}).overrideWith(new Module[]{new CassandraJmapServerModule(this.temporaryFolder, this.embeddedElasticSearch, this.cassandra), new WebAdminConfigurationModule()});
        this.guiceJamesServer.start();
        RestAssured.requestSpecification = new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(Charsets.UTF_8))).setPort(((Port)this.guiceJamesServer.getWebadminPort().orElseThrow(() -> new RuntimeException("Unable to locate Web Admin port"))).toInt()).build();
    }

    @After
    public void tearDown() {
        this.guiceJamesServer.stop();
    }

    @Test
    public void postShouldAddTheGivenDomain() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.when().put(SPECIFIC_DOMAIN, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((List)this.guiceJamesServer.serverProbe().listDomains()).contains((Object[])new String[]{DOMAIN});
    }

    @Test
    public void deleteShouldRemoveTheGivenDomain() throws Exception {
        this.guiceJamesServer.serverProbe().addDomain(DOMAIN);
        ((ValidatableResponse)((Response)RestAssured.when().delete(SPECIFIC_DOMAIN, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((List)this.guiceJamesServer.serverProbe().listDomains()).doesNotContain((Object[])new String[]{DOMAIN});
    }

    @Test
    public void postShouldAddTheUser() throws Exception {
        this.guiceJamesServer.serverProbe().addDomain(DOMAIN);
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(SPECIFIC_USER, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Object[])this.guiceJamesServer.serverProbe().listUsers()).contains((Object[])new String[]{USERNAME});
    }

    @Test
    public void deleteShouldRemoveTheUser() throws Exception {
        this.guiceJamesServer.serverProbe().addDomain(DOMAIN);
        this.guiceJamesServer.serverProbe().addUser(USERNAME, "anyPassword");
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"username\":\"username@domain\",\"password\":\"password\"}").when().delete(SPECIFIC_USER, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Object[])this.guiceJamesServer.serverProbe().listUsers()).doesNotContain((Object[])new String[]{USERNAME});
    }

    @Test
    public void getUsersShouldDisplayUsers() throws Exception {
        this.guiceJamesServer.serverProbe().addDomain(DOMAIN);
        this.guiceJamesServer.serverProbe().addUser(USERNAME, "anyPassword");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/users", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"[{\"username\":\"username@domain\"}]"), new Matcher[0]);
    }

    @Test
    public void putMailboxShouldAddAMailbox() throws Exception {
        this.guiceJamesServer.serverProbe().addDomain(DOMAIN);
        this.guiceJamesServer.serverProbe().addUser(USERNAME, "anyPassword");
        ((ValidatableResponse)((Response)RestAssured.when().put(SPECIFIC_MAILBOX, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Iterable)this.guiceJamesServer.serverProbe().listUserMailboxes(USERNAME)).containsExactly((Object[])new String[]{MAILBOX});
    }

    @Test
    public void deleteMailboxShouldRemoveAMailbox() throws Exception {
        this.guiceJamesServer.serverProbe().addDomain(DOMAIN);
        this.guiceJamesServer.serverProbe().addUser(USERNAME, "anyPassword");
        this.guiceJamesServer.serverProbe().createMailbox("#private", USERNAME, MAILBOX);
        ((ValidatableResponse)((Response)RestAssured.when().delete(SPECIFIC_MAILBOX, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Iterable)this.guiceJamesServer.serverProbe().listUserMailboxes(USERNAME)).isEmpty();
    }
}

