/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class JsonExtractorTest {
    private JsonExtractor<Request> jsonExtractor;

    @Before
    public void setUp() {
        this.jsonExtractor = new JsonExtractor(Request.class);
    }

    @Test
    public void parseShouldThrowOnNullInput() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            Request cfr_ignored_0 = (Request)this.jsonExtractor.parse(null);
        }).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void parseShouldThrowOnEmptyInput() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            Request cfr_ignored_0 = (Request)this.jsonExtractor.parse("");
        }).isInstanceOf(JsonExtractException.class);
    }

    @Test
    public void parseShouldThrowOnBrokenJson() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            Request cfr_ignored_0 = (Request)this.jsonExtractor.parse("{\"field1\":\"broken");
        }).isInstanceOf(JsonExtractException.class);
    }

    @Test
    public void parseShouldThrowOnEmptyJson() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            Request cfr_ignored_0 = (Request)this.jsonExtractor.parse("{}");
        }).isInstanceOf(JsonExtractException.class);
    }

    @Test
    public void parseShouldThrowOnMissingMandatoryField() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            Request cfr_ignored_0 = (Request)this.jsonExtractor.parse("{\"field1\":\"any\"}");
        }).isInstanceOf(JsonExtractException.class);
    }

    @Test
    public void parseShouldThrowOnValidationProblemIllegalArgumentException() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            Request cfr_ignored_0 = (Request)this.jsonExtractor.parse("{\"field1\":\"\",\"field2\":\"any\"}");
        }).isInstanceOf(JsonExtractException.class);
    }

    @Test
    public void parseShouldThrowOnValidationProblemNPE() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            Request cfr_ignored_0 = (Request)this.jsonExtractor.parse("{\"field1\":null,\"field2\":\"any\"}");
        }).isInstanceOf(JsonExtractException.class);
    }

    @Test
    public void parseShouldThrowOnExtraFiled() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            Request cfr_ignored_0 = (Request)this.jsonExtractor.parse("{\"field1\":\"value\",\"field2\":\"any\",\"extra\":\"extra\"}");
        }).isInstanceOf(JsonExtractException.class);
    }

    @Test
    public void parseShouldInstantiateDestinationClass() throws Exception {
        String field1 = "value1";
        String field2 = "value2";
        Request request = (Request)this.jsonExtractor.parse("{\"field1\":\"" + field1 + "\",\"field2\":\"" + field2 + "\"}");
        Assertions.assertThat((String)request.getField1()).isEqualTo((Object)field1);
        Assertions.assertThat((String)request.getField2()).isEqualTo((Object)field2);
    }

    static class Request {
        private final String field1;
        private final String field2;

        @JsonCreator
        public Request(@JsonProperty(value="field1") String field1, @JsonProperty(value="field2") String field2) {
            Preconditions.checkNotNull((Object)field1);
            Preconditions.checkNotNull((Object)field2);
            Preconditions.checkArgument((!field1.isEmpty() ? 1 : 0) != 0);
            this.field1 = field1;
            this.field2 = field2;
        }

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }
    }
}

